/**************************************************************************************
* @file         : <RearViewCamera.cpp>
* @author       : <ECG> <INF4CV> Sathiya Jayanth Raman
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include <vector>
#include "hall_std_if.h"
#include "RearViewCamera.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
//#include "RVCBrightnessHandler.h"
#include "App/Core/AppLogic/RVCSettingListHandler/RVCBrightnessHandler/RVCBrightnessHandler.h"
#include "App/Core/AppLogic/RVCSettingListHandler/RVCContrastHandler/RVCContrastHandler.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                  RearViewCamera::
#include "trcGenProj/Header/RearViewCamera.cpp.trc.h"
#endif

#if !defined RVC_ENABLED
#define RVC_ENABLED 1
#endif
#if !defined RVC_DISABLED
#define RVC_DISABLED 0
#endif
using namespace ::rvc_cca_fi;
using namespace ::rvc_cca_fi_types;
using namespace ::App::Core;
using namespace ::asf::core;
using namespace ::vehicle_main_fi_types;

namespace App {
namespace Core {

RearViewCamera* RearViewCamera::_RearViewClient = NULL;

RearViewCamera::RearViewCamera(): m_poRvcFiProxy(::rvc_cca_fi::Rvc_cca_fiProxy::createProxy("rvcFiPort", *this))
{
   ETG_I_REGISTER_FILE();
   _currentrvcbrightnessStatus = false;

   ETG_TRACE_USR4(("RearViewCamera Constructor is called"));

   if (m_poRvcFiProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, m_poRvcFiProxy->getPortName());
      ETG_TRACE_USR4(("RearViewCamera Constructor after creating proxy"));
      CreateMapVehLangtoRVCLang();
   }
   videoproperty = 0;
}


RearViewCamera::~RearViewCamera()
{
   ETG_TRACE_USR4(("RearViewCamera destructor is called"));
   destroy();
}


void RearViewCamera::destroy()
{
   delete _RearViewClient;
   _RearViewClient = NULL;
}


void RearViewCamera::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /* proxy */, const asf::core::ServiceStateChange& /* stateChange */)
{
   ETG_TRACE_USR4(("RearViewCamera Service registerProperties"));
}


void RearViewCamera::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /* proxy */, const asf::core::ServiceStateChange& /* stateChange */)
{
   ETG_TRACE_USR4(("RearViewCamera Service deregisterProperties"));
}


void RearViewCamera::onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& /* proxy */, const ::asf::core::ServiceStateChange& /* stateChange */)
{
   ETG_TRACE_USR4(("RearViewCamera Service onAvailable"));
   m_poRvcFiProxy->sendReverseSignalStatusUpReg(*this);
}


void RearViewCamera::onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& /* proxy */, const ::asf::core::ServiceStateChange& /* stateChange */)
{
   ETG_TRACE_USR4(("RearViewCamera Service onUnavailable"));
   m_poRvcFiProxy->sendReverseSignalStatusRelUpRegAll();
}


void RearViewCamera::onReverseSignalStatusError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusError >& /*error*/)
{
   ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusError"));
}


void RearViewCamera::onReverseSignalStatusStatus(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /*proxy*/, const ::boost::shared_ptr< ReverseSignalStatusStatus >& status)
{
   uint8 _rvccamerastatus = status->getE8StatusReverseSignal();
   ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusStatus Reverse %u", _rvccamerastatus));
   if ((status->getE8StatusReverseSignal()) == RVC_DISABLED)
   {
      ETG_TRACE_USR4(("RearViewCamera:: onReverseSignalStatusStatus Reverse inside %u", status->getE8StatusReverseSignal()));
      if (sm_RVCSettings == RVC_ENABLED)
      {
         sm_RVCSettings = RVC_DISABLED;
         ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();
         ETG_TRACE_USR3(("sendrvccamerastatus2hall rvcstatus2hall=( %d)", _rvccamerastatus));
         bool isSettingAppInForeground = SystemSettingsListHandler::poGetInstance()->getSettingsAppState();
         ETG_TRACE_USR3(("RearViewCamera:: onReverseSignalStatusStatus isSettingAppInForeground= %d", isSettingAppInForeground));
         if (isSettingAppInForeground == true)
         {
            ETG_TRACE_USR3(("RearViewCamera::onReverseSignalStatusStatus Sending Homescreen context"));
            _applicationSwitchClientComponent->requestContextSwitchApplication(2, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_RVC_SETTINGS,
                  APPID_APPHMI_MASTER, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
         }
         else
         {
            ETG_TRACE_USR3(("RearViewCamera::onReverseSignalStatusStatus Sending back context"));
            _applicationSwitchClientComponent->requestContextSwitchApplication(2, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_RVC_SETTINGS,
                  0, (bosch::cm::ai::hmi::hmimasterservice::ApplicationSwitch::enActivityIDs)0);
         }
      }
   }
   else
   {
   }
}


void RearViewCamera::sendSetupVideo(rvc_cca_fi_types::T_e8_RVC_VideoParameterType cameraSettingType, int value)
{
   ::std::vector< ::rvc_cca_fi_types::T_RVC_VideoAnalogLevels > arVideoAnalogLevels;
   arVideoAnalogLevels.reserve(1);
   T_RVC_VideoAnalogLevels oVideoSetting;
   oVideoSetting.setE8Type(cameraSettingType);
   videoproperty = cameraSettingType;
   if (cameraSettingType == VIDEOPROPERTY_CNTRST)
   {
      ETG_TRACE_USR4(("RearViewCamera::Contrast sendSetupVideo %d %d", cameraSettingType, value));
   }
   else if (cameraSettingType == VIDEOPROPERTY_BRIGHT)
   {
      ETG_TRACE_USR4(("RearViewCamera::Brightness sendSetupVideo %d  %d", cameraSettingType, value));
   }
   else
   {
      ETG_TRACE_USR4(("RearViewCamera::NOTHING sendSetupVideo %d  %d", cameraSettingType, value));
   }
   oVideoSetting.setU8Value(static_cast<uint8>(value * 5)/*DISPLAY_CONTROL_LEVELS[_mComputedTicks]*/);
   arVideoAnalogLevels.push_back(oVideoSetting);

   ETG_TRACE_USR4(("RearViewCamera:: sendSetupVideo %d", value));
   m_poRvcFiProxy->sendSetupVideoControlsStart(*this, (T_e8_RVC_VideoParameterDimmingMode) 0, arVideoAnalogLevels, (T_e8_MVCViewingState) 0);
}


void RearViewCamera::onSetupVideoControlsResult(const ::boost::shared_ptr<rvc_cca_fi::Rvc_cca_fiProxy>&, const ::boost::shared_ptr<rvc_cca_fi::SetupVideoControlsResult>& result)
{
   ETG_TRACE_USR4(("RearViewCamera:: onSetupVideoControlsResult"));
   ETG_TRACE_USR4(("RearViewCamera::ProxyHandler::onSetupVideoControlsResult, result: %d", result->getResult()));
   if (videoproperty == VIDEOPROPERTY_BRIGHT)
   {
      ETG_TRACE_USR4(("RearViewCamera::onSetupVideoControlsResult Brightness sendSetupVideo: %d ", videoproperty));
      RVCBrightnessHandler::poGetInstance()->RVCBSetupVideoUpdateResult4mMW(result->getResult());
   }
   else if (videoproperty == VIDEOPROPERTY_CNTRST)
   {
      ETG_TRACE_USR4(("RearViewCamera::onSetupVideoControlsResult contrast sendSetupVideo: %d ", videoproperty));
      RVCContrastHandler::poGetInstance()->RVCCSetupVideoUpdateResult4mMW(result->getResult());
   }
   else
   {
      ETG_TRACE_USR4(("RearViewCamera::onSetupVideoControlsResult noproperty sendSetupVideo: %d ", videoproperty));
   }
}


void RearViewCamera::onSetupVideoControlsError(const ::boost::shared_ptr<rvc_cca_fi::Rvc_cca_fiProxy>&, const ::boost::shared_ptr<rvc_cca_fi::SetupVideoControlsError>&)
{
   ETG_TRACE_USR4(("RearViewCamera:: onSetupVideoControlsError"));
}


void RearViewCamera::onSetupLanguageError(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /* proxy */, const ::boost::shared_ptr< SetupLanguageError >& /* error */)
{
   ETG_TRACE_USR4(("RearViewCamera:: onSetupLanguageError"));
}


void RearViewCamera::onSetupLanguageResult(const ::boost::shared_ptr< Rvc_cca_fiProxy >& /* proxy */, const ::boost::shared_ptr< SetupLanguageResult >& /* status */)
{
   ETG_TRACE_USR4(("RearViewCamera:: onSetupLanguageResult"));
}


void RearViewCamera::CreateMapVehLangtoRVCLang()
{
   LanguageValue[T_e8_Language_Code__English_UK] = T_e8_RVC_Language__ENGLISH_UK;
   LanguageValue[T_e8_Language_Code__German] = T_e8_RVC_Language__GERMAN;
   LanguageValue[T_e8_Language_Code__Dutch] = T_e8_RVC_Language__DUTCH;
   LanguageValue[T_e8_Language_Code__French] = T_e8_RVC_Language__FRENCH_EUR;
   LanguageValue[T_e8_Language_Code__Italian] = T_e8_RVC_Language__ITALIAN;
   LanguageValue[T_e8_Language_Code__Spanish] = T_e8_RVC_Language__SPANISH_EUR;
   LanguageValue[T_e8_Language_Code__Portuguese] = T_e8_RVC_Language__PORTUGUESE;
   LanguageValue[T_e8_Language_Code__Hungarian] = T_e8_RVC_Language__HUNGARIAN;
   LanguageValue[T_e8_Language_Code__Czech] = T_e8_RVC_Language__CZECH;
   LanguageValue[T_e8_Language_Code__Danish] = T_e8_RVC_Language__DANISH;
   LanguageValue[T_e8_Language_Code__Norwegian] = T_e8_RVC_Language__NORWEGIAN;
   LanguageValue[T_e8_Language_Code__Polish] = T_e8_RVC_Language__POLISH;
   LanguageValue[T_e8_Language_Code__Swedish] = T_e8_RVC_Language__SWEDISH;
   LanguageValue[T_e8_Language_Code__Greek] = T_e8_RVC_Language__GREEK;
   LanguageValue[T_e8_Language_Code__Turkish] = T_e8_RVC_Language__TURKISH;
   LanguageValue[T_e8_Language_Code__Bulgarian] = T_e8_RVC_Language__BULGARIAN;
   LanguageValue[T_e8_Language_Code__Slovenian] = T_e8_RVC_Language__SLOVENIAN;
   LanguageValue[T_e8_Language_Code__Slovakian] = T_e8_RVC_Language__SLOVAK;
   LanguageValue[T_e8_Language_Code__Romanian] = T_e8_RVC_Language__ROMANIAN;
   LanguageValue[T_e8_Language_Code__Finnish] = T_e8_RVC_Language__FINNISH;
   LanguageValue[T_e8_Language_Code__Croatian] = T_e8_RVC_Language__CROATIAN;
   LanguageValue[T_e8_Language_Code__English_US] = T_e8_RVC_Language__ENGLISH_US;
   LanguageValue[T_e8_Language_Code__Spanish_Latin_American] = T_e8_RVC_Language__SPANISH_LATIN_AMERICAN;
   LanguageValue[T_e8_Language_Code__French_Canadian] = T_e8_RVC_Language__FRENCH_CAN;
}


void RearViewCamera::SetLanguage_RVC(uint32 languagecode)
{
   rvc_cca_fi_types::T_e8_RVC_Language rvc_lang_code;
   vehicle_main_fi_types::T_e8_Language_Code veh_lang_code ;
   ETG_TRACE_USR4(("RearViewCamera::SetLanguage_RVC is called index = %d", languagecode));
   veh_lang_code = (T_e8_Language_Code)languagecode;
   ETG_TRACE_USR4(("RearViewCamera::SetLanguage_RVC veh_lang_code = %d", veh_lang_code));
   rvc_lang_code = LanguageValue.find(veh_lang_code)->second;
   ETG_TRACE_USR4(("RearViewCamera::SetLanguage rvc_lang_code = %d", rvc_lang_code));
   m_poRvcFiProxy->sendSetupLanguageStart(*this, rvc_lang_code);
}


}//namespace
}//App
