/**************************************************************************************
* @file         : DisplaySrvClient.cpp
* @author       : ECG - Sathiya Jayanth
* @addtogroup   : System HALL
* @brief        : Class contains necessary business logic required to handle Display Settings.
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "DisplaySrvClient.h"
//#include "ClientServicesIFProxy.h"
#include "midw_fi_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                  DisplaySrvClient::
#include "trcGenProj/Header/DisplaySrvClient.cpp.trc.h"
#endif

using namespace dimming_main_fi;
using namespace ::asf::core;

namespace App {
namespace Core {

DisplaySrvClient* DisplaySrvClient::_DisplaySrvClient = NULL;
/**
 * @Destructor*
 */
DisplaySrvClient::~DisplaySrvClient()
{
   delete _hmidatasrvhandler;
   destroy();
}


/**
 * @Constructor
 */

DisplaySrvClient::DisplaySrvClient()
{
   m_brightvalue = 7;
   dimmingmodestatus = 0

                       ETG_I_REGISTER_FILE();
   _dimmingProxy = Dimming_main_fiProxy::createProxy("dimmingFiPort", *this);

   // ETG_TRACE_USR4(("DisplaySrvClient Constructor "));

   if (_dimmingProxy != NULL)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _dimmingProxy->getPortName());
      //  ETG_TRACE_USR4(("DisplaySrvClient registerPropertyRegistrationIF"));
   }
   _hmidatasrvhandler = HmiDataServiceClientHandler::poGetInstance();
}


void DisplaySrvClient::destroy()
{
   delete _DisplaySrvClient;
   _DisplaySrvClient = NULL;
}


/**
 * onAvailable - Checks for the availability of service
 * @param[in] proxy, stateChange
 * @parm[out] none
 * @return void
 */
void DisplaySrvClient::onAvailable(const ::boost::shared_ptr< ::Proxy >& proxy,
                                   const ServiceStateChange& stateChange)
{
   //ETG_TRACE_FATAL(("DisplaySrvClient onAvailable"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
//  ETG_TRACE_USR4(("DisplaySrvClient onAvailable"));
   //_dimmingProxy->sendDIM_DISP_BrightnessLevelExtendedUpReg(*this);
   //_dimmingProxy->sendDIM_INFO_DimmingModeUpReg(*this);
}


/**
 * onUnavailable - Checks for the unavailability of service
 * @param[in] proxy, stateChange
 * @parm[out] none
 * @return void
 */
void DisplaySrvClient::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy,
                                     const ServiceStateChange& stateChange)
{
   //ETG_TRACE_USR4(("DisplaySrvClient onUnavailable"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
//  ETG_TRACE_USR4(("DisplaySrvClient onUnavailable "));
}


/**
 * registerProperties - Register for the DIM_INFO_DimmingMode property available in the dimming proxy
 * @param[in] proxy , stateChange
 * @parm[out] none
 * @return void
 */
void DisplaySrvClient :: registerProperties(const ::boost::shared_ptr< Proxy >& proxy,
      const ServiceStateChange& /*stateChange*/)
{
   //	 ETG_TRACE_USR4(("DisplaySrvClient registerProperties"));
   if (_dimmingProxy && (_dimmingProxy == proxy))
   {
      _dimmingProxy->sendDIM_DISP_BrightnessLevelExtendedUpReg(*this);
      _dimmingProxy->sendDIM_INFO_DimmingModeUpReg(*this);
      //		   ETG_TRACE_USR4(("DisplaySrvClient registerProperties done"));
      //_dimmingProxy->
   }
}


/**
 * deregisterProperties - Deregister DIM_INFO_DimmingMode property in the dimming proxy
 * @param[in] proxy , stateChange
 * @parm[out] none
 * @return void
 */
void DisplaySrvClient::deregisterProperties(const ::boost::shared_ptr< Proxy >& proxy,
      const ServiceStateChange& /*stateChange*/)
{
   //ETG_TRACE_USR4(("DisplaySrvClient deregisterProperties"));

   if (_dimmingProxy && (_dimmingProxy == proxy))
   {
      _dimmingProxy->sendDIM_DISP_BrightnessLevelExtendedRelUpRegAll();
      _dimmingProxy->sendDIM_INFO_DimmingModeRelUpRegAll();
      //	ETG_TRACE_USR4(("DisplaySrvClient deregisterProperties done"));
   }
}


/**
 * onDIM_DISP_SetBrightnessLevelExtendedError -  ASF Communication error
 * @param[in]
 * @parm[out] Error Type
 * @return void
 */
void DisplaySrvClient :: onDIM_DISP_SetBrightnessLevelExtendedError(const ::boost::shared_ptr< Dimming_main_fiProxy >& /*proxy*/,
      const boost::shared_ptr< DIM_DISP_SetBrightnessLevelExtendedError >& /*error*/)
{
   ETG_TRACE_USR4(("DisplaySrvClient onDIM_DISP_SetBrightnessLevelExtendedError"));
}


/**
 * DIM_DISP_SetBrightnessLevelExtendedResult - Returns the current level of Brightness
 * @param[in] none
 * @parm[out] none
 * @return void
 */
void DisplaySrvClient :: onDIM_DISP_SetBrightnessLevelExtendedResult(const ::boost::shared_ptr< Dimming_main_fiProxy >& /*proxy*/,
      const boost::shared_ptr< DIM_DISP_SetBrightnessLevelExtendedResult >& /* result */)
{
   //ETG_TRACE_USR4(("SetBrightnessLevelExtendedResult:%d", result->getBrightnessLevelExtended()));
   //ETG_TRACE_USR4(("DisplaySrvClient Calling sendDIM_DISP_SetBrightnessLevelExtendedResult"));
}


void DisplaySrvClient :: onDIM_DISP_BrightnessLevelExtendedError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::dimming_main_fi::DIM_DISP_BrightnessLevelExtendedError >& /*error*/)
{
   //ETG_TRACE_USR4(("DisplaySrvClient Calling onDIM_DISP_BrightnessLevelExtendedError"));
}


//Update Brightness Value to APP Logic
void DisplaySrvClient :: onDIM_DISP_BrightnessLevelExtendedStatus(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /*proxy*/,
      const ::boost::shared_ptr< ::dimming_main_fi::DIM_DISP_BrightnessLevelExtendedStatus >& status)
{
   ETG_TRACE_USR4(("DisplaySrvClient Calling onDIM_DISP_BrightnessLevelExtendedStatus"));
   ETG_TRACE_USR4(("DisplaySrvClient: onDIM_DISP_BrightnessLevelExtendedStatus value= %d", status->getBrightnessLevelExtended()));

   m_brightvalue = status->getBrightnessLevelExtended();

   ETG_TRACE_USR4(("DisplaySrvClient: m_brightvalue= %d", m_brightvalue));
   // if (m_brightvalue >= 7)
   // {
   //    m_brightvalue = 6;
   //}
   DisplaySettings::poGetInstance()->onUpdateMenu(m_brightvalue);
}


/**
 * onDIM_INFO_DimmingModeError -  ASF Communication error
 * @param[in]
 * @parm[out] Error Type
 * @return void
 */
void DisplaySrvClient ::onDIM_INFO_DimmingModeError(const ::boost::shared_ptr< Dimming_main_fiProxy >& /*proxy*/,
      const boost::shared_ptr< DIM_INFO_DimmingModeError >& /*error*/)
{
}


/**
 * onDIM_INFO_DimmingModeStatus -  Gives the mode value corresponding to Day, Night or Auto
 * @param[in] proxy, status
 * @parm[out] Dimming Mode
 * @return void
 */


//Update Mode Value to APP Logic
void DisplaySrvClient :: onDIM_INFO_DimmingModeStatus(const ::boost::shared_ptr< Dimming_main_fiProxy >& /*proxy*/,
      const boost::shared_ptr< DIM_INFO_DimmingModeStatus >& status)
{
   ETG_TRACE_USR4(("DisplaySrvClient: onDIM_INFO_DimmingModeStatus:%d", status->getStatus()));
   if (_dimmingProxy)
   {
      int dimmingmodestatus = static_cast<int>(status->getStatus());

      ETG_TRACE_USR4(("DisplaySrvClient: dimmingmodestatus:%d", dimmingmodestatus));
      DisplaySettings::poGetInstance()->DisplayModeUpdate2HMI(dimmingmodestatus);
      _hmidatasrvhandler->SetDimmingMode(dimmingmodestatus);
      // _currentModeStatus = dimmingmodestatus;
      // DisplayCompRxUpdate();
   }
}


//Update Brightness Value to Middleware
void DisplaySrvClient::Inc_Dec_Brightness_Service(int BrightnessVal)
{
   if (_dimmingProxy)
   {
      ETG_TRACE_USR4(("DisplaySrvClient Calling test function :%d", BrightnessVal));
      //	 ETG_TRACE_USR4(("DisplaySrvClient Calling sendDIM_DISP_SetBrightnessLevelExtendedStart"));
      _dimmingProxy->sendDIM_DISP_SetBrightnessLevelExtendedStart(*this, static_cast<uint8>(BrightnessVal));
   }
}


void DisplaySrvClient::onDIM_INFO_SetDimmingModeError(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /* proxy */, const ::boost::shared_ptr< ::dimming_main_fi::DIM_INFO_SetDimmingModeError >& /* error */)
{
}


void DisplaySrvClient::onDIM_INFO_SetDimmingModeResult(const ::boost::shared_ptr< ::dimming_main_fi::Dimming_main_fiProxy >& /* proxy */, const ::boost::shared_ptr< ::dimming_main_fi::DIM_INFO_SetDimmingModeResult >& /* result */)
{
}


//Update Mode Value to Middleware
void DisplaySrvClient::SetDimmingMode(const uint32& mode)
{
   ETG_TRACE_USR4(("Recieved Dimming mode is :%d", mode));
   if (_dimmingProxy)
   {
      _dimmingProxy->sendDIM_INFO_SetDimmingModeStart(*this, (::dimming_main_fi_types::T_e8_DIM_Mode)mode);
      //  ETG_TRACE_USR4(("Dimming mode Request"));
   }
}


// uint8 DisplaySrvClient::getCurrentModeStatusData()
// {
// return _currentModeStatus;
// }


// uint8 DisplaySrvClient::getCurrentBrightnessVal4mModeStatusData()
// {
// return _currentBrightnessVal4mModeStatus;
// }


// void DisplaySrvClient::DisplayCompRxUpdate()
// {
// uint8 DispMode, DispBright;

// DispMode = getCurrentModeStatusData();
// //DispBright=getCurrentBrightnessVal4mModeStatusData();

// ETG_TRACE_USR4(("DisplaySrvClient::DisplayCompRxUpdate DispMode:%d", DispMode));
// ETG_TRACE_USR4(("DisplaySrvClient::DisplayCompRxUpdate m_brightvalue :%d", m_brightvalue));
// //DisplaySettings::poGetInstance()->DisplayCompUpdate2GUI(DispMode,m_brightvalue);
// }
}


}
