/**************************************************************************************
* @file         : <MIDWDiagnosis.h>
* @author       : Sheena Mathew
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MIDWDIAGNOSIS_HEADER
#define MIDWDIAGNOSIS_HEADER
/***********************************************************************
  INCLUDE FILES
 ***********************************************************************/


#include "Midw_Diagnostics_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"

using namespace Midw_Diagnostics_FI ;
using namespace std;
namespace App {
namespace Core {


class MIDWDiagnosis :
   public ::hmibase::ServiceAvailableIF,
   public StartupSync::PropertyRegistrationIF,
   public Midw_Diagnostics_FI::SetResetToSupplierDefaultConfigCallbackIF,
   public Midw_Diagnostics_FI::CISswUpdateProcessCallbackIF,
   public Midw_Diagnostics_FI::CISswUpdateStage2ProcessCallbackIF
{
   public:

      static MIDWDiagnosis* poGetInstance()
      {
         if (NULL == _MIDWDiagnosis)
         {
            _MIDWDiagnosis = new MIDWDiagnosis();
         }

         return _MIDWDiagnosis;
      }
      virtual ~MIDWDiagnosis();
      MIDWDiagnosis(const MIDWDiagnosis&);
      MIDWDiagnosis& operator =(const MIDWDiagnosis&);
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void onSetResetToSupplierDefaultConfigError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetResetToSupplierDefaultConfigError >& /*error*/) ;
      void onSetResetToSupplierDefaultConfigResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetResetToSupplierDefaultConfigResult >& result) ;
      void onCISswUpdateProcessError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateProcessError >& /* error */);
      void onCISswUpdateProcessStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateProcessStatus >& Status);
      void onCISswUpdateStage2ProcessError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateStage2ProcessError >& /* error */);
      void onCISswUpdateStage2ProcessStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateStage2ProcessStatus >& result);
      void SetResetToSupplierDefaultMode(int mode);
      void SendCISswUpdateComplete(bool status);
   private:
      MIDWDiagnosis();
      ::boost::shared_ptr< Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy > _diagnosticProxy;
      static MIDWDiagnosis* _MIDWDiagnosis;
};


} // namespace Core
} // namespace App
#endif //OEMDIAGNOSISSERVICECLIENTHANDLER_HEADER
