/**************************************************************************************
* @file         : <MIDWDiagnosis.cpp>
* @author       : Sheena Mathew
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#include "hall_std_if.h"
#include "App/Core/AppLogic/OEM/OEMmenu.h"
#include "App/Core/AppLogic/SoftwareUpdate/SWUpdate.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"
#include "MIDWDiagnosis.h"
#include <stdio.h>


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::MIDWDiagnosis::
#include "trcGenProj/Header/MIDWDiagnosis.cpp.trc.h"
#endif

using namespace std;
using namespace ::asf::core;
using namespace Midw_Diagnostics_FI;


namespace App {
namespace Core {

MIDWDiagnosis* MIDWDiagnosis::_MIDWDiagnosis = NULL;

MIDWDiagnosis::MIDWDiagnosis()
   : _diagnosticProxy(Midw_Diagnostics_FI::Midw_Diagnostics_FIProxy::createProxy("diagnosticsFiPort", *this))

{
   ETG_TRACE_USR4(("MIDWDiagnosis:MIDWDiagnosis Class is created"));
   if (_diagnosticProxy)
   {
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _diagnosticProxy->getPortName());
   }
}


/**
 * @Destructor
 */
MIDWDiagnosis::~MIDWDiagnosis()
{
   ETG_TRACE_USR4(("MIDWDiagnosis:~MIDWDiagnosis Destructor - Entry"));
   if (_MIDWDiagnosis != NULL)
   {
      delete _MIDWDiagnosis;
   }
}


/**
 * To invoke the registerProperties function of the dependent classes.
 * @param[in] <proxy> proxies to middleware server
 * @param  <stateChange> --todo: need to add details
 */
void MIDWDiagnosis::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("MIDWDiagnosis :RegisterProperties "));
   if (proxy == _diagnosticProxy)
   {
      ETG_TRACE_USR4(("MIDWDiagnosis: registerProperties called With State:%d", stateChange.getCurrentState()));
      _diagnosticProxy->sendCISswUpdateProcessUpReg(*this);
      _diagnosticProxy->sendCISswUpdateStage2ProcessUpReg(*this);
   }
}


/**
 * send relupregall property for device manager connection notification
 * @param[in] <proxy> diagnostic fi proxy object
 * @param[in] <stateChange> state information
 */
void MIDWDiagnosis::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("MIDWDiagnosis--DeregisterProperties "));

   if (proxy == _diagnosticProxy)
   {
      ETG_TRACE_USR4(("MIDWDiagnosis: deregisterProperties called With State:%d", stateChange.getCurrentState()));
      _diagnosticProxy->sendCISswUpdateProcessRelUpRegAll();
      _diagnosticProxy->sendCISswUpdateStage2ProcessRelUpRegAll();
   }
}


/*****************************************************************************
* @brief   onUnAvailable
*****************************************************************************/
void MIDWDiagnosis::onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR4(("MIDWDiagnosis --onUnavailable "));
   if ((proxy == _diagnosticProxy) && (_diagnosticProxy.get()))
   {
      StartupSync::getInstance().onUnavailable(proxy, stateChange);
   }
}


void MIDWDiagnosis::SetResetToSupplierDefaultMode(int mode)
{
   ETG_TRACE_COMP(("MIDWDiagnosis::DefaultMode mode:%d", mode));

   if (_diagnosticProxy)
   {
      _diagnosticProxy->sendSetResetToSupplierDefaultConfigStart(*this, static_cast<uint8>(mode));
   }
}


/*****************************************************************************
* @brief   onAvailable
*****************************************************************************/
void MIDWDiagnosis::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR3(("MIDWDiagnosis::onAvailable()"));

   if ((proxy == _diagnosticProxy) && (_diagnosticProxy.get()))
   {
      StartupSync::getInstance().onAvailable(proxy, stateChange);
   }
}


void MIDWDiagnosis::onSetResetToSupplierDefaultConfigError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetResetToSupplierDefaultConfigError >& /*error*/)
{
}


void MIDWDiagnosis::onSetResetToSupplierDefaultConfigResult(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< SetResetToSupplierDefaultConfigResult >& result)
{
   ETG_TRACE_USR4(("MIDWDiagnosis:onSetResetToSupplierDefaultConfigResult is called"));
   if ((proxy == _diagnosticProxy) && (_diagnosticProxy.get()))
   {
      bool ResetServiceStatus           = result->getDefResetServiceStatus();
      ETG_TRACE_USR4(("MIDWDiagnosis:ResetToSupplierDefaultConfigStatus =%d", ResetServiceStatus));
      OEMmenu::poGetInstance()->UpdateResetToSupplierDefaultConfigStatus(ResetServiceStatus);
   }
}


void MIDWDiagnosis::onCISswUpdateProcessError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateProcessError >& /* error */)
{
   ETG_TRACE_COMP(("MIDWDiagnosis:onCISswUpdateProcessError is called"));
}


void MIDWDiagnosis::onCISswUpdateProcessStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateProcessStatus >& Status)
{
   ETG_TRACE_COMP(("MIDWDiagnosis:onCISswUpdateProcessStatus is called"));
   if (proxy == _diagnosticProxy)
   {
      ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateProcessStatus result"));
      if (Status->hasStatus())
      {
         ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateProcessStatus status = %d", Status->getStatus()));
         bool status = Status->getStatus();
         // HMI is notified that swupdate happens via diagnosis or not
         SWUpdate::GetInstance()->SWUpdateviaDiagTool(status);
         SystemSettingsListHandler::poGetInstance()->isSWUpdateviaDiagTool(status);
      }
   }
}


void MIDWDiagnosis::SendCISswUpdateComplete(bool status)
{
   ETG_TRACE_COMP(("MIDWDiagnosis:SendCISswUpdateComplete is called"));
   if (_diagnosticProxy)
   {
      ETG_TRACE_USR4(("MIDWDiagnosis:SendCISswUpdateComplete completion status = %d", status));
      _diagnosticProxy->sendCISswUpdateProcessSet(*this, status);
   }
}


void MIDWDiagnosis::onCISswUpdateStage2ProcessError(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateStage2ProcessError >& /* error */)
{
   ETG_TRACE_COMP(("MIDWDiagnosis:onCISswUpdateStage2ProcessError is called"));
}


void MIDWDiagnosis::onCISswUpdateStage2ProcessStatus(const ::boost::shared_ptr< Midw_Diagnostics_FIProxy >& proxy, const ::boost::shared_ptr< CISswUpdateStage2ProcessStatus >& result)
{
   ETG_TRACE_COMP(("MIDWDiagnosis:onCISswUpdateStage2ProcessStatus is called"));
   if (proxy == _diagnosticProxy)
   {
      ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateStage2ProcessStatus result"));
      if (result->hasStatus())
      {
         ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateStage2ProcessStatus status = %d", result->getStatus()));
         bool status = result->getStatus();
         if (status == true)
         {
            ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateStage2ProcessStatus status is true"));
            bool WaitAllowRecoveyModeStatus = SWUpdate::GetInstance()->getWaitAllowRecoveryModeStatus();
            _diagnosticProxy->sendCISswUpdateStage2ProcessSet(*this, WaitAllowRecoveyModeStatus);
         }
         else
         {
            ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateStage2ProcessStatus status is not true do nothing"));
         }
      }
      else
      {
         ETG_TRACE_USR2(("MIDWDiagnosis:onCISswUpdateStage2ProcessStatus has no status"));
      }
   }
}


}
}
