/**************************************************************************************
* @file         : DiagnosisServiceClientHandler.cpp
* @author       : CMC HMI Team
* @addtogroup   : apphmi_sytem
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include <hmibase/hall_std_if.h>
#include "DiagnosisServiceClientHandler.h"
//#include "App/Core/DataPool/DataPoolHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::DiagnosisServiceClientHandler::
#include "trcGenProj/Header/DiagnosisServiceClientHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

DiagnosisServiceClientHandler* DiagnosisServiceClientHandler::_DiagnosisServiceClientHandler = NULL;

DiagnosisServiceClientHandler::DiagnosisServiceClientHandler()
{
   _defSetServiceBase = NULL;
   DefSetServiceBase::s_Intialize("AppHmi_SystemPort");
   ETG_TRACE_USR4(("DiagnosisServiceClientHandler Constructor "));
   // factory Restore settings
   if (DefSetServiceBase::GetInstance() != NULL)
   {
      _defSetServiceBase = DefSetServiceBase::GetInstance();
   }
   if (_defSetServiceBase != NULL)
   {
      _defSetServiceBase->vRegisterforUpdate(this);
      ETG_TRACE_USR4(("DiagnosisServiceClientHandler vRegisterforUpdate "));
   }
}


DiagnosisServiceClientHandler::~DiagnosisServiceClientHandler()
{
   if (NULL != _defSetServiceBase)
   {
      //do not delete this instance as its not created by us.
      _defSetServiceBase->vUnRegisterforUpdate(this);
      _defSetServiceBase = NULL;
      ETG_TRACE_USR4(("DiagnosisServiceClientHandler destructor"));
   }
   DefSetServiceBase::s_Destrory(); //to destroy DefSetServiceBase instance
   destroy();
}


void DiagnosisServiceClientHandler::destroy()
{
   delete _DiagnosisServiceClientHandler;
   _DiagnosisServiceClientHandler = NULL;
}


void DiagnosisServiceClientHandler::registerRestoreFactorySettingInfoChange(IResetFactorySettings* pIResetFactorySettings)
{
   _registeredUpdateList.push_back(pIResetFactorySettings);
   ETG_TRACE_USR4(("DiagnosisServiceClientHandler registerRestoreFactorySettingInfoChange"));
}


void DiagnosisServiceClientHandler::deRegisterRestoreFactorySettingInfoChange(IResetFactorySettings* pIResetFactorySettings)
{
   ::std::vector<IResetFactorySettings*>::iterator itr = ::std::find(_registeredUpdateList.begin(), _registeredUpdateList.end(), pIResetFactorySettings);
   if (itr != _registeredUpdateList.end())
   {
      _registeredUpdateList.erase(itr);
   }
   ETG_TRACE_USR4(("DiagnosisServiceClientHandler deRegisterRestoreFactorySettingInfoChange"));
}


void DiagnosisServiceClientHandler::reqPrepareResponse(const PrepareResDiagMsgData& /*oPrepareResDiagMsgData*/)
{
   ETG_TRACE_USR4(("DiagnosisServiceClientHandler reqPrepareResponse"));
   if (_defSetServiceBase != NULL)
   {
      _defSetServiceBase->sendPrepareResponse(0, this);//0 is for sucess
      ETG_TRACE_USR4(("DiagnosisServiceClientHandler reqPrepareResponse Sent"));
   }
}


void DiagnosisServiceClientHandler::reqExecuteResponse(const ExecuteResDiagMsgData& /*oExecuteResDiagMsgData*/)
{
   ETG_TRACE_USR4(("DiagnosisServiceClientHandler reqExecuteResponse"));
   if (_defSetServiceBase != NULL)
   {
      sendRestoreFactorySettingInfoChange();
      _defSetServiceBase->sendExecuteResponse(0, this);//0 is for sucess
      ETG_TRACE_USR4(("DiagnosisServiceClientHandler reqExecuteResponse after sendExecuteResponse"));
   }
}


void DiagnosisServiceClientHandler:: reqFinalizeResponse(const FinalizeResDiagMsgData& /*oFinalizeResDiagMsgData*/)
{
   ETG_TRACE_USR4(("DiagnosisServiceClientHandler reqFinalizeResponse"));
   if (_defSetServiceBase != NULL)
   {
      _defSetServiceBase->sendFinalizeResponse(0, this);//0 is for sucess
      ETG_TRACE_USR4(("DiagnosisServiceClientHandler FinalizeResponseSent"));
   }
}


void DiagnosisServiceClientHandler::sendRestoreFactorySettingInfoChange()
{
   for (::std::vector<IResetFactorySettings*>::iterator itr = _registeredUpdateList.begin(); itr != _registeredUpdateList.end(); itr++)
   {
      if ((*itr) != NULL)
      {
         (*itr)->updateResetFactorySettingsInfo();
      }
   }
}


}//namespace core
}//namespace App
