/**************************************************************************************
* @file         : <CabinInfoSrvClient.h>
* @author       : Sheena Mathew
* @addtogroup   : <AppHmi_System>
* @brief        :
* @copyright    : (C) 2018 Robert Bosch GmbH
*                 (C) 2018 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#ifndef CabinInfoSrvClient_h
#define CabinInfoSrvClient_h


#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include <map>
#include "App/Core/System_Types.h"
#include "ProjectPluginMsgs.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

//Below Values are for Cabinsysteminfo
#define SYSTEM_DISCONNECTED 0
#define SYSTEM_CONNECTED 	1
#define SYSTEM_UNAVAILABLE 	2

#define ENABLED  1
#define DISABLED 0


using namespace std;
using namespace ::asf::core;
using namespace ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService;
#include "asf/core/Types.h"

namespace App {
namespace Core {


class CabinInfoSrvClient
   : public ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public CabinsSystemsInfoCallbackIF
//  , public IExternalSourceAvailabilityStatusObserver
   , public CabinSourcesConnectionStatusCallbackIF
   , public SetCabinVideoMixIndexCallbackIF
   , public CabinsVideoMixInfoCallbackIF
   , public ETAAvailableCallbackIF
{
   public:

      virtual ~CabinInfoSrvClient();

      static CabinInfoSrvClient* poGetInstance()
      {
         if (NULL == _CabinInfoSrvClient)
         {
            _CabinInfoSrvClient = new CabinInfoSrvClient();
         }

         return _CabinInfoSrvClient;
      }

      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      //  void addExternalSourceAvailabilityStatusObserver(CabinInfoSrvClient& imp);

      void onCabinsSystemsInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& /*proxy*/,
                                    const ::boost::shared_ptr< CabinsSystemsInfoError >& error);

      void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
                                     const ::boost::shared_ptr< CabinsSystemsInfoUpdate >& update);
      void onCabinSourcesConnectionStatusError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< CabinSourcesConnectionStatusError >& error);

      void onCabinSourcesConnectionStatusUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< CabinSourcesConnectionStatusUpdate >& update) ;
      void onSetCabinVideoMixIndexError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
                                        const ::boost::shared_ptr< SetCabinVideoMixIndexError >& error) ;

      void onSetCabinVideoMixIndexResponse(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
                                           const ::boost::shared_ptr< SetCabinVideoMixIndexResponse >& response);
      void onCabinsVideoMixInfoError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
                                     const ::boost::shared_ptr< CabinsVideoMixInfoError >& error);
      void onCabinsVideoMixInfoUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy,
                                      const ::boost::shared_ptr< CabinsVideoMixInfoUpdate >& update);
      void onETAAvailableError(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableError >& error);
      void onETAAvailableUpdate(const ::boost::shared_ptr< HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr< ETAAvailableUpdate >& update);

      void init();
      void userSelectedindex(int index, int reason);
      bool getglassAvailablityInfoStatusCA();
      bool getcmgA1AvailablityInfoStatusCA();
      bool getcmgA2AvailablityInfoStatusCA();
      bool getcmgA2GlassConfiguredInfoStatusCA();
      void vEvaluateCMG(uint8 systemGroup, uint32 systemStatus);
      void updateUserOffStatus(bool RxuserOffState);
      void setETAAvailableStatus(bool ETAAvailableStatus);
      bool getUserOffStatus();
   private:

      ::boost::shared_ptr< ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService::HmiInfoServiceProxy> _hmiInfoServiceProxyClient;
      CabinInfoSrvClient();
      static CabinInfoSrvClient* _CabinInfoSrvClient;
      ::std::vector< CabinInfoSrvClient* > _cabinInfoSrvClientObj;
      act_t _regionsMapOutStatusInfo_RegId;
      act_t _cabinsSystemsInfo_RegId;

      map<int, map<int, uint32> > sourceinfo;   //sourceid, connectionstatus, userdata/textid
      uint32 userData;
      bool userOffStateStatus;
      bool cmgA1AvailablityInfoCA;
      bool glassAvailablityInfoCA;
      bool cmgA2AvailablityInfoCA;
      bool b_IsCAcmgA2GlassInstalled;
      int cmgA1GlassCount ;
      int cmgA2GlassCount ;
      int cmgA2GlassInstalledCount;
      int grosscmgGlassCount;
};


}
}


#endif
