/***************************************************************************
* Copyright(c) 2019-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/
#ifndef SERVICEBT_HEADER
#define SERVICEBT_HEADER

#define GENERIC_FI_INTERFACE
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_TYPES
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_FUNCTIONIDS
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_SERVICEINFO
#define MOST_FI_S_IMPORT_INTERFACE_MOST_BTSETFI_ERRORCODES
#include "most_fi_if.h"


#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include "midw_fi_if.h"
/*****************************************************************
| includes
|----------------------------------------------------------------*/
#include "MOST_BTSet_FI.h"
#include "MOST_BTSet_FIProxy.h"
#include "AppBase/ServiceAvailableIF.h"
#include "most_BTSet_fi_types.h"
#include "most_BTSet_fi_types_Extended.h"

using namespace ::asf::core;
using namespace ::MOST_BTSet_FI;

namespace App {
namespace Core {
class ServiceBT
   : public hmibase::ServiceAvailableIF,
     public StartupSync::PropertyRegistrationIF,
     public ::MOST_BTSet_FI::SwitchBluetoothOnOffExtendedCallbackIF,
     public ::MOST_BTSet_FI::BluetoothOnOffCallbackIF
{
   public:
      static ServiceBT* poGetInstance()
      {
         if (NULL == _BtSrvClient)
         {
            _BtSrvClient = new ServiceBT();
         }

         return _BtSrvClient;
      }
      virtual ~ServiceBT();
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);

      // ServiceAvailableIF implementation
      virtual void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);
      virtual void onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange);

      virtual void onSwitchBluetoothOnOffExtendedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_BTSet_FI::SwitchBluetoothOnOffExtendedError >& error);

      virtual void onSwitchBluetoothOnOffExtendedResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_BTSet_FI::SwitchBluetoothOnOffExtendedResult >& result);

      virtual void onBluetoothOnOffError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffError >& error);

      virtual void onBluetoothOnOffStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffStatus >& status);

      void SetBluetoothState(bool state);

   private:

      ServiceBT();

      ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy > _btSetProxy;
      static ServiceBT* _BtSrvClient;
};


}
}


#endif
