/***************************************************************************
* Copyright(c) 2019-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/*****************************************************************************
 * (c) Robert Bosch Car Multimedia GmbH
 *
 * Add details here
 ****************************************************************************/

#include "hall_std_if.h"
#include "ServiceBT.h"
#include "SystemSettingsListHandler.h"
#include "CabinASettingListhandler.h"
//#include "most_BTSet_fi_types.h"

using namespace ::MOST_BTSet_FI;
using namespace ::most_BTSet_fi_types;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS           TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::ServiceBT::
#include "trcGenProj/Header/ServiceBT.cpp.trc.h"
#endif

namespace App {
namespace Core {

ServiceBT* ServiceBT::_BtSrvClient = NULL;
/*****************************************************************************
* @brief   ServiceBT Constructor
*****************************************************************************/
ServiceBT::ServiceBT() :
   _btSetProxy(::MOST_BTSet_FI::MOST_BTSet_FIProxy::createProxy("btSetFiPort", *this))
{
   ETG_TRACE_USR2(("ServiceBT Constructor"));
   if (_btSetProxy.get())
   {
      ETG_TRACE_USR2(("ServiceBT _btSetProxy.get is TRUE"));
      StartupSync::getInstance().registerPropertyRegistrationIF(this, _btSetProxy->getPortName());
   }
   else
   {
      ETG_TRACE_FATAL(("ServiceBT _btSetProxy.get is FALSE"));
   }
}


/*****************************************************************************
* @brief   ServiceBT Destructor
*****************************************************************************/
ServiceBT::~ServiceBT()
{
   //Add your code here
}


/*****************************************************************************
* @brief   ServiceBT registerProperties
*****************************************************************************/
void ServiceBT::registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR2(("ServiceBT registerProperties"));
   if ((proxy == _btSetProxy))
   {
      ETG_TRACE_USR2(("ServiceBT registerProperties 1"));
      _btSetProxy->sendBluetoothOnOffUpReg(*this);
      _btSetProxy->sendBluetoothOnOffGet(*this);
   }
}


/*****************************************************************************
* @brief   ServiceBT deregisterProperties
*****************************************************************************/

void ServiceBT::deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/)
{
   ETG_TRACE_USR2(("ServiceBT deregisterProperties"));
   if ((proxy == _btSetProxy))
   {
      ETG_TRACE_USR2(("ServiceBT deregisterProperties 1"));
      _btSetProxy->sendBluetoothOnOffRelUpRegAll();
   }
}


/*****************************************************************************
* onAvailable: Register for properties once service is available
*****************************************************************************/
void ServiceBT::onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_USR2(("ServiceBT onAvailable(_btSetProxy)"));
   StartupSync::getInstance().onAvailable(proxy, stateChange);
}


/*****************************************************************************
* onUnavailable: De-register for properties once service is unavailable
*****************************************************************************/
void ServiceBT::onUnavailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const ServiceStateChange& stateChange)
{
   ETG_TRACE_FATAL(("ServiceBT onUnavailable(_btSetProxy)"));
   StartupSync::getInstance().onUnavailable(proxy, stateChange);
}


/*****************************************************************************
* onSwitchBluetoothOnOffExtendedError:
*****************************************************************************/
void ServiceBT::onSwitchBluetoothOnOffExtendedError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /* proxy */, const ::boost::shared_ptr< ::MOST_BTSet_FI::SwitchBluetoothOnOffExtendedError >& /* error */)
{
   ETG_TRACE_USR2(("Recieved onSwitchBluetoothOnOffExtendedError"));
}


/*****************************************************************************
* onSwitchBluetoothOnOffExtendedResult:
*****************************************************************************/
void ServiceBT::onSwitchBluetoothOnOffExtendedResult(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /* proxy */, const ::boost::shared_ptr< ::MOST_BTSet_FI::SwitchBluetoothOnOffExtendedResult >& /* result */)
{
   ETG_TRACE_USR2(("Recieved onSwitchBluetoothOnOffExtendedResult"));
}


/*****************************************************************************
* Set Bluetooth ON/OFF:
*****************************************************************************/
void ServiceBT::SetBluetoothState(bool state)
{
   ETG_TRACE_USR2(("Recieved Bluetooth State is %d", state));
   if (_btSetProxy != NULL)
   {
      _btSetProxy->sendSwitchBluetoothOnOffExtendedStart(*this, state, true);
   }
}


/*****************************************************************************
* Set Bluetooth ON/OFF:
*****************************************************************************/
void ServiceBT::onBluetoothOnOffError(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& /* proxy */, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffError >& /* error */)
{
   ETG_TRACE_COMP(("onBluetoothOnOffError"));
   if (SystemSettingsListHandler::poGetInstance() != NULL)
   {
      SystemSettingsListHandler::poGetInstance()->showWaitAnimation(false);
   }
}


/*****************************************************************************
* Set Bluetooth ON/OFF:
*****************************************************************************/
void ServiceBT::onBluetoothOnOffStatus(const ::boost::shared_ptr< ::MOST_BTSet_FI::MOST_BTSet_FIProxy >& proxy, const ::boost::shared_ptr< ::MOST_BTSet_FI::BluetoothOnOffStatus >& status)
{
   ETG_TRACE_USR2(("onBluetoothOnOffStatus"));
   if ((status->hasBBTOnOff()) && (proxy == _btSetProxy))
   {
      ETG_TRACE_USR2(("ServiceBT::onBluetoothOnOffStatus status = %d", status->getBBTOnOff()));
      SystemSettingsListHandler::poGetInstance()->SetBluetoothStatus(status->getBBTOnOff());
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
      CabinASettingListhandler::poGetInstance()->setBTstatus(status->getBBTOnOff());
#endif
   }
}


}
}
