/**
 * @addtogroup <AppHmi_System>
 * @{
 * @file        AudioServiceClient.h
 * @brief       AudioServiceClient is to handle ServiceClient impl of Audio Services.
 *              (-> Genivi audio manager, Mascf_main_fi and Master audio)
 * @author      Sathiya Jayanth - ECG
 * @copyright   (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *              The reproduction, distribution and utilization of this file as
 *              well as the communication of its contents to others without express
 *              authorization is prohibited. Offenders will be held liable for the
 *              payment of damages. All rights reserved in the event of the grant
 *              of a patent, utility model or design.
 * @}
 */


#ifndef AUDIO_SERVICE_CLIENT_H
#define AUDIO_SERVICE_CLIENT_H

#include "org/genivi/audiomanager/CommandInterfaceProxy.h" //to access Genivi audio manager service
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesProxy.h" //to access Master Audio sound properties service
#include "bosch/cm/ai/hmi/masteraudioservice/SoundPropertiesClientBase.h"//to access Master Audio sound properties service
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChangeProxy.h" //to access Master Audio source change service
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoService.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "bosch/cm/ai/hmi/masteraudioservice/SoundProperties.h"//to access Master Audio source change service
#include "App/Core/ClientHandler/HmiState/HmiStateHandler.h"

#endif
#include "bosch/cm/ai/hmi/masteraudioservice/AudioSourceChange.h"				//Master Display Video Status
#include "AppBase/ServiceAvailableIF.h"
#include "AudioSettingListHandler.h"

#define COCKPITSINKID 1
#define CABINSASINKID 3
#define CABINSBSINKID 6

#define REGION_CABIN_A 0
#define REGION_CABIN_B 1
#define REGION_COCKPIT 2
#define REGION_INVALID 4

#define MAPOUT_TRUE 				1
#define MAPOUT_FALSE 				0


#define COMMAND_INTERFACE ::org::genivi::audiomanager::CommandInterface
#define AUDIO_SOUND_PROPERTIES ::bosch::cm::ai::hmi::masteraudioservice::SoundProperties
#define AUDIO_SOURCE_CHANGE ::bosch::cm::ai::hmi::masteraudioservice::AudioSourceChange
#define HMI_INFO_SERVICE_CHANGE ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService  //	define for the HMIINFOSERVICE Mapout Service Properties-26.05.2020

namespace App {
namespace Core {

class AudioServiceClient : public ::StartupSync::PropertyRegistrationIF,
   public hmibase::ServiceAvailableIF,
   public  AUDIO_SOURCE_CHANGE::ActiveSourceListCallbackIF,
//  public AUDIO_SOUND_PROPERTIES::RequestMainSinkSoundPropertyListCallbackIF,
   public AUDIO_SOUND_PROPERTIES::SoundPropertyListCallbackIF,
//  public AUDIO_SOUND_PROPERTIES::RequestSystemPropertyListCallbackIF ,
   public AUDIO_SOUND_PROPERTIES::SystemPropertyListCallbackIF,
   public AUDIO_SOUND_PROPERTIES::SetMainSinkSoundPropertyCallbackIF,//new sound property from hmi base---02.07.2020 --DONE
   public AUDIO_SOUND_PROPERTIES::MainSinkSoundPropertyChangedCallbackIF,//new sound property from hmi base---20.05.2020
//public AUDIO_SOUND_PROPERTIES::GetListMainSinkSoundPropertiesCallbackIF,//new sound property from hmi base---20.05.2020
   public AUDIO_SOUND_PROPERTIES::SystemPropertyChangedCallbackIF,//new sound property from hmi base---20.05.2020
//public AUDIO_SOUND_PROPERTIES::GetListSystemPropertiesCallbackIF,//new sound property from hmi base---20.05.2020
   public AUDIO_SOUND_PROPERTIES::SetSystemPropertyCallbackIF,//new sound property from hmi base---20.05.2020
   public COMMAND_INTERFACE::MainSourceSoundPropertyChangedCallbackIF,		////////////cabin audio
   public AUDIO_SOUND_PROPERTIES::SetMuteStateCallbackIF,
   public HMI_INFO_SERVICE_CHANGE::RegionsMapOutStatusInfoCallbackIF,//	Callback for the  HMIINFOSERVICE Mapout Service Properties-26.05.2020
   public HMI_INFO_SERVICE_CHANGE::CabinsSystemsInfoCallbackIF,
   public AUDIO_SOUND_PROPERTIES::MuteStateCallbackIF
//public COMMAND_INTERFACE::SetVolumeCallbackIF
{
   public:

      virtual ~AudioServiceClient();

      static AudioServiceClient* poGetInstance()
      {
         if (NULL == _AudioSrvClient)
         {
            _AudioSrvClient = new AudioServiceClient();
         }

         return _AudioSrvClient;
      }
      void performMainSinkSoundPropertyUserChange(const uint8& msinkid, const uint16& mtypeproperty, const uint32& mvalue);

      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void registerProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void deregisterProperties(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ::asf::core::ServiceStateChange& stateChange);

      void onRegionsMapOutStatusInfoError(const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::RegionsMapOutStatusInfoError >& error);

      void onRegionsMapOutStatusInfoUpdate(const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr <
                                           HMI_INFO_SERVICE_CHANGE::RegionsMapOutStatusInfoUpdate > & update);

      /*HMIINFOSERVICE Mapout Service Properties-26.05.2020*/

      void onCabinsSystemsInfoError(const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::CabinsSystemsInfoError >& error);

      void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy >& proxy, const ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::CabinsSystemsInfoUpdate >& update);

      /*AUTO MODE*/

      void onActiveSourceListUpdate(const ::boost::shared_ptr< AUDIO_SOURCE_CHANGE::AudioSourceChangeProxy >& proxy,
                                    const ::boost::shared_ptr< AUDIO_SOURCE_CHANGE::ActiveSourceListUpdate >& signal);
      void onActiveSourceListError(const ::boost::shared_ptr< AUDIO_SOURCE_CHANGE::AudioSourceChangeProxy >& proxy,
                                   const ::boost::shared_ptr< AUDIO_SOURCE_CHANGE::ActiveSourceListError >& error);

      /*AUTO MODE */

      /*New Sound Properties update from HMI Base audio---20.05.2020*/


// Callback 'RequestMainSinkSoundPropertyListCallbackIF'

      void onRequestMainSinkSoundPropertyListError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::RequestMainSinkSoundPropertyListError >& error);

      void onRequestMainSinkSoundPropertyListResponse(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::RequestMainSinkSoundPropertyListResponse >& response);

      void onRequestSystemPropertyListError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES:: SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES:: RequestSystemPropertyListError >& error) ;

      void onRequestSystemPropertyListResponse(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES:: SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::RequestSystemPropertyListResponse >& response);

      void onMainSinkSoundPropertyChangedError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::
            boost::shared_ptr<AUDIO_SOUND_PROPERTIES::MainSinkSoundPropertyChangedError >& error);

      void onMainSinkSoundPropertyChangedSignal(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy>& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::MainSinkSoundPropertyChangedSignal >& changedSignal) ;

      void onSetMainSinkSoundPropertyError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetMainSinkSoundPropertyError >& error);

      void onSetMainSinkSoundPropertyResponse(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetMainSinkSoundPropertyResponse >& response) ;

      /* void onGetListMainSinkSoundPropertiesError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES:: SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::GetListMainSinkSoundPropertiesError >& error) ;

      void onGetListMainSinkSoundPropertiesResponse(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES:: SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::GetListMainSinkSoundPropertiesResponse >& response);
       */

      void onSetSystemPropertyError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetSystemPropertyError >& error);

      void onSetSystemPropertyResponse(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetSystemPropertyResponse >& response);

      void onSoundPropertyListError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES:: SoundPropertyListError >& error) ;

      void onSoundPropertyListUpdate(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertyListUpdate >& update) ;

      /* void onGetListSystemPropertiesError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<  AUDIO_SOUND_PROPERTIES::GetListSystemPropertiesError >& error);
      void onGetListSystemPropertiesResponse(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<  AUDIO_SOUND_PROPERTIES::GetListSystemPropertiesResponse >& response);

       */
      void onSystemPropertyListError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SystemPropertyListError >& error) ;

      void onSystemPropertyListUpdate(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SystemPropertyListUpdate >& update);

      void onSystemPropertyChangedError(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SystemPropertyChangedError >& error);
      void onSystemPropertyChangedSignal(const ::boost::shared_ptr<AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SystemPropertyChangedSignal >& signal);

      /*New Sound Properties update from HMI Base audio---20.05.2020*/

      void OnStartupRequestSinkId4CAaudio();

      void onSetMuteStateError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetMuteStateError >& error);

      void onSetMuteStateResponse(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SetMuteStateResponse >& response);

      void onMuteStateError(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::MuteStateError >& error);

      void onMuteStateUpdate(const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy >& proxy, const ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::MuteStateUpdate >& update);
////////////cabin audio
      void onMainSourceSoundPropertyChangedError(const ::boost::shared_ptr< COMMAND_INTERFACE::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< COMMAND_INTERFACE::MainSourceSoundPropertyChangedError >& error);

      void onMainSourceSoundPropertyChangedSignal(const ::boost::shared_ptr< COMMAND_INTERFACE::CommandInterfaceProxy >& proxy, const ::boost::shared_ptr< COMMAND_INTERFACE::MainSourceSoundPropertyChangedSignal >& signal);
////////////cabin audio
      void performSystemPropertyChange(const uint16& mtypeproperty, const uint32& mvalue);
      void performMainSinkSoundPropertyCabinAChange(const uint16& mrxdcaaudiotypeproperty, const uint32& mvalue);

      void AudioServiceSoundPropertyCheckOnValUpdate(int RxdVal, uint16  RxdSinkId, uint16 RxdSoundProperty);
      void AudioServiceSoundPropertyCheckOnPowerUpdate(int RxdVal, uint16  RxdSinkId, uint16 RxdSoundProperty);

      void registerPropertyRegistrationIF();
      void init();
      void clear();
      static void destroy();
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      COURIER_MSG_MAP_END()

      int m_Equaliserval;
      int m_SpeedDepVolCntrlval;
      int32 activesourceId;
      int32 mediasinkidstatus;
      bool cockpit_propertyupdate;
      bool cabinA_propertyupdate;
   private:
      uint8 SinkID_cc;
      int m_typeproperty;
      act_t _mainSinkSoundChanged_RegId;
      act_t _requestMainSinkSoundPropertyList_SPReg_Id;
      act_t _soundPropertyList_SPRegId;
      act_t _requestSystemPropertyList_SPReg_Id;
      act_t _setMainSinkSoundProperty_SPRegId;
      act_t _systemPropertyListUpdate_SPRegId;
      act_t _soundPropertieslistget_SpReg_ID;
      act_t _setSystemProperty_SPRegId;
      act_t _mainSinkSoundSet_RegId;
      act_t _getListMainSinkSound_RegId;
      act_t _getListSystemProperty_RegId;
      act_t _muteStateSet_RegId;
      act_t _muteStateGet_RegId;
      act_t _muteStateChanged_RegId;
      act_t _ampAvailFunctionStatus_RegId;
      act_t _activeSourceListUpdate_RegId;
      act_t _systemPropertyChangedSP_RegId;
      act_t _getListSystemPropertySP_RegId;
      act_t _regionsMapOutStatusInfo_RegId;
      act_t _cabinsSystemsInfo_RegId;
      act_t _sendsystempropertylistget_SPReg_Id;
      act_t    _sendsystempropertylistregister			;

      void  evaluateSourceUpdate(bool isVideoSource, bool isAudioSource, int sinkid, bool isMic1Active);

      //::boost::shared_ptr< ::org::genivi::audiomanager::CommandInterface::CommandInterfaceProxy > _audiosetproxy;
      ::boost::shared_ptr < COMMAND_INTERFACE::CommandInterfaceProxy > _commandIFProxy;

      ::boost::shared_ptr< AUDIO_SOUND_PROPERTIES::SoundPropertiesProxy > _audioSoundPropertiesProxy;

      ::boost::shared_ptr< AUDIO_SOURCE_CHANGE::AudioSourceChangeProxy > _audioSourceChangeProxy;
      ::boost::shared_ptr<HMI_INFO_SERVICE_CHANGE::HmiInfoServiceProxy > _hmiInfoServiceProxy;
      AudioServiceClient();
      static AudioServiceClient* _AudioSrvClient;
};


}
}
