/***************************************************************************
* Copyright(c) 2019-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:AudioPrivateModeRBtn.h
* SW-COMPONENT:  Audio Speed Dependent Volume Control Component
* DESCRIPTION:  AudioPrivateModeRBtn.h is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef RVC_BRIGHTNESS_HANDLER_H
#define RVC_BRIGHTNESS_HANDLER_H
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "rvc_cca_fi_types.h"
#include <string>

namespace App {
namespace Core {

class RVCBrightnessHandler:  public ListImplementation
{
   private:
      RVCBrightnessHandler();

   public:

      static RVCBrightnessHandler* m_poRVCBrightnessHandler;
      int brightnesstype;
      std::string m_brightness;
      bool listcreated;
      int brightnesstypesign;
      uint8 m_ListtypetoRVCSpecBgtUpd;

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      //  ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()

      COURIER_MSG_MAP_ENDS()

      static RVCBrightnessHandler* poGetInstance()
      {
         if (NULL == m_poRVCBrightnessHandler)
         {
            m_poRVCBrightnessHandler = new RVCBrightnessHandler();
         }
         return m_poRVCBrightnessHandler;
      }

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();
      virtual ~RVCBrightnessHandler();
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      void vRVCSettingBrightnessIncdecval(int type);
      void onUpdateMenu(int updatedval);

//	  bool onCourierMessage(const Courier::StartupMsg& oMsg);

      bool Init();
      unsigned long index;
      int type;
      DataBindingItem<RVCBrightnessUpdateItemDataBindingSource> _RVCBrightnessUpdateItem;

      void RVCBSetupVideoUpdateResult4mMW(bool BrightNdContSetupVideoUpdateresult);
};


}
}


#endif // _HMI_MODEL_COMPONENT_H*/
