/*
 * OEMPinAuthentication.h
 *
 *  Created on: Mar 4, 2021
 *      Author: ggo5cob
 */

#ifndef APPHMI_SYSTEM_APP_CORE_APPLOGIC_OEM_OEMPINAUTHENTICATION_H_
#define APPHMI_SYSTEM_APP_CORE_APPLOGIC_OEM_OEMPINAUTHENTICATION_H_

#define MIN_PIN_INPUT_INDX 0
#define MAX_PIN_INPUT_INDX 3
using namespace std;

enum enPin
{
   PIN1 = 0u,
   PIN2,
   PIN3,
   PIN4
};


class UserAuthentication
{
   public:
      UserAuthentication(): pinInputIndex(0), userPIN("")
      {
         keyPin1 = "";
         keyPin2 = "";
         keyPin3 = "";
         keyPin4 = "";
         userConfirmedPIN = "";
         userPINSaved = "";
      }

      uint8 getPinInputIndex() const
      {
         return pinInputIndex;
      }

      void setPinInputIndex(uint8 PinInputIndex)
      {
         this->pinInputIndex = PinInputIndex;
      }
      void incrementPinInputIndex()
      {
         if (pinInputIndex < (MAX_PIN_INPUT_INDX + 1)) //4 is NB
         {
            this->pinInputIndex = static_cast<uint8>(this->pinInputIndex + 1);
         }
      }
      void decrementPinInputIndex()
      {
         if (pinInputIndex > MIN_PIN_INPUT_INDX)
         {
            this->pinInputIndex = static_cast<uint8>(this->pinInputIndex - 1);
         }
      }
      bool isKeyDigitAllowed(string keyDigit)
      {
         bool result = false;
         if ((keyDigit != "*") && (keyDigit != "#") && (keyDigit != "+") && (keyDigit != "."))
         {
            result = true;
         }
         return result;
      }
      bool isNotBackSpace(string KeyDigit)
      {
         bool result = false;
         if (KeyDigit.length() > 0)
         {
            result = true;
         }
         return result;
      }

      const string& getUserPin() const
      {
         return userPIN;
      }
      bool hasUserPin() const
      {
         return !(keyPin1.empty() || keyPin2.empty() || keyPin3.empty() || keyPin4.empty());
      }

      void setUserPin()
      {
         userPIN = keyPin1 + keyPin2 + keyPin3 + keyPin4 ;
      }
      void resetUserPin()
      {
         userPIN.clear();
         keyPin1.clear();
         keyPin2.clear();
         keyPin3.clear();
         keyPin4.clear();
      }

      void setKeyPin(uint8 keyIndex, const string& keyPin)
      {
         switch (keyIndex)
         {
            case PIN1:
               this->keyPin1 = keyPin;
               break;
            case PIN2:
               this->keyPin2 = keyPin;
               break;
            case PIN3:
               this->keyPin3 = keyPin;
               break;
            case PIN4:
               this->keyPin4 = keyPin;
               break;
            default:
               break;
         }
      }

      const string& getUserPinSaved() const
      {
         return userPINSaved;
      }

      void setUserPinSaved(const string& userPinSaved)
      {
         userPINSaved = userPinSaved;
      }

   private:
      uint8 pinInputIndex;
      string userPIN;
      string userPINSaved;
      string userConfirmedPIN;
      string keyPin1, keyPin2, keyPin3, keyPin4;
};


//const string UserAuthentication::BackButton = "0x232B";

#endif /* APPHMI_SYSTEM_APP_CORE_APPLOGIC_USERPROFILE_USERAUTHENTICATION_H_ */
