/**************************************************************************************
* @file         : MicSetting.h
* @author       : Sriganesh
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef MIC_SETTING_H
#define MIC_SETTING_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>

#define PLUS_SIGN   1
#define MINUS_SIGN -1

using namespace std;

namespace App {
namespace Core {
class MicSetting :  public ListImplementation
{
   public:
      virtual ~MicSetting();
      MicSetting(const MicSetting&);
      MicSetting& operator =(const MicSetting&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      static MicSetting* poGetInstance()
      {
         if (NULL == m_poMicSetting)
         {
            m_poMicSetting = new MicSetting();
         }
         return m_poMicSetting;
      }
      void vPerformMainSinkSoundPropertyBassUpdate(const uint16& sinkId, const uint16& soundproperty, const uint16& value);
   private:
      MicSetting();
      static MicSetting* m_poMicSetting;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      void onCreateMaplistUpdate();
      void CheckButtonType(unsigned int RxdColumnBtn, unsigned int Type);

      map<int, int16> m_ListAudSpectoServAudSpec;

      int16 bass_value;
      int16 treble_value;
      bool listcreated;
      uint16 m_propertytype ;
      uint16 signtype;
      Candera::String _bass;
      Candera::String _treble;
};


}
}


#endif
