/**************************************************************************************
* @file         : LanguageSettingListHandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef LANGUAGE_SETTINGS_LIST_HANDLER_H
#define LANUAGE_SETTINGS_LIST_HANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"
#include "PluginConstants.h"
#include "Common/PluginClientHandler/PluginClientHandler.h"
//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>


using namespace std;

/* structure for language list */
struct Language_List
{
   Candera::String LangList;
};


namespace App {
namespace Core {
class LanguageSettingListHandler :  public ListImplementation
{
   public:
      virtual ~LanguageSettingListHandler();
      LanguageSettingListHandler(const LanguageSettingListHandler&);
      LanguageSettingListHandler& operator =(const LanguageSettingListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_DELEGATE_TO_OBJ(_pluginClientHandler)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      //Singleton class implementation
      static LanguageSettingListHandler* poGetInstance()
      {
         if (NULL == m_polanguageSettingListHandler)
         {
            m_polanguageSettingListHandler = new LanguageSettingListHandler();
         }
         return m_polanguageSettingListHandler;
      }
      void sendLanguageUpdateToGUI(uint32  languagecode);
      void sendDoorStatustoPlugin(int status);
      bool listcreated;
   private:
      LanguageSettingListHandler();
      static LanguageSettingListHandler* m_polanguageSettingListHandler;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      bool listUpdateNeeded;
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      typedef ::boost::tuple<int, Candera::String, int, Candera::String, std::string, bool>tp_lang;
      vector<tp_lang>vec_lang;
      bool m_checklang;
      void vCreateMapCultureindextoLangString();
      PluginClientHandler* _pluginClientHandler;
      void setLanguageUpdate(bool m_checklang, int rowidx);
      string langtextid;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
