/**************************************************************************************
* @file         : LanguageSettingListHandler.cpp
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#define ENGLISH 0

#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "LanguageSettingListHandler.h"
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/AppLogic/ClockSettings/ClockDateFormat/ClockDateFormatRbtn.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"
#include "App/Core/ClientHandler/RVC/RearViewCamera.h"
#include <cstdlib>
#include "hmi_trace_if.h"
#include "ProjectPluginMsgs.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::LanguageSettingListHandler::
#include "trcGenProj/Header/LanguageSettingListHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

LanguageSettingListHandler* LanguageSettingListHandler::m_polanguageSettingListHandler = NULL;

static const char* const DATA_CONTEXT_TEXT_BUTTON_TOGGLE_FIRST_LIST_ITEM = "FirstElement_Checkbox";
static const char* const DATA_CONTEXT_TEXT_BUTTON_TOGGLE_LIST_ITEM = "Layer_LSCheckbox";


/************************************************************************
*FUNCTION: 		 AudioSettingListHandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

LanguageSettingListHandler::LanguageSettingListHandler()
{
   ETG_TRACE_COMP(("LanguageSettingListHandler:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_LANGUAGE_EU_LIST, this);
   listUpdateNeeded = false;
   _pluginClientHandler = PluginClientHandler::getInstance();
   m_checklang = false;
   listcreated = false;
   vCreateMapCultureindextoLangString();
}


/************************************************************************
*FUNCTION: 		 LanguageSettingListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

LanguageSettingListHandler::~LanguageSettingListHandler()
{
   ETG_TRACE_COMP(("LanguageSettingListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_LANGUAGE_EU_LIST);
   if (NULL != _pluginClientHandler)
   {
      delete _pluginClientHandler;
      _pluginClientHandler = NULL;
   }
   listcreated = false;
}


void LanguageSettingListHandler::vCreateMapCultureindextoLangString()
{
   ETG_TRACE_COMP(("LanguageSettingListHandler:: vCreateMapCultureindextoLangString is called"));
#ifndef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   vec_lang.push_back(boost::make_tuple(0, "UK_English", 12, Candera::String(TextId_0x0256), std::string("en_GB"), false));
   vec_lang.push_back(boost::make_tuple(1, "German", 23, Candera::String(TextId_0x024C), std::string("de_DE"), false));
   vec_lang.push_back(boost::make_tuple(2, "Dutch", 10, Candera::String(TextId_0x024D), std::string("nl_NL"), false));
   vec_lang.push_back(boost::make_tuple(3, "EU_French", 21, Candera::String(TextId_0x024E), std::string("fr_FR"), false));
   vec_lang.push_back(boost::make_tuple(4, "Italian", 29, Candera::String(TextId_0x024F), std::string("it_IT"), false));
   vec_lang.push_back(boost::make_tuple(5, "EuropeanSpanish", 46, Candera::String(TextId_0x0250), std::string("es_ES"), false));
   vec_lang.push_back(boost::make_tuple(6, "EuropeanPortugese", 39, Candera::String(TextId_0x0251), std::string("pt_PT"), false));
   vec_lang.push_back(boost::make_tuple(7, "Hungarian", 27, Candera::String(TextId_0x102E), std::string("hu_HU"), false));
   vec_lang.push_back(boost::make_tuple(8, "Russian", 42, Candera::String(TextId_0x102F), std::string("ru_RU"), false));
   vec_lang.push_back(boost::make_tuple(9, "Czech", 8, Candera::String(TextId_0x102D), std::string("cs_CZ"), false));
   vec_lang.push_back(boost::make_tuple(10, "Danish", 9, Candera::String(TextId_0x0252), std::string("da_DK"), false));
   vec_lang.push_back(boost::make_tuple(11, "Norwegian", 35, Candera::String(TextId_0x0253), std::string("nb_NO"), false));
   vec_lang.push_back(boost::make_tuple(12, "Polish", 38, Candera::String(TextId_0x102C), std::string("pl_PL"), false));
   vec_lang.push_back(boost::make_tuple(13, "Swedish", 49, Candera::String(TextId_0x024B), std::string("sv_SE"), false));
   //vec_lang.push_back(boost::make_tuple(14, "US_English", 13, Candera::String(TextId_0x1394), std::string("en_US"), false));
   vec_lang.push_back(boost::make_tuple(14, "Greek", 24, Candera::String(TextId_0x1395), std::string("el_GR"), false));
   vec_lang.push_back(boost::make_tuple(15, "Turkish", 52, Candera::String(TextId_0x1030), std::string("tr_TR"), false));
#endif
#if defined VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   vec_lang.push_back(boost::make_tuple(0, "UK_English", 12, Candera::String(TextId_0x0256), std::string("en_GB"), false));
   vec_lang.push_back(boost::make_tuple(1, "German", 23, Candera::String(TextId_0x024C), std::string("de_DE"), false));
   vec_lang.push_back(boost::make_tuple(2, "Dutch", 10, Candera::String(TextId_0x024D), std::string("nl_NL"), false));
   vec_lang.push_back(boost::make_tuple(3, "EU_French", 21, Candera::String(TextId_0x024E), std::string("fr_FR"), false));
   vec_lang.push_back(boost::make_tuple(4, "Italian", 29, Candera::String(TextId_0x024F), std::string("it_IT"), false));
   vec_lang.push_back(boost::make_tuple(5, "EuropeanSpanish", 46, Candera::String(TextId_0x0250), std::string("es_ES"), false));
   vec_lang.push_back(boost::make_tuple(6, "EuropeanPortugese", 39, Candera::String(TextId_0x0251), std::string("pt_PT"), false));
   vec_lang.push_back(boost::make_tuple(7, "Hungarian", 27, Candera::String(TextId_0x102E), std::string("hu_HU"), false));
   vec_lang.push_back(boost::make_tuple(8, "Czech", 8, Candera::String(TextId_0x102D), std::string("cs_CZ"), false));
   vec_lang.push_back(boost::make_tuple(9, "Danish", 9, Candera::String(TextId_0x0252), std::string("da_DK"), false));
   vec_lang.push_back(boost::make_tuple(10, "Norwegian", 35, Candera::String(TextId_0x0253), std::string("nb_NO"), false));
   vec_lang.push_back(boost::make_tuple(11, "Polish", 38, Candera::String(TextId_0x102C), std::string("pl_PL"), false));
   vec_lang.push_back(boost::make_tuple(12, "Swedish", 49, Candera::String(TextId_0x024B), std::string("sv_SE"), false));
   vec_lang.push_back(boost::make_tuple(13, "Greek", 24, Candera::String(TextId_0x1395), std::string("el_GR"), false));
   vec_lang.push_back(boost::make_tuple(14, "Turkish", 52, Candera::String(TextId_0x1030), std::string("tr_TR"), false));
   vec_lang.push_back(boost::make_tuple(15, "Bulgarian", 3, Candera::String(TextId_0x158A), std::string("bg_BG"), false));
   vec_lang.push_back(boost::make_tuple(16, "Slovenian", 45, Candera::String(TextId_0x1589), std::string(" sl_SI"), false));
   vec_lang.push_back(boost::make_tuple(17, "Slovak", 44, Candera::String(TextId_0x1588), std::string("sk_SK"), false));
   vec_lang.push_back(boost::make_tuple(18, "Romanian", 41, Candera::String(TextId_0x1587), std::string("ro_RO"), false));
   vec_lang.push_back(boost::make_tuple(19, "Finnish", 19, Candera::String(TextId_0x1586), std::string("fi_FI"), false));
   vec_lang.push_back(boost::make_tuple(20, "Croatian", 7, Candera::String(TextId_0x1585), std::string("hr_HR"), false));
#endif
}


/**********************************************************************************************
*FUNCTION: 		 LanguageSettingListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider LanguageSettingListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("LanguageSettingListHandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_LANGUAGE_EU_LIST:
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider LanguageSettingListHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_LANGUAGE_EU_LIST);//, DATA_CONTEXT_TEXT_BUTTON_TOGGLE_FIRST_LIST_ITEM);
   LanguageSettingMenuData _mLanguageListItem;
   //List Builder for the first element with no separator
   _mLanguageListItem.mlanguageval = boost::get<TranStr>(vec_lang[ENGLISH]);
   if (boost::get<Toggle>(vec_lang[ENGLISH]) == true)
   {
      _mLanguageListItem.mLanguageActiveColorTextInfo = true;
   }
   else if (boost::get<Toggle>(vec_lang[ENGLISH]) == false)
   {
      _mLanguageListItem.mLanguageActiveColorTextInfo = false;
   }
   listBuilder.AddItem(
      ENGLISH, 	//  - identifies the row
      0UL,   //  - column
      DATA_CONTEXT_TEXT_BUTTON_TOGGLE_FIRST_LIST_ITEM)  //  - overwrites the default data context
   .AddDataBindingUpdater<LanguageSettingMenuDataBindingSource>(_mLanguageListItem)//1 - Text of the button, should be obtained from Candera.
   .AddData(boost::get<Toggle>(vec_lang[ENGLISH]));
   //List Builder for the all other element with separator
   for (unsigned int itemIdx = 1 ; itemIdx < vec_lang.size()  ; itemIdx++)
   {
      _mLanguageListItem.mlanguageval = boost::get<TranStr>(vec_lang[itemIdx]);
      if (boost::get<Toggle>(vec_lang[itemIdx]) == true)
      {
         _mLanguageListItem.mLanguageActiveColorTextInfo = true;
      }
      else if (boost::get<Toggle>(vec_lang[itemIdx]) == false)
      {
         _mLanguageListItem.mLanguageActiveColorTextInfo = false;
      }
      listBuilder.AddItem(
         itemIdx, 	//  - identifies the row
         0UL,   //  - column
         DATA_CONTEXT_TEXT_BUTTON_TOGGLE_LIST_ITEM)  //  - overwrites the default data context
      .AddDataBindingUpdater<LanguageSettingMenuDataBindingSource>(_mLanguageListItem)//1 - Text of the button, should be obtained from Candera.
      .AddData(boost::get<Toggle>(vec_lang[itemIdx]));//2 - Toggle On/Off
   }
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool LanguageSettingListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_LANGUAGE_EU_LIST);
   int rowidx = oMsg.GetHdl();
   bool msgProcessed = false;
   //unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   if (oMsg.GetListId() == LIST_ID_SYSTEM_LANGUAGE_EU_LIST)
   {
      if (oMsg.GetReaction() == enRelease)
      {
         for (unsigned int itemIdx = 0 ; itemIdx < vec_lang.size()  ; ++itemIdx)
         {
            if (boost::get<SNO>(vec_lang[itemIdx]) == rowidx)
            {
               uint32  m_langCode = boost::get<ServiceCode>(vec_lang[itemIdx]);
               ETG_TRACE_USR4(("LanguageSettingListHandler::ButtonListItemUpdMsg:LIST_ID_SYSTEM_LANGUAGE_EU_LIST: m_langCode = %d", m_langCode));
               VehicleSrvClient::poGetInstance()->setHMILanguage(m_langCode);
            }
         }
         msgProcessed = true;
      }
   }
   return msgProcessed;
}


void LanguageSettingListHandler::sendLanguageUpdateToGUI(uint32  languagecode)
{
   ETG_TRACE_COMP(("LanguageSettingListHandler::sendLanguageUpdateToGUI: languagecode =%d", languagecode));
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_LANGUAGE_EU_LIST);
   for (unsigned int itemIdx = 0; itemIdx < vec_lang.size(); itemIdx++)
   {
      string _textid;
      if (boost::get<ServiceCode>(vec_lang[itemIdx]) == static_cast<int>(languagecode))
      {
         _textid = boost::get<CultureReqCodeStr>(vec_lang[itemIdx]);
         boost::get<Toggle>(vec_lang[itemIdx]) = true;
      }
      if (boost::get<ServiceCode>(vec_lang[itemIdx]) != static_cast<int>(languagecode))
      {
         boost::get<Toggle>(vec_lang[itemIdx]) = false;
      }
   }
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_LANGUAGE_EU_LIST);
   }
   SystemSettingsListHandler::poGetInstance()->SetLanguageStatus(languagecode);
   RearViewCamera::poGetInstance()->SetLanguage_RVC(languagecode);
}


}
}
