/**************************************************************************************
* @file         : ConfigurationVersion.cpp
* @author       : Prashant BG
* @Date		 	: 23.11.2021
* @addtogroup   : AppHmi_System
* @brief        : Updated changes for displaying date format.
* @copyright    : (C) 2019 Robert Bosch GmbH
*                 (C) 2019 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>


#include "ConfigurationVersion.h"
#include <cstdlib>
#include "hmi_trace_if.h"
#include "App/Core/Utils/XMLParser/XMLParser.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::ConfigurationVersion::
#include "trcGenProj/Header/ConfigurationVersion.cpp.trc.h"
#endif

#if defined VARIANT_S_FTR_ENABLE_NAVIGATION

namespace App {
namespace Core {

ConfigurationVersion* ConfigurationVersion::m_poConfigurationVersion = NULL;
Candera::String ConfigurationVersionTextStrings[3]  = {Candera::String(TextId_0x1A25), Candera::String(TextId_0x1A26), Candera::String(TextId_0x1A27)};//{"Vehicle configuration identifier:","Configuration version:","Configuration engine version:"};//

/************************************************************************
*FUNCTION: 		 ConfigurationVersion - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*23.11.2021 Prashant BG
*0.1 Initial Revision.
************************************************************************/

ConfigurationVersion::ConfigurationVersion()
{
   ETG_TRACE_COMP(("ConfigurationVersion:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_SO_CONFIGURATIONVERSION_LIST, this);
}


/************************************************************************
*FUNCTION: 		 ConfigurationVersion - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*23.11.2021 Prashant BG

*0.1 Initial Revision.
************************************************************************/

ConfigurationVersion::~ConfigurationVersion()
{
   ETG_TRACE_COMP(("ConfigurationVersion:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_SO_CONFIGURATIONVERSION_LIST);
}


/**********************************************************************************************
*FUNCTION: 		 ConfigurationVersion - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
* Prashant BG
* 23.11.2021

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider ConfigurationVersion::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_SO_CONFIGURATIONVERSION_LIST: //Settings Time Zone Clock List items are requested
         return getMainViewListDataProvider();
         break;
   }
   return tSharedPtrDataProvider();
}


/**********************************************************************************************
*FUNCTION: 		 ConfigurationVersion - getMainViewListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 null
*RETURNVALUE: 	tSharedPtrDataProvider
*
*HISTORY:
* Prashant BG
* 23.11.2021


*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider ConfigurationVersion::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_SO_CONFIGURATIONVERSION_LIST);

   bool configVersionCisNetworkXmlretval = XMLDocParser::GetInstance()->FetchConfigurationVersionCisNetworkXml();
   bool configVersionDoIpcInstallResultval = XMLDocParser::GetInstance()->FetchConfigurationVersionDoIpcInstallResultXml();

   std::vector<ConfigurationVersionItems> _RXDconfgVerCisNetworkVecItem;
   _RXDconfgVerCisNetworkVecItem = XMLDocParser::GetInstance()->GetConfigurationVersionCisNetworkData();
   int  RXDconfgVerCisNetworkVecItemSize = _RXDconfgVerCisNetworkVecItem.size();
   ETG_TRACE_USR4(("XMLDocParser::configVersionCisNetworkXmlretval RXDconfgVerCisNetworkVecItemSize==>%d %d \n", configVersionCisNetworkXmlretval , RXDconfgVerCisNetworkVecItemSize));

   for (uint8 logval = 0; logval < CIS_NETWORK_LIST_SIZE; logval++)
   {
      if (RXDconfgVerCisNetworkVecItemSize == CIS_NETWORK_LIST_SIZE) //Complete List is Filled
      {
         if (!(_RXDconfgVerCisNetworkVecItem[logval].ConfigVal.empty()))  // not equal to empty
         {
            ETG_TRACE_USR4(("XMLDocParser::GetConfigurationVersionData _RXDconfgVerCisNetworkVecItem obtained ConfigVal ==> %s", _RXDconfgVerCisNetworkVecItem[logval].ConfigVal.c_str()));
            listBuilder.AddItem(logval , 0UL, "ConfigurationVersionComp").AddData(ConfigurationVersionTextStrings[logval]).AddData(_RXDconfgVerCisNetworkVecItem[logval].ConfigVal.c_str());
         }
      }
      else
      {
         ETG_TRACE_USR4(("XMLDocParser::GetConfigurationVersionData _RXDconfgVerCisNetworkVecItem obtained ConfigVal EmptyField==> %s", "Unknown"));
         listBuilder.AddItem(logval , 0UL, "ConfigurationVersionComp").AddData(ConfigurationVersionTextStrings[logval]).AddData("Unknown");
      }
   }

   std::vector<ConfigurationVersionItems> _RXDconfgVerDoIpcInstallVecItem;
   _RXDconfgVerDoIpcInstallVecItem = XMLDocParser::GetInstance()->GetConfigurationVersionDoIpcInstallData();
   int  RXDconfgVerDoIpcInstallVecItemSize = _RXDconfgVerDoIpcInstallVecItem.size();
   ETG_TRACE_USR4(("XMLDocParser:: configVersionDoIpcInstallResultval RXDconfgVerDoIpcInstallVecItemSize ==>%d %d ", configVersionDoIpcInstallResultval, RXDconfgVerDoIpcInstallVecItemSize));

   if (RXDconfgVerDoIpcInstallVecItemSize == DO_IPC_INSTALL_LIST_SIZE)
   {
      if (!(_RXDconfgVerDoIpcInstallVecItem[CIS_NETWORK_ROW_ZERO].ConfigVal.empty())) // not equal to empty
      {
         ETG_TRACE_USR4(("XMLDocParser::GetConfigurationVersionData _RXDconfgVerDoIpcInstallVecItem obtained ConfigVal ==>%s ", _RXDconfgVerDoIpcInstallVecItem[CIS_NETWORK_ROW_ZERO].ConfigVal.c_str()));
         listBuilder.AddItem(CIS_NETWORK_ROW_TWO , 0UL, "ConfigurationVersionComp").AddData(ConfigurationVersionTextStrings[CIS_NETWORK_ROW_TWO]).AddData(_RXDconfgVerDoIpcInstallVecItem[CIS_NETWORK_ROW_ZERO].ConfigVal.c_str());
      }
   }
   else
   {
      ETG_TRACE_USR4(("XMLDocParser::GetConfigurationVersionData _RXDconfgVerDoIpcInstallVecItem obtained ConfigVal EmptyField==> %s \n", "Unknown"));
      listBuilder.AddItem(CIS_NETWORK_ROW_TWO , 0UL, "ConfigurationVersionComp").AddData(ConfigurationVersionTextStrings[CIS_NETWORK_ROW_TWO]).AddData("Unknown");
   }

   return listBuilder.CreateDataProvider();
}


}//End of Core
}//End of App


#endif
