/**************************************************************************************
* @file         : GpsClockListHandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef GPSCLOCKLISTHANDLER_H
#define GPSCLOCKLISTHANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

/* #include "LanguageSettingListHandler.h"*/
#include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>
#include <boost/tuple/tuple.hpp>
// Removed the DaylightSavingTime based on Bug 963829
//#define DAYLIGHTSAVINGTIME 4

using namespace std;


namespace App {
namespace Core {
class GpsClockListHandler :  public ListImplementation
{
   public:
      //Removed the ButtonListItemUpdMsg Courier message as it was handling only DaylightSavingTime.
      //Removed the DaylightSavingTime based on Bug 963829
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);

      //void DestroyTimeformatDropdown();
      //void DestroyClockformatDropdown();
      int clocksettingmode;
      bool listcreated;
      virtual ~GpsClockListHandler();
      // Removed the DaylightSavingTime based on Bug 963829
      //bool _DayLightToggleStatus;
      GpsClockListHandler(const GpsClockListHandler&);
      GpsClockListHandler& operator =(const GpsClockListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ChangeGpsClockTimeformatReqMsg)
      ON_COURIER_MESSAGE(ChangeGpsClockClkModeReqMsg)

      //Removed the ButtonListItemUpdMsg Courier message as it was handling only DaylightSavingTime.
      //Removed the DaylightSavingTime based on Bug 963829

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      virtual bool onCourierMessage(const ChangeGpsClockTimeformatReqMsg& oMsg);
      virtual bool onCourierMessage(const ChangeGpsClockClkModeReqMsg& oMsg);
      //Singleton class implementation

      static GpsClockListHandler* poGetInstance()
      {
         if (NULL == m_poGpsClockListHandler)
         {
            m_poGpsClockListHandler = new GpsClockListHandler();
         }
         return m_poGpsClockListHandler;
      }
      void SetGpsClkformatpropertyUpdateHMI(const int& timeFormat);
      void bonsetsynmodetoPL(const int& gpsenablestatus);

      //Removed the DaylightSavingTime based on Bug 963829
      //void DisplayDayLightSavingTimeStatus(uint8 DayLightSavingTimeStatus);

      void updateDropDownMsg();
      void GpsDateUpdateStatus(int dateFormat);
      void handleAuto_TimeZoneOffsetPropertyUpdate(const Auto_TimeZonePropertyInfo& OffsetPropertyInfo);
      void updatedSelectedTimeZone(const Candera::String timezone);
   private:
      GpsClockListHandler();
      int m_GpsclkClockMode;
      unsigned int rowIdx;
      static GpsClockListHandler* m_poGpsClockListHandler;

      //enTimeformatOption _currentTimeformatOption;
      //Candera::String _currentTimeformatOptionStr;
      //enClockformatOption _currentClockformatOption;
      //Candera::String _currentClockformatOptionStr;

      //	enGpsClkTimeformatOption _currentGpsClkTimeformatOption;
      enGpsClkTimeformatOption _currentGpsClkTimeformatOption;
      enGpsClkClockModeformatOption _currentGpsClkClockformatOption;
      // 	enGpsClkClockModeformatOption _currentGpsClockClkModeOption;  later has to be taken care
      Candera::String _currentGpsClkTimeformatOptionStr;
      Candera::String _currentGpsClkClockModeformatOptionStr;

      std::string itoa(int16 value) const;

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getGpsClkMainListDataProvider();
      tSharedPtrDataProvider getDropdownTimeFormat4GpsClkListDataProvider();

      tSharedPtrDataProvider getDropdownClockModeFormat4GpsClkListDataProvider();

      typedef ::boost::tuple<string, int, int, int>tp_GpsClkClockModeSettings;
      vector<tp_GpsClkClockModeSettings>vec_GpsClkClockModesettings;
      DataBindingItem<ClockTimeZoneDataBindingSource> _timeZoneClockListInfo;
      /* int type;
      	unsigned int rowIdx;
      	void bonrefreshissue();

      	bool listUpdateNeeded; */

      void vCreateMapCultureIndex2GpsClockClkModeString();
      Candera::String _timeZoneText;
      Candera::String _dateformat;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
