/**************************************************************************************
* @file         : GpsClockListHandler.cpp
* @author       : Sushmita Dikshit
* @addtogroup   : AppHmi_System
* @brief        : Updated changes for displaying date format.
* @copyright    : (c) 2018-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "AppUtils/StrUtf8.h"
#include "App/Core/ClientHandler/ClockSrvClient/ClockSrvClient.h"
#include "GpsClockListHandler.h"
#include "ClockSettings.h"
#include <cstdlib>
#include "hmi_trace_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::GpsClockListHandler::
#include "trcGenProj/Header/GpsClockListHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

GpsClockListHandler* GpsClockListHandler::m_poGpsClockListHandler = NULL;


Candera::String  GpsClockSettingString[4] = {Candera::String(TextId_0x06CF), Candera::String(TextId_0x06F1), Candera::String(TextId_0x06EF), Candera::String(TextId_0x06C9) }; //TextId_0x06C7- Removed the DaylightSavingTime based on Bug 963829
unsigned long DateFormatString1[6] = {TextId_0x06B9, TextId_0x13A0, TextId_0x06B7, TextId_0x06BA, TextId_0x13A1, TextId_0x06BB};
//12hr and 24hrs
Candera::String GpsClkTimeFormatStrings[2]  = {  Candera::String(TextId_0x06E5), Candera::String(TextId_0x06E4)};
//Manuel and GPS
Candera::String GpsClkClockModeFormatStrings[2] = { Candera::String(TextId_0x178B), Candera::String(TextId_0x06FA)};

// Removed the DaylightSavingTime based on Bug 963829
//static const char* const DAYLIGHTSAVING_DATA_TEXT_BUTTON_TOGGLE_LIST_ITEM = "Layer_Checkbox";  //Check Box for Daylight saving
static const char* const GPS_DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM = "TextButton_ListItem"; //Date Format Button
static const char* const GPSCLK_TIMEZONE_CONTEXT_COMBOBOX_LIST_ITEM = "TextButton_ListItem_Timezone"; //Timezone button
static const char* const DATA_CONTEXT_COMBOBOX_LIST_ITEM = "Timeformat_ListItem"; // TimeFormat List Drop Down
static const char* const DATA_CONTEXT_CLOCKMODE_COMBOBOX_LIST_ITEM = "ClockSettingMode_ListItem"; // ClockMode List Drop Down

/************************************************************************
*FUNCTION: 		 GpsClockListHandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
************************************************************************/

GpsClockListHandler::GpsClockListHandler()
{
   ETG_TRACE_COMP(("GpsClockListHandler:: Constructor is called"));
   m_GpsclkClockMode = 0;
   clocksettingmode = 1;
   rowIdx = 0;
   listcreated = false;
   _dateformat = "";
   _currentGpsClkClockModeformatOptionStr = "Gps";
   // Removed the DaylightSavingTime based on Bug 963829
   //_DayLightToggleStatus = true;
   _currentGpsClkClockformatOption = gpsclkmodtwelvehour;
   _currentGpsClkTimeformatOption = gpstwelvehour;
   _currentGpsClkTimeformatOptionStr = "12H";
   vec_GpsClkClockModesettings.clear();
   vCreateMapCultureIndex2GpsClockClkModeString();
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_GPS_CLOCK_LIST, this);
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST, this); //2nd row dropdown list id
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST, this); //2nd row dropdown list id
   _timeZoneText = "";
}


/************************************************************************
*FUNCTION: 		 GpsClockListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
************************************************************************/

GpsClockListHandler::~GpsClockListHandler()
{
   ETG_TRACE_COMP(("GpsClockListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST); //2nd row dropdown list id
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST); //2nd row dropdown list id
   vec_GpsClkClockModesettings.~vector<tp_GpsClkClockModeSettings>();
   listcreated = false;
}


void GpsClockListHandler::vCreateMapCultureIndex2GpsClockClkModeString()
{
   ETG_TRACE_COMP(("GpsClockListHandler::vCreateMapCultureIndex2GpsClockClkModeString"));
   vec_GpsClkClockModesettings.push_back(boost::make_tuple("GPS", 1, 1, 0));
   vec_GpsClkClockModesettings.push_back(boost::make_tuple("Manual", 2, 0, 0));
}


/**********************************************************************************************
*FUNCTION: 		 GpsClockListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider GpsClockListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("GpsClockListHandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_SYSTEM_GPS_CLOCK_LIST:
         return getGpsClkMainListDataProvider(); //main list id

      case LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST: //2nd row dropdown list id
         return getDropdownTimeFormat4GpsClkListDataProvider();

      case LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST: //3rd row dropdown list id
         return getDropdownClockModeFormat4GpsClkListDataProvider();
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider GpsClockListHandler::getGpsClkMainListDataProvider()
{
   ETG_TRACE_USR1(("GtSharedPtrDataProvider GpsClockListHandler::getGpsClkMainListDataProvider()"));
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   //Date Format
   listBuilder.AddItem(
      GpsDateFormat,
      0UL,   //  - column
      GPS_DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM)  //  - overwrites the default data context
   .AddData(GpsClockSettingString[0]).AddData(_dateformat);//1 - Text of the button, should be obtained from Candera.
   // //12Hrs and 24 Hrs Selection
   listBuilder.AddExpandableItem(GpsTimeFormat,            //  enum name available in systemtypes.h - identifies the row
                                 LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST,                          //  Main list name  - used to automatically toggle the visibility of the combobox dropdown list when the combox button is clicked
                                 DATA_CONTEXT_COMBOBOX_LIST_ITEM)         //SceneComposer Dock Layout name   - overwrites the default data context
   .AddData(GpsClockSettingString[1])  // Text of the combobox button.
   .AddData(LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST)				 // Main list name - ListId of the combobox dropdown list.
   .AddData(_currentGpsClkTimeformatOptionStr);	//3 - Text of the label displayed in front of the combobox button, should be obtained

   //GPS AND Manuel Mode Selection
   listBuilder.AddExpandableItem(GpsClockSettingMode,            //  enum name available in systemtypes.h - identifies the row
                                 LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST,                          //  Main list name  - used to automatically toggle the visibility of the combobox dropdown list when the combox button is clicked
                                 DATA_CONTEXT_CLOCKMODE_COMBOBOX_LIST_ITEM)         //SceneComposer Dock Layout name   - overwrites the default data context
   .AddData(GpsClockSettingString[2])  // Text of the combobox button.
   .AddData(LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST)				 // Main list name - ListId of the combobox dropdown list.
   .AddData(_currentGpsClkClockModeformatOptionStr);	//3 - Text of the label displayed in front of the combobox button, should be obtained

   // Removed the DaylightSavingTime based on Bug 963829
   //DAYLIGHTSAVINGTIME ---> UNDER PROGRESS
   //listBuilder.AddItem(
   //   GpsDayLightSavingTime, 	//  - identifies the row
   //  0UL,   //  - column
   //   DAYLIGHTSAVING_DATA_TEXT_BUTTON_TOGGLE_LIST_ITEM)  //  - overwrites the default data context
   //.AddData(GpsClockSettingString[3])//1 - Text of the button, should be obtained from Candera.
   //.AddData(_DayLightToggleStatus);//2 - Toggle On/Off

   if (ClockSettings::poGetInstance()->isNaviVariant() == false) //Applicable only for Smart and Turkish CMC
   {
      //TimeZone
      ETG_TRACE_USR1(("GtSharedPtrDataProvider GpsClockListHandler::getGpsClkMainListDataProvider() GPSCLK_TIMEZONE_CONTEXT_COMBOBOX_LIST_ITEM"));
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      listBuilder.AddItem(GpsTimeZone, 0UL, GPSCLK_TIMEZONE_CONTEXT_COMBOBOX_LIST_ITEM).AddData(GpsClockSettingString[3]).AddData(_timeZoneText);
#endif
   }

   listcreated = true;
   return listBuilder.CreateDataProvider();
}


//GPS AND Manuel Mode Selection
tSharedPtrDataProvider GpsClockListHandler::getDropdownClockModeFormat4GpsClkListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST, "ClockSettingDropdownListButton");
   listBuilder.AddItem(1UL).AddData(GpsClkClockModeFormatStrings[0]);
   listBuilder.AddItem(2UL).AddData(GpsClkClockModeFormatStrings[1]);
   return listBuilder.CreateDataProvider();
}


//12Hrs and 24 Hrs Selection
tSharedPtrDataProvider GpsClockListHandler::getDropdownTimeFormat4GpsClkListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST, "TimeformatDropdownListButton");
   listBuilder.AddItem(1UL).AddData(GpsClkTimeFormatStrings[0]);
   listBuilder.AddItem(2UL).AddData(GpsClkTimeFormatStrings[1]);
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


//12Hrs and 24 Hrs Selection
bool GpsClockListHandler::onCourierMessage(const ChangeGpsClockTimeformatReqMsg& oMsg)
{
   unsigned int GpsTimeselectOpt = oMsg.GetGpsTimeFormatOptions();
   if (GpsTimeselectOpt <= 2)
   {
      // Subtract 1 to match the selection and enumeration index,
      // handle for first option in dropdown is 1. However, the enumeration value for same is 0
      _currentGpsClkTimeformatOption = static_cast<enGpsClkTimeformatOption>(GpsTimeselectOpt);
   }
   ETG_TRACE_USR1(("GpsClockListHandler::onCourierMessage-ChangeClockformatReqMsg: GpsTimeselectOpt =%d, _currentGpsClkTimeformatOption=%d", GpsTimeselectOpt, _currentGpsClkTimeformatOption));
   ClockSrvClient::poGetInstance()->covsetTimeFormatProperty(_currentGpsClkTimeformatOption);
   return true;
}


//clockmode --gps and manuel

bool GpsClockListHandler::onCourierMessage(const ChangeGpsClockClkModeReqMsg& oMsg)
{
   int GpsClockEnableStatus = 0; //Set to default value 0 to resolve coverity warning
   int GpsClockBitPositionStatus = 0; //Set to default value 0 to resolve coverity warning
   int GpsClockModeSelectOpt = oMsg.GetGpsClkClockModeOptions();
   ETG_TRACE_USR1(("GpsClockListHandler::ChangeGpsClockClkModeReqMsg: GpsClockModeSelectOpt=%d, GpsClockEnableStatus=%d, GpsClockBitPositionStatus=%d", GpsClockModeSelectOpt, GpsClockEnableStatus, GpsClockBitPositionStatus));
   for (int itemIdx = 0 ; itemIdx < static_cast<int>(vec_GpsClkClockModesettings.size()); ++itemIdx)
   {
      ETG_TRACE_USR2(("GpsClockListHandler::ChangeGpsClockClkModeReqMsg:boost GpsClkClockMode=%d", (boost::get<GpsClkClockMode>(vec_GpsClkClockModesettings[itemIdx]))));
      if (boost::get<GpsClkClockMode>(vec_GpsClkClockModesettings[itemIdx]) == GpsClockModeSelectOpt)
      {
         GpsClockEnableStatus = boost::get<GpsClkEnableStatus>(vec_GpsClkClockModesettings[GpsClockModeSelectOpt - 1]);
         GpsClockBitPositionStatus = boost::get<GpsClkPositionStatus>(vec_GpsClkClockModesettings[itemIdx]);
         ETG_TRACE_USR3(("GpsClockListHandler::ChangeGpsClockClkModeReqMsg inside itemidx=%d, GpsClockEnableStatus=%d,GpsClockBitPositionStatus=%d", GpsClockEnableStatus, GpsClockBitPositionStatus, boost::get<GpsClkClockMode>(vec_GpsClkClockModesettings[itemIdx])));
      }
   }
   if (GpsClockModeSelectOpt != clocksettingmode)
   {
      POST_MSG((COURIER_MESSAGE_NEW(Displayclock)()));
   }
   if (GpsClockModeSelectOpt == 1)
   {
      GpsClockBitPositionStatus = true;
      //   POST_MSG((COURIER_MESSAGE_NEW(Displayclock)()));
   }
   else
   {
      GpsClockBitPositionStatus = false;
   }
   ETG_TRACE_USR1(("GpsClockListHandler::ChangeGpsClockClkModeReqMsg  Outside GpsClockBitPositionStatus=%d",  GpsClockBitPositionStatus));
   ClockSrvClient::poGetInstance()->covSetAutoSyncPropertyToService(GpsClockEnableStatus, GpsClockBitPositionStatus);
   return true;
}


//12Hrs and 24 Hrs Selection
void GpsClockListHandler::SetGpsClkformatpropertyUpdateHMI(const int& timeFormat)
{
   //ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   ETG_TRACE_COMP(("GpsClockListHandler::SetGpsClkformatpropertyUpdateHMI: TimeFormat:=%d ", timeFormat));
   if (timeFormat == 2)
   {
      _currentGpsClkTimeformatOption = static_cast<enGpsClkTimeformatOption>(2);
      _currentGpsClkTimeformatOptionStr = GpsClkTimeFormatStrings[1];
   }
   else
   {
      _currentGpsClkTimeformatOption = static_cast<enGpsClkTimeformatOption>(1);
      _currentGpsClkTimeformatOptionStr = GpsClkTimeFormatStrings[0];
   }
   ETG_TRACE_USR1(("GpsClockListHandler::SetGpsClkformatpropertyUpdateHMI: _currentGpsClkTimeformatOption=%d, _currentGpsClkTimeformatOptionStr=%s", _currentGpsClkTimeformatOption, _currentGpsClkTimeformatOptionStr.GetCString()));
   if (listcreated == true)
   {
      ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_TIMEFORMAT_LIST);
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   }
}


//under progress
//Gps and Manual
void GpsClockListHandler::bonsetsynmodetoPL(const int& gpsenablestatus)
{
   ETG_TRACE_COMP(("GpsClockListHandler::bonsetsynmodetoPL: gpsenablestatus = %d", gpsenablestatus));
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   for (int itemIdx = 0 ; itemIdx < static_cast<int>(vec_GpsClkClockModesettings.size())  ; ++itemIdx)
   {
      if (boost::get<GpsClkEnableStatus>(vec_GpsClkClockModesettings[itemIdx]) == gpsenablestatus)
      {
         m_GpsclkClockMode = boost::get<GpsClkClockMode>(vec_GpsClkClockModesettings[itemIdx]);
      }
   }
   // Subtract 1 to match the selection and enumeration index,
   // handle for first option in dropdown is 1. However, the enumeration value for same is 0
   _currentGpsClkClockformatOption = static_cast<enGpsClkClockModeformatOption>(m_GpsclkClockMode);
   _currentGpsClkClockModeformatOptionStr = GpsClkClockModeFormatStrings[m_GpsclkClockMode - 1U];
   ETG_TRACE_USR1(("ClockSettings::ChangeClockformatReqMsg: m_GpsclkClockMode:=%d, _currentGpsClkClockformatOption=%d, _currentGpsClkClockModeformatOptionStr=%s", m_GpsclkClockMode, _currentGpsClkClockformatOption, _currentGpsClkClockModeformatOptionStr.GetCString()));
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_CLOCKFORMAT_LIST);
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   }
}


// Removed the DaylightSavingTime based on Bug 963829
/*void GpsClockListHandler::DisplayDayLightSavingTimeStatus(uint8 DayLightSavingTimeStatus)
{
   ETG_TRACE_COMP(("GpsClockListHandler::DisplayDayLightSavingTimeStatus: DayLightSavingTimeStatus = %d", DayLightSavingTimeStatus));
   ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   _DayLightToggleStatus = DayLightSavingTimeStatus;
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
      tSharedPtrDataProviderUpdater dataProviderUpdater = modifiedListItems.CreateDataProviderUpdater();
      POST_MSG(COURIER_MESSAGE_NEW(ListDataProviderUpdMsg)(dataProviderUpdater));
   }
}*/


///

// Removed the DaylightSavingTime based on Bug 963829
//Take care , if there is any button press
bool GpsClockListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool msgProcessed = false;
   rowIdx = (unsigned int)oMsg.GetHdl();
   if (oMsg.GetListId() == LIST_ID_SYSTEM_GPS_CLOCK_LIST)
   {
      updateDropDownMsg();
      ListDataProviderBuilder modifiedListItems(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
      /* if (oMsg.GetListId() == LIST_ID_SYSTEM_GPS_CLOCK_LIST)
      {
         if (oMsg.GetReaction() == enRelease)
         {
            switch (oMsg.GetHdl())
            {
               case GpsDayLightSavingTime:
               {
                 _DayLightToggleStatus = !_DayLightToggleStatus;
                  ETG_TRACE_USR4(("GpsClockListHandler::ButtonListItemUpdMsg:LIST_ID_SYSTEM_GPS_CLOCK_LIST: _DayLightToggleStatus %d", _DayLightToggleStatus));
                  ClockSrvClient::poGetInstance()->setDSTPropertyToService(_DayLightToggleStatus);
                 msgProcessed = true;
               }
               break;
               default:
                  break;
            }
         }
      } */
   }
   return msgProcessed;
}


//Date Format Updation on change
/*
 * GpsDateUpdateStatus - dateFormat String updated on call of every onNewDateFormatStatus from clock server client
 * @param[in] dateFormat
 * @param[out] None
 * @return voidl
 * todo :check As of now after onNewDateFormatStatus is called the value of date format and update the string accordingly*/
void GpsClockListHandler::GpsDateUpdateStatus(int dateFormat)
{
   ETG_TRACE_USR1(("GpsClockListHandler::GpsDateUpdateStatus received dateformat=%d", dateFormat));
   if ((dateFormat >= 1) && (dateFormat <= 6))
   {
      ETG_TRACE_USR1(("GpsClockListHandler::GpsDateUpdateStatus Valid Date format"));
      _dateformat = Candera::String(DateFormatString1[dateFormat - 1]);
   }
   else
   {
      ETG_TRACE_USR1(("GpsClockListHandler::GpsDateUpdateStatus Invalid Date format"));
   }
   ETG_TRACE_USR1(("GpsClockListHandler::GpsDateUpdateStatus Updated value of dateformat-=%d, dateFormatString-= %s", dateFormat, _dateformat.GetCString()));
   /*    oDateFmtUpdateItem.MarkAllItemsModified();
      oDateFmtUpdateItem.SendUpdate(true); */
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   }
}


void GpsClockListHandler::updateDropDownMsg()
{
   ETG_TRACE_COMP(("GpsClockListHandler::updateDropDownMsg: rowIdx = %d", rowIdx));
   Candera::DropdownChangeType ddChange = Candera::DropdownChangeClose;
   if (((rowIdx == 1)))
   {
      ddChange = Candera::DropdownChangeClose;
      DropdownChangeMsg* ddToggleMsg_ClockFormat = COURIER_MESSAGE_NEW(DropdownChangeMsg)(ddChange, 118);
      if (ddToggleMsg_ClockFormat != NULL)
      {
         ddToggleMsg_ClockFormat->Post();
      }
   }
   else if (((rowIdx == 2)))
   {
      ddChange = Candera::DropdownChangeClose;
      DropdownChangeMsg* ddToggleMsg_TimeFormat = COURIER_MESSAGE_NEW(DropdownChangeMsg)(ddChange, 117);
      if (ddToggleMsg_TimeFormat != NULL)
      {
         ddToggleMsg_TimeFormat->Post();
      }
   }
   else
   {
      DropdownChangeMsg* ddToggleMsg_TimeFormat = COURIER_MESSAGE_NEW(DropdownChangeMsg)(ddChange, 117);
      if (ddToggleMsg_TimeFormat != NULL)
      {
         ddToggleMsg_TimeFormat->Post();
      }
      DropdownChangeMsg* ddToggleMsg_ClockFormat = COURIER_MESSAGE_NEW(DropdownChangeMsg)(ddChange, 118);
      if (ddToggleMsg_ClockFormat != NULL)
      {
         ddToggleMsg_ClockFormat->Post();
      }
   }
}


/**
* itoa - Handle to convert from int16 to string
* @param[in] value
* @parm[out] none
* @return std::string
*/
std::string GpsClockListHandler::itoa(int16 value) const
{
   uint8  TEXT_BUFFER_SIZE	= 10;
   char itoa_txt[TEXT_BUFFER_SIZE];
   snprintf(itoa_txt, sizeof(itoa_txt), "%d", value);
   return (itoa_txt);
}


/**
 * handleAuto_TimeZoneOffsetPropertyUpdate - To update Auto_TimeZoneoffset property received from Clock Service
 * @param[in] Auto_TimeZonePropertyInfo
 * @param[out] None
 * @return void
 */
void GpsClockListHandler::handleAuto_TimeZoneOffsetPropertyUpdate(const Auto_TimeZonePropertyInfo& OffsetPropertyInfo)
{
   ETG_TRACE_COMP(("GpsClockListHandler::handleAuto_TimeZoneOffsetPropertyUpdate is called with hours =%d minutes = %d", OffsetPropertyInfo.hour, OffsetPropertyInfo.minutes));
   (*_timeZoneClockListInfo).mOFFSetHourText    = itoa(OffsetPropertyInfo.hour).c_str();
   (*_timeZoneClockListInfo).mOFFSetMinuteText  = itoa(OffsetPropertyInfo.minutes).c_str();
   _timeZoneClockListInfo.MarkAllItemsModified();
   _timeZoneClockListInfo.SendUpdate(true);
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   }
}


/**
 * handleAuto_TimeZoneOffsetPropertyUpdate - To update Auto_TimeZoneoffset property received from Clock Service
 * @param[in] Auto_TimeZonePropertyInfo
 * @param[out] None
 * @return void
 */
void GpsClockListHandler::updatedSelectedTimeZone(const Candera::String timezone)
{
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
   _timeZoneText = timezone;
   ETG_TRACE_USR1(("GpsClockListHandler::updatedSelectedTimeZone:  _timeZoneText= %s", _timeZoneText.GetCString()));
#endif
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_SYSTEM_GPS_CLOCK_LIST);
   }
}


}
}
