/***************************************************************************
* Copyright(c) 2018-2019 Robert Bosch Car Multimedia GmbH
* This software is property of Robert Bosch GmbH.
***************************************************************************/
/* ***************************************************************************************
* FILE:ClockDateFormatRBtn.h
* SW-COMPONENT:  Clock Date Format Component
*  DESCRIPTION:  ClockDateFormatRBtn.h is part of Clock Setting reference applications
* Author 	: Sushmita Dikshit
*Brief description: changes made for language change
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CLOCKDATEFORMATRBTN_H
#define CLOCKDATEFORMATRBTN_H
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include <string>

#define mSpdProperty 15
#define mOffSpdValue  0
#define mLvl1SpdValue 1
#define mLvl2SpdValue 2
#define mLvl3SpdValue 3


#define mClkDatFt1  1
#define mClkDatFt2  2
#define mClkDatFt3  3
#define mClkDatFt4  4
#define mClkDatFt5  5
#define mClkDatFt6  6

namespace App {
namespace Core {

class ClockDateFormatRadioBtn
{
   private:
      ClockDateFormatRadioBtn();

   public:
      static ClockDateFormatRadioBtn* m_poClockDateFormatRadioBtn;
      static ClockDateFormatRadioBtn* poGetInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(ClkDateFmt1)
      ON_COURIER_MESSAGE(ClkDateFmt2)
      ON_COURIER_MESSAGE(ClkDateFmt3)
      ON_COURIER_MESSAGE(ClkDateFmt4)
      ON_COURIER_MESSAGE(ClkDateFmt5)
      ON_COURIER_MESSAGE(ClkDateFmt6)

      COURIER_MSG_MAP_END()

      void UpdateClkDateFmtTglStatus(int UpdateClkDateFmt);
      bool UpdateDateonLanguageChange();
      virtual ~ClockDateFormatRadioBtn();
      virtual bool onCourierMessage(const ClkDateFmt1& oMsg);
      virtual bool onCourierMessage(const ClkDateFmt2& oMsg);
      virtual bool onCourierMessage(const ClkDateFmt3& oMsg);
      virtual bool onCourierMessage(const ClkDateFmt4& oMsg);
      virtual bool onCourierMessage(const ClkDateFmt5& oMsg);
      virtual bool onCourierMessage(const ClkDateFmt6& oMsg);
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      int m_clockdata;
      bool Init();
      DataBindingItem<ClockDateFormatDataBindingSource> oClockDateFormat;
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
