/* ***************************************************************************************
* FILE:         ClockDateFormatRBtn.cpp
* SW-COMPONENT:  Clock Date Format Component
*  DESCRIPTION:  ClockDateFormatRBtn.cpp is part of Clock Setting reference applications
* Author 	: Sushmita Dikshit
*Brief description: changes made for language change
*    COPYRIGHT:  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

#include "util/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
//#include "App/Core/AppLogic/ClockSettings/ClockDateFormat/ClockDateFormatRbtn.h"
#include "App/Core/ClientHandler/ClockSrvClient/ClockSrvClient.h"
#include "App/Core/AppLogic/ClockSettings/ClockSettings.h"
#include "App/Core/AppLogic/ClockSettings/GpsClockListHandler.h"

#include "ClockDateFormatRbtn.h"
#include "hmi_trace_if.h"
#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::ClockDateFormatRbtn
#include "trcGenProj/Header/ClockDateFormatRbtn.cpp.trc.h"
#endif

using namespace std;
using namespace App::Core;


ClockDateFormatRadioBtn* ClockDateFormatRadioBtn::m_poClockDateFormatRadioBtn = NULL;
ClockDateFormatRadioBtn::ClockDateFormatRadioBtn()
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn:: Constructor"));
   m_clockdata = 1;
   // UpdateClkDateFmtTglStatus(mClkDatFt1);
   // oClockDateFormat.MarkAllItemsModified();
   // bool bDataUpdated =  oClockDateFormat.SendUpdate(true);
}


ClockDateFormatRadioBtn* ClockDateFormatRadioBtn::poGetInstance()
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::poGetInstance"));
   if (NULL == m_poClockDateFormatRadioBtn)
   {
      m_poClockDateFormatRadioBtn = new ClockDateFormatRadioBtn();
   }
   return m_poClockDateFormatRadioBtn;
}


ClockDateFormatRadioBtn::~ClockDateFormatRadioBtn()
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::Destructor"));
}


bool ClockDateFormatRadioBtn::onCourierMessage(const ClkDateFmt1& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::ClkDateFmt1"));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(mClkDatFt1);
   return true;
}


bool ClockDateFormatRadioBtn::onCourierMessage(const ClkDateFmt2& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::ClkDateFmt2"));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(mClkDatFt2);
   return true;
}


bool ClockDateFormatRadioBtn::onCourierMessage(const ClkDateFmt3& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::ClkDateFmt3"));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(mClkDatFt3);
   return true;
}


bool ClockDateFormatRadioBtn::onCourierMessage(const ClkDateFmt4& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::ClkDateFmt4"));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(mClkDatFt4);
   return true;
}


bool ClockDateFormatRadioBtn::onCourierMessage(const ClkDateFmt5& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::ClkDateFmt5"));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(mClkDatFt5);
   return true;
}


bool ClockDateFormatRadioBtn::onCourierMessage(const ClkDateFmt6& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::ClkDateFmt6"));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(mClkDatFt6);
   return true;
}


void ClockDateFormatRadioBtn :: UpdateClkDateFmtTglStatus(int UpdateClkDateFmt)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn :: UpdateClkDateFmtTglStatus: UpdateClkDateFmt = %d", UpdateClkDateFmt));
   m_clockdata = static_cast<uint8>(UpdateClkDateFmt);
   (* oClockDateFormat).mToggleClkDateFmt1 = false;
   (* oClockDateFormat).mToggleClkDateFmt2 = false;
   (* oClockDateFormat).mToggleClkDateFmt3 = false;
   (* oClockDateFormat).mToggleClkDateFmt4 = false;
   (* oClockDateFormat).mToggleClkDateFmt5 = false;
   (* oClockDateFormat).mToggleClkDateFmt6 = false;

   (* oClockDateFormat).mColorClkDateFmt1 = false;
   (* oClockDateFormat).mColorClkDateFmt2 = false;
   (* oClockDateFormat).mColorClkDateFmt3 = false;
   (* oClockDateFormat).mColorClkDateFmt4 = false;
   (* oClockDateFormat).mColorClkDateFmt5 = false;
   (* oClockDateFormat).mColorClkDateFmt6 = false;

   if (UpdateClkDateFmt == mClkDatFt1)
   {
      (* oClockDateFormat).mToggleClkDateFmt1 = true;
      (* oClockDateFormat).mColorClkDateFmt1 = true;
   }
   else if (UpdateClkDateFmt == mClkDatFt2)
   {
      (* oClockDateFormat).mToggleClkDateFmt2 = true;
      (* oClockDateFormat).mColorClkDateFmt2 = true;
   }
   else if (UpdateClkDateFmt == mClkDatFt3)
   {
      (* oClockDateFormat).mToggleClkDateFmt3 = true;
      (* oClockDateFormat).mColorClkDateFmt3 = true;
   }
   else if (UpdateClkDateFmt == mClkDatFt4)
   {
      (* oClockDateFormat).mToggleClkDateFmt4 = true;
      (* oClockDateFormat).mColorClkDateFmt4 = true;
   }
   else if (UpdateClkDateFmt == mClkDatFt5)
   {
      (* oClockDateFormat).mToggleClkDateFmt5 = true;
      (* oClockDateFormat).mColorClkDateFmt5 = true;
   }
   else if (UpdateClkDateFmt == mClkDatFt6)
   {
      (* oClockDateFormat).mToggleClkDateFmt6 = true;
      (* oClockDateFormat).mColorClkDateFmt6 = true;
   }
   else
   {
   }

   oClockDateFormat.MarkAllItemsModified();
   oClockDateFormat.SendUpdate(true);
}


bool ClockDateFormatRadioBtn::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn:StartupMsg"));
   return true;
}


/*
 * UpdateDateonLanguageChange - dateFormat String updated on call of language change
 * @param[in] None
 * @param[out] None
 * @return void
 * todo :check As of now after onlanguagechange is called the value of date format and update the string accordingly*/

bool ClockDateFormatRadioBtn::UpdateDateonLanguageChange()
{
   ETG_TRACE_COMP(("ClockDateFormatRadioBtn::UpdateDateonLanguageChange: m_clockdata=%d", m_clockdata));
   ClockSrvClient::poGetInstance()->setDateFormatPropertyToService(static_cast<uint8>(m_clockdata));
   return true;
}
