/**************************************************************************************
* @file         : CabinBSettingListhandler.h
* @author       : Prashant Bg
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef CABIN_B_SETTINGS_LIST_HANDLER_H
#define CABIN_B_SETTINGS_LIST_HANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include<map>
#include <boost/tuple/tuple.hpp>
using namespace std;
namespace App {
namespace Core {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_B_SUPPORT
class CabinBSettingListhandler :  public ListImplementation
{
   public:

      virtual ~CabinBSettingListhandler();
      CabinBSettingListhandler(const CabinBSettingListhandler&);
      CabinBSettingListhandler& operator =(const CabinBSettingListhandler&);
      bool listcreated;

      // Incomming events ...
      bool onCourierMessage(const Courier::StartupMsg& oMsg);
      //bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      //ON_COURIER_MESSAGE(ButtonListItemUpdMsg)

      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

      static CabinBSettingListhandler* poGetInstance()
      {
         if (NULL == m_poCabinBSettingListhandler)
         {
            m_poCabinBSettingListhandler = new CabinBSettingListhandler();
         }
         return m_poCabinBSettingListhandler;
      }

   private:
      void vCreateCabinBListUpdate();
      static CabinBSettingListhandler* m_poCabinBSettingListhandler;
      CabinBSettingListhandler();

      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      typedef ::boost::tuple<string, string, Candera::String>mycabinB;
      vector<mycabinB>my_cabinB_vec;
      std::string IMG_ICON_NORMAL_CB;
      std::string IMG_ICON_PRESS_CB;
      std::string IMG_CABIN_B_ICON_NORMAL;
      std::string IMG_CABIN_B_ICON_TOUCHED;
      Candera::String CABIN_B_MAIN_TEXT;
};


#endif
}


}
#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
