/**************************************************************************************
* @file         : CabinAVideoMixSourceListHandler.cpp
* @author       : Prashant BG
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
#include "CabinAVideoMixSourceListHandler.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"
#include <cstdlib>
#include "hmi_trace_if.h"
#include "ProjectBaseTypes.h"
#define DISABLE 0
#define ENABLE 1
//#define SYSTEM_STATUS_NONE 0
/* #define SYSTEM_STATUS_CONNECTED 1
#define SYSTEM_STATUS_UNAVAILABLE 2
#define SYSTEM_STATUS_DISCONNECTED 0 */

#define SYSTEM_DISCONNECTED 0
#define SYSTEM_CONNECTED 	1
#define SYSTEM_UNAVAILABLE 	2

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinAVideoMixSourceListHandler::
#include "trcGenProj/Header/CabinAVideoMixSourceListHandler.cpp.trc.h"
#endif

namespace App {
namespace Core {

CabinAVideoMixSourceListHandler* CabinAVideoMixSourceListHandler::m_poCabinAVideoMixSourceListHandler = NULL;
static const char* const ENABLE_DISABLE_BUTTON_TOGGLE_VMS_LIST_ITEM = "VMS_SecondButton_Text_Checkbox_Icon_EnDisbGrey";

/************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - Constructor
*DESCRIPTION: 	 default constructor of the CabinAVideoMixSourceListHandler Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
************************************************************************/

CabinAVideoMixSourceListHandler::CabinAVideoMixSourceListHandler()
{
   ETG_TRACE_COMP(("CabinAVideoMixSourceListHandler:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST, this);

   mapsize = 0;
   prevIndex = 0;
   prevIndex2Gui = 0;
   index = 0;
   lastIndexb4PowerCycle = 0;
   listcreated = false;
   Variant_Type = NAVI;
   for (int i = 0; i < 5; i++)
   {
      _vmsStructObj[i].vmsSourceId = 0;
      _vmsStructObj[i].vmsConnectionStatus = 0;
      _vmsStructObj[i].vmstextId = 0;
      _vmsStructObj[i].vmsRbtnStatus = 0;
   }
}


/************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
************************************************************************/
CabinAVideoMixSourceListHandler::~CabinAVideoMixSourceListHandler()
{
   ETG_TRACE_COMP(("CabinAVideoMixSourceListHandler:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST);
   listcreated = false;
}


/**********************************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider CabinAVideoMixSourceListHandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinAVideoMixSourceListHandler:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST:
         return getMainViewListDataProvider();
   }
   return tSharedPtrDataProvider();
}


/**********************************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - getMainViewListDataProvider
*DESCRIPTION: 	 Creates a list data
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider CabinAVideoMixSourceListHandler::getMainViewListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST, ENABLE_DISABLE_BUTTON_TOGGLE_VMS_LIST_ITEM);
   uint32 _cameranames[5] = {};
   ETG_TRACE_USR1(("tSharedPtrDataProvider CabinAVideoMixSourceListHandler::getMainViewListDataProvider()INSIDE mapsize=%d", mapsize));
   for (unsigned int index = 0; index < mapsize; index++)
   {
      _cameranames[index] = _vmsStructObj[index].vmstextId ;

      // vmsSourceId ==> 0-None  1-map 2-ip1 3-ip2 4-ip3
      //For MAP- CMG-A2 //SYSTEM_STATUS_NONE - 0 // SYSTEM_STATUS_CONNECTED  (1 White) // SYSTEM_STATUS_UNAVAILABLE (2 Removed4mList) // SYSTEM_STATUS_DISCONNECTED  (0 Greyed out)(actual 3 means unavailable from cabininfo)
      //For Camera - 						       // SYSTEM_STATUS_CONNECTED  (1 White) // SYSTEM_STATUS_UNAVAILABLE (2 Removed4mList) // SYSTEM_STATUS_DISCONNECTED  (0 Greyed out)

      if ((_vmsStructObj[index].vmsConnectionStatus == SYSTEM_CONNECTED)) //source is map and status is available (should be shown in white)
      {
         (*_vmsCabinMenuObj).mvmsSourceRadioBtnEnDisb = _vmsStructObj[index].vmsRbtnStatus; // Image icon
         (*_vmsCabinMenuObj).mvmsSourceTextEnDisb = ENABLE; //Text Enabled

         listBuilder.AddItem(
            index,
            0UL,
            ENABLE_DISABLE_BUTTON_TOGGLE_VMS_LIST_ITEM)   //  0 - NameBind
         .AddData(Candera::String(_cameranames[index]))  //1- TextBinding
         .AddData((*_vmsCabinMenuObj).mvmsSourceRadioBtnEnDisb)  //2  RadioBtn can be selected 0 / 1 in future
         .AddDataBindingUpdater<vmsCabinMenuDataBindingSource>(_vmsCabinMenuObj); //Text Color -white/color
      }
      else if (_vmsStructObj[index].vmsConnectionStatus == SYSTEM_DISCONNECTED) //source is map and status is Not Availabed (should be Greyed out)
      {
         (*_vmsCabinMenuObj).mvmsSourceRadioBtnEnDisb = 2; // Image icon is disabled
         (*_vmsCabinMenuObj).mvmsSourceTextEnDisb = DISABLE; // Text Disabled

         listBuilder.AddItem(
            index, 	//
            0UL,   //
            ENABLE_DISABLE_BUTTON_TOGGLE_VMS_LIST_ITEM)
         .AddData(Candera::String(_cameranames[index]))
         .AddData((*_vmsCabinMenuObj).mvmsSourceRadioBtnEnDisb) // Radio Button Disabled
         .AddDataBindingUpdater<vmsCabinMenuDataBindingSource>(_vmsCabinMenuObj) ;   // Text Disabled
      }
      else
      {
      }
      ETG_TRACE_USR1(("tSharedPtrDataProvider CabinAVideoMixSourceListHandler::getMainViewListDataProvider()INSIDE ENABLE ==>  Source==>%d ConnecctionStatus==>%d,vmsRbtnStatus==>%d,UserID==>%d",  _vmsStructObj[index].vmsSourceId, _vmsStructObj[index].vmsConnectionStatus, _vmsStructObj[index].vmsRbtnStatus, _vmsStructObj[index].vmstextId));
      ETG_TRACE_USR1(("tSharedPtrDataProvider CabinAVideoMixSourceListHandler::getMainViewListDataProvider()INSIDE ENABLE ==>  cameranames[index]==>%d mvmsSourceRadioBtnEnDisb==>%d,mvmsSourceTextEnDisb==>%d", _cameranames[index], (*_vmsCabinMenuObj).mvmsSourceRadioBtnEnDisb, (*_vmsCabinMenuObj).mvmsSourceTextEnDisb));
   }//end of for

   listcreated = true;
   return listBuilder.CreateDataProvider();
}


/**********************************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - onCourierMessage()
*DESCRIPTION: 	 ButtonListItemUpdMsg
*PARAMETER:		 const ButtonListItemUpdMsg& oMsg
*RETURNVALUE: 	 bool()
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
bool CabinAVideoMixSourceListHandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool msgProcessed = false;
   int vmsCurrentSourceSelected = 0;
   unsigned int rowIdx = (unsigned int)oMsg.GetHdl();
   ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::onCourierMessage ButtonListItemUpdMsg mapsize=%d rowIdx=%d", mapsize, rowIdx));

   if (oMsg.GetListId() == LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST)
   {
      ETG_TRACE_USR3(("CabinAVideoMixSourceListHandler::onCourierMessage ButtonListItemUpdMsg list id ==>%d", oMsg.GetListId()));
      if (_vmsStructObj[rowIdx].vmsConnectionStatus != SYSTEM_DISCONNECTED)
      {
         ETG_TRACE_USR3(("CabinAVideoMixSourceListHandler::onCourierMessage ButtonListItemUpdMsg connection status ==>%d", _vmsStructObj[rowIdx].vmsConnectionStatus));
         if ((rowIdx < mapsize) && (rowIdx != prevIndex) && (oMsg.GetReaction() == enRelease))
         {
            vmsCurrentSourceSelected = _vmsStructObj[rowIdx].vmsSourceId;
            CabinInfoSrvClient::poGetInstance()->userSelectedindex(vmsCurrentSourceSelected, CABIN_VIDEO_MIX_CHANGE_REASON_USER);
            prevIndex = rowIdx;
         }
         //This below Condition on Power(kl15) off and on --1st Row Selection won't work
         if ((prevIndex == rowIdx) && (index == 0))
         {
            vmsCurrentSourceSelected = _vmsStructObj[rowIdx].vmsSourceId;
            CabinInfoSrvClient::poGetInstance()->userSelectedindex(vmsCurrentSourceSelected, CABIN_VIDEO_MIX_CHANGE_REASON_USER);
            index = 1;
            prevIndex = rowIdx;
         }
         ETG_TRACE_USR3(("CabinAVideoMixSourceListHandler::onCourierMessage ButtonListItemUpdMsg Msg Reaction[%d] vmsCurrentSourceSelected  [%d],rowIdx[%d],prevIndex[%d],_vmsStructObj[rowIdx].vmsSourceId[%d]", oMsg.GetReaction(), vmsCurrentSourceSelected, rowIdx, prevIndex, _vmsStructObj[rowIdx].vmsSourceId));
         msgProcessed = true;
      }//end of ConnectionStatus
   }
   return msgProcessed;
}


/**********************************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - UpdateVmsGuiOnUserSelection
*DESCRIPTION: 	 GUI Update
*PARAMETER:		 unsigned int vmsSourceSelectedInfo
*RETURNVALUE: 	 bool
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
void CabinAVideoMixSourceListHandler::UpdateVmsGuiOnUserSelection(unsigned int vmsSourceSelectedInfo)
{
   unsigned int rowIdx2Gui = 0 ;
   if ((Variant_Type == NON_NAVI) && (vmsSourceSelectedInfo > 1))
   {
      rowIdx2Gui = vmsSourceSelectedInfo - 1; // since mapout is removed for NON_NAVI variant subtract 1 to avoid index mismatch of radio button.
   }
   else
   {
      rowIdx2Gui = vmsSourceSelectedInfo;
   }

   lastIndexb4PowerCycle = rowIdx2Gui;
   ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVmsGuiOnUserSelection vmsSourceSelectedInfo[%d], Current Row Index(lastIndexb4PowerCycle/rowIdx2Gui) [%d] Prev Row Index(prevIndex2Gui) [%d] prevIndex[%d]", vmsSourceSelectedInfo, rowIdx2Gui, prevIndex2Gui, prevIndex));
   if (rowIdx2Gui != 5)
   {
      if (rowIdx2Gui != prevIndex2Gui)
      {
         _vmsStructObj[rowIdx2Gui].vmsRbtnStatus = true;	// Toggle Button
         _vmsStructObj[prevIndex2Gui].vmsRbtnStatus = false;
      }
      else //At start up if both prev and current are same ..
      {
         _vmsStructObj[rowIdx2Gui].vmsRbtnStatus = true;	// Toggle Button
      }
      prevIndex2Gui = rowIdx2Gui;

      if (prevIndex2Gui != prevIndex)
      {
         prevIndex = prevIndex2Gui;
      }
      if (listcreated == true)
      {
         ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST);
      }
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinAVideoMixSourceListHandler - UpdateVideoMixSource
*DESCRIPTION: 	 Status Update of External Device
*PARAMETER:		 map<int, map<int, uint32> >&  cabinSysteminfo
*RETURNVALUE: 	 void()
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
void CabinAVideoMixSourceListHandler::UpdateVideoMixSource(map<int, map<int, uint32> >&  cabinSysteminfo)
{
   vmsListMapData.clear();
   vmsListMapData = cabinSysteminfo;
   unsigned int indexno, DAindex = 0, index = 0;

   Variant_Type = SystemSettingsListHandler::poGetInstance()->VariantType();
   ETG_TRACE_USR4(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource Variant_Type = %d", Variant_Type));

   for (itr = cabinSysteminfo.begin(), indexno = 0; itr != cabinSysteminfo.end(); itr++, indexno++)
   {
      // indexno - index of first aboove loop - for (itr = cabinSysteminfo.begin(), indexno = 0; itr != cabinSysteminfo.end(); itr++, indexno++)
      // DAindex - increments the index if any DA related features are to be removed.
      // index - final index of the _vmsStructObj structure data.
      ETG_TRACE_USR4(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource indexno=%d, DAindex=%d, index=%d", indexno, DAindex, index));
      for (ptr = itr->second.begin(); ptr != itr->second.end(); ptr++)
      {
         std::string cameraname = (Candera::String(ptr->second)).GetCString();
         ETG_TRACE_USR4(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource cameraname = %s", cameraname.c_str()));

         if ((Variant_Type == NON_NAVI) && (cameraname == "Map out"))
         {
            DAindex++ ;
            ETG_TRACE_USR4(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource ignoring the Mapout data for NON_NAVI variant and DAindex = %d", DAindex));
         }
         else
         {
            index = indexno - DAindex;
            ETG_TRACE_USR4(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource indexno=%d, DAindex=%d, index=%d", indexno, DAindex, index));
            _vmsStructObj[index].vmsSourceId = itr->first;
            _vmsStructObj[index].vmsConnectionStatus = ptr->first;// This is used even for  Button Text Color and Rbtn Available and UnAvailable // Value 0--> Not Available() and (Grey Rbtn Circle with Grey Text ) and // Value 1--> Available (White Rbtn With Text )
            _vmsStructObj[index].vmstextId = ptr->second;
            // This is used to restore the lastactive on powercycle
            if (index != lastIndexb4PowerCycle)
            {
               _vmsStructObj[index].vmsRbtnStatus = false;
            }
            else
            {
               _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus = true;
            }
         }
      }
      ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT :StructAssignment DAindex==>%d lastIndexb4PowerCycle==>%d", DAindex, lastIndexb4PowerCycle));
      ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT :StructAssignment indexno==> %d Source==>%d ConnecctionStatus==>%d,UserID==>%d RbtnStatus=%d", indexno, _vmsStructObj[indexno].vmsSourceId, _vmsStructObj[indexno].vmsConnectionStatus, _vmsStructObj[indexno].vmstextId,  _vmsStructObj[indexno].vmsRbtnStatus));
   }

   if (DAindex != 0)
   {
      mapsize = vmsListMapData.size() - DAindex; // substract how many non navi items are removed from the list available from client handler.
   }
   else
   {
      mapsize = vmsListMapData.size();
   }

   if (listcreated == true)
   {
      bool sceneTransitionRequest = false;
      bool listUpdateRequest = true; //if (Variant_Type == NON_NAVI)
      ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT : ..............")) ;
      if (Variant_Type == NON_NAVI)
      {
         ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NON_NAVI variant")) ;
         // since Mapout is removed from the data received for NON_NAVI subtracting 1 for every index which comes after Mapout data.
         if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1 - 1].vmsRbtnStatus == true)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NON_NAVI:CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1  ,_vmsStructObj[%d].vmsRbtnStatus ==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1 - 1].vmsConnectionStatus == SYSTEM_DISCONNECTED)
            {
               prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
               ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NON_NAVI CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1"));
               CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR);
               sceneTransitionRequest = false;
               listUpdateRequest = false;
            }
         }
         else if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2 - 1].vmsRbtnStatus == true)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NON_NAVI:CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2  _vmsStructObj[%d].vmsRbtnStatus ==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2 - 1].vmsConnectionStatus == SYSTEM_DISCONNECTED)
            {
               prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
               ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NON_NAVI CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2"));
               CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR);
               sceneTransitionRequest = false;
               listUpdateRequest = false;
            }
         }
         else if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3 - 1].vmsRbtnStatus == true)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NON_NAVI:CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3  ,_vmsStructObj[%d].vmsRbtnStatus==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3 - 1].vmsConnectionStatus == SYSTEM_DISCONNECTED)
            {
               prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
               ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NON_NAVI CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3"));
               CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR);
               sceneTransitionRequest = false;
               listUpdateRequest = false;
            }
         }
      }
      else
      {
         ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NAVI variant")) ;
         if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_MAP_OUT].vmsConnectionStatus == SYSTEM_DISCONNECTED)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NAVI:CABIN_VIDEO_MIX_INDEX_MAP_OUT  _vmsStructObj[%d].vmsRbtnStatus ==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
            ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NAVI CABIN_VIDEO_MIX_INDEX_MAP_OUT"));
            CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMG_ERROR);
            sceneTransitionRequest = true;
            listUpdateRequest = false;
         }
         else if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1].vmsRbtnStatus == true)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NAVI:CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1  _vmsStructObj[%d].vmsRbtnStatus==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1].vmsConnectionStatus == SYSTEM_DISCONNECTED)
            {
               prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
               ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NAVI CABIN_VIDEO_MIX_INDEX_IP_CAMERA_1"));
               CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR);
               sceneTransitionRequest = false;
               listUpdateRequest = false;
            }
         }
         else if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2].vmsRbtnStatus == true)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NAVI:CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2  _vmsStructObj[%d].vmsRbtnStatus ==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2].vmsConnectionStatus == SYSTEM_DISCONNECTED)
            {
               prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
               ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NAVI CABIN_VIDEO_MIX_INDEX_IP_CAMERA_2"));
               CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR);
               sceneTransitionRequest = false;
               listUpdateRequest = false;
            }
         }
         else if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3].vmsRbtnStatus == true)
         {
            ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO ASSIGNEMENT NAVI:CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3  _vmsStructObj[%d].vmsRbtnStatus==%d", lastIndexb4PowerCycle, _vmsStructObj[lastIndexb4PowerCycle].vmsRbtnStatus));
            if (_vmsStructObj[CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3].vmsConnectionStatus == SYSTEM_DISCONNECTED)
            {
               prevIndex = CABIN_VIDEO_MIX_INDEX_NONE;
               ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource NAVI CABIN_VIDEO_MIX_INDEX_IP_CAMERA_3"));
               CabinInfoSrvClient::poGetInstance()->userSelectedindex(CABIN_VIDEO_MIX_INDEX_NONE, CABIN_VIDEO_MIX_CHANGE_REASON_CMP_ERROR);
               sceneTransitionRequest = false;
               listUpdateRequest = false;
            }
         }
      }

      if (listUpdateRequest == true)
      {
         ETG_TRACE_USR1(("CabinAVideoMixSourceListHandler::UpdateVideoMixSource CABINSYSTEMINFO updateList LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST"));
         ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_SETTING_A_VIDEOMIXSOURCE_LIST);
      }
      if (sceneTransitionRequest == true)
      {
         ETG_TRACE_USR1((" CabinAVideoMixSourceListHandler::UpdateVideoMixSource index %d vmsSourceId %d vmsConnectionStatus %d", index, _vmsStructObj[index].vmsSourceId, _vmsStructObj[index].vmsConnectionStatus));
         POST_MSG((COURIER_MESSAGE_NEW(VideoMixedSourceBack4mCabinHome)()));
      }
   }
}


}//end of core
}//end of app
