/**************************************************************************************
* @file         : CabinASettingListhandler.cpp
* @author       : Prashant BG
* @addtogroup   : AppHmi_System
* @brief        :
* @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "CabinASettingListhandler.h"
#include "CabinAGlassSettingListhandler.h"
/* #include "App/Core/ClientHandler/VehicleSrvClient/VehicleSrvClient.h"
#include "App/Core/ClientHandler/DownloadSrvClient/SWUpdateClient.h" */
#include "hmi_trace_if.h"
#include "CgiExtensions/ImageLoader.h"
#include "spm_core_fi_typesConst.h"
#include "Common/VariantHandling/VariantHandling.h"
#include "Common/ApplicationSwitchClientComponent/ApplicationSwitchClientComponent.h"
#include "App/Core/AppLogic/SystemSettingListhandler/SystemSettingsListHandler.h"
#include "App/Core/ClientHandler/BTSrvClient/ServiceBT.h"
#include "App/datapool/SystemDataPoolConfig.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinASettingListhandler::
#include "trcGenProj/Header/CabinASettingListhandler.cpp.trc.h"
#endif

#define CABINASETTINGSLISTSIZE 18
#define INVALID_REGION -1
#define CHECKBOX_UNCHECKED_GREYEDOUT 2
#define CHECKBOX_CHECKED_GREYEDOUT 3

using namespace ::spm_core_fi_types;

namespace App {
namespace Core {
#ifdef VARIANT_S_FTR_ENABLE_CABIN_A_SUPPORT
CabinASettingListhandler* CabinASettingListhandler::m_poCabinASettingListhandler = NULL;
static const char* const DATA_CONTEXT_TEXT_LIST_ITEM = "Layer_Sound";


std::string basePath_CA = "AppHmi_System#Images#SO_CabinASysSettings#";
/************************************************************************
*FUNCTION: 		 CabinASettingListhandler - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinASettingListhandler::CabinASettingListhandler()
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: Constructor is called"));
   listcreated = false;
   _currentglassavalStatus = false;
   _HMIState = 0;
   CABIN_A_MAIN_TEXT = Candera::String(TextId_0x1585);
   varianttype = INF4CV_VARIANT;
   _bluetoothstatus = false;
   _ActiveView = "";
   _serialnumber = "";
   _currentSelectedLanguage = "";
   _dataCarrierVersion = "";
   _regionBasedMapoutEnable = INVALID_REGION;
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_CABIN_A_MAIN_LIST, this);
   vCreateCabinAListUpdate();
   if (VariantHandling::getInstance() != NULL)
   {
      varianttype = VariantHandling::getInstance()->getVariantType();
      ETG_TRACE_USR2(("CabinASettingListhandler Constructor varianttype=%d", varianttype));
      //varianttype = CABIN_CONTORLLER_VARIANT;//hardcoded the variant handling value as 1 to be removed once the value is known.
   }
   if (SystemSettingsListHandler::poGetInstance() != NULL)
   {
      _serialnumber = SystemSettingsListHandler::poGetInstance()->vGetSerialNumber();
      ETG_TRACE_USR2(("CabinASettingListhandler Constructor _serialnumber=%s", _serialnumber));
   }
   if (VehicleConfigurationReader::getInstance() != NULL)
   {
      VehicleConfigurationReader::getInstance()->registerForRegionUpdate(this);
   }
   if (SystemDataPoolConfig::getInstance() != NULL)
   {
      _etaonsecondarymapstatus = SystemDataPoolConfig::getInstance()-> getETAStatus();
      ETG_TRACE_USR2(("CabinASettingListhandler Constructor _etaonsecondarymapstatus=%d", _etaonsecondarymapstatus));
      if (CabinInfoSrvClient::poGetInstance() != NULL)
      {
         CabinInfoSrvClient::poGetInstance()->setETAAvailableStatus(_etaonsecondarymapstatus);
      }
   }
}


/************************************************************************
*FUNCTION: 		 CabinASettingListhandler - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
************************************************************************/

CabinASettingListhandler::~CabinASettingListhandler()
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: Destructor is called"));
   my_cabinA_vec.clear();
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_CABIN_A_MAIN_LIST);
   listcreated = false;
   applicationState = false;
   if (VehicleConfigurationReader::getInstance() != NULL)
   {
      VehicleConfigurationReader::getInstance()->deRegisterForRegionUpdate(this);
   }
}


bool CabinASettingListhandler::onCourierMessage(const Courier::StartupMsg&)
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: StartupMsg is called"));
   return true;
}


void CabinASettingListhandler::updateRegionStatusValue(const uint8 regionValue)
{
   ETG_TRACE_USR4(("CabinASettingListhandler: updateRegionStatusValue %d ", regionValue));
   if ((regionValue == TUR) || (regionValue == GCC))
   {
      _regionBasedMapoutEnable = false;
   }
   else
   {
      _regionBasedMapoutEnable = true;
   }
   ETG_TRACE_USR4(("CabinASettingListhandler: _regionBasedMapoutEnable %d ", _regionBasedMapoutEnable));
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - vCreateCabinAListUpdate
*DESCRIPTION: 	 Create maping between list id and and the value
*PARAMETER:		 None
*RETURNVALUE: 	 NONE
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
void CabinASettingListhandler::vCreateCabinAListUpdate()
{
   ETG_TRACE_USR2(("CabinASettingListhandler:: vCreateCabinAListUpdate "));
   //@PGA5COB - Reset To Factory Setting is Removed in Cabin as per Bug 1773578
   std::string IconNormalCA[CABINASETTINGSLISTSIZE] = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_normalBmp", "Icon_Displaymixedsource_normalBmp", "Icon_BT_normalBmp", "Icon_displyasetting_normalBmp", "Icon_Language_normalBmp",
                                                       "Icon_Vehiclesetting_normalBmp", "Icon_Data_normalBmp", "Icon_softversion_normalBmp", "Icon_Softwareupdate_normalBmp", "Icon_Software_update_history_NormalBmp", "Icon_GNSS_NormalBmp",
                                                       "Icon_Servicemenu_normalBmp", "Icon_Resettouserdefaultsettings_normalBmp", "Icon_serial_number_NormalBmp", "Icon_OpenSrcSw_normalBmp", "Icon_BT_normalBmp", "Icon_ETAonsecondarymap_normalBmp"
                                                      };
   std::string IconPressedCA[CABINASETTINGSLISTSIZE] = {"Icon_SoundSettings_touchedBmp", "Icon_Glasssetting_touchedBmp", "Icon_Displaymixedsource_activeBmp", "Icon_BT_activeBmp", "Icon_displyasetting_activeBmp", "Icon_Language_touchedBmp",
                                                        "Icon_Vehiclesetting_touchedBmp", "Icon_Data_activeBmp", "Icon_softversion_activeBmp", "Icon_Softwareupdate_TouchedBmp", "Icon_Software_update_history_ActiveBmp", "Icon_GNSS_ActiveBmp",
                                                        "Icon_Servicemenu_activeBmp", "Icon_Resettouserdefaultsettings_touchedBmp", "Icon_serial_number_ActiveBmp", "Icon_OpenSrcSw_touchedBmp", "Icon_BT_activeBmp", "Icon_ETAonsecondarymap_activeBmp"
                                                       };
   std::string IconNormalGlassDisbCA[CABINASETTINGSLISTSIZE] = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_disabledBmp", "Icon_Displaymixedsource_disableBmp", "Icon_BT_disabledBmp", "Icon_displyasetting_normalBmp", "Icon_Language_normalBmp",
                                                                "Icon_Vehiclesetting_normalBmp", "Icon_Data_normalBmp", "Icon_softversion_normalBmp", "Icon_Softwareupdate_normalBmp", "Icon_Software_update_history_NormalBmp", "Icon_GNSS_NormalBmp",
                                                                "Icon_Servicemenu_normalBmp", "Icon_Resettouserdefaultsettings_normalBmp", "Icon_serial_number_NormalBmp", "Icon_OpenSrcSw_normalBmp", "Icon_BT_normalBmp", "Icon_ETAonsecondarymap_disabledBmp"
                                                               }; //for  T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE
   Candera::String CabinASettingMainText[CABINASETTINGSLISTSIZE] =
   {
      Candera::String(TextId_0x1585), Candera::String(TextId_0x1586), Candera::String(TextId_0x1A39),
      Candera::String(TextId_0x00A1),//dummy textid to be replaced after receiving from translation team.
      Candera::String(TextId_0x0260), Candera::String(TextId_0x025B), Candera::String(TextId_0x1A24), Candera::String(TextId_0x10F9), Candera::String(TextId_0x178F), Candera::String(TextId_0x1301), Candera::String(TextId_0x1302),
      Candera::String("GNSS"),//GNSS DUMMY TEXT
      Candera::String(TextId_0x19E9), Candera::String(TextId_0x191F), Candera::String(TextId_0x0E08), Candera::String(TextId_0x1587),
      Candera::String("Switch on bluetooth for audio"),//DUMMY TETX FOR BLUETOOTH
      Candera::String("ETA on secondary map")//DUMMY TEXT FOR ETA
   };

   bool CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[CABINASETTINGSLISTSIZE] = {true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true}; // Main Container
   bool CabinAEnDisb_CMG_CMGA2_Def_CA[CABINASETTINGSLISTSIZE] =          {true, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};	// Default value
   bool CabinAEnDisb_CMGenB_CMGA2disB_CA[CABINASETTINGSLISTSIZE] =       {true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};	// CMGenB_CMGA2disB
   bool CabinAEnDisb_CMGenB_CMGA2enB_CA[CABINASETTINGSLISTSIZE] =        {true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};	// CMGenB_CMGA2enB

   std::string IconNormal_CMG_CMGA2_LatestUpdate_CA[CABINASETTINGSLISTSIZE]  = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_disabledBmp", "Icon_Displaymixedsource_disableBmp", "Icon_BT_disabledBmp", "Icon_displyasetting_normalBmp", "Icon_Language_normalBmp",
                                                                                "Icon_Vehiclesetting_normalBmp", "Icon_Data_normalBmp", "Icon_softversion_normalBmp", "Icon_Softwareupdate_normalBmp", "Icon_Software_update_history_NormalBmp",
                                                                                "Icon_GNSS_NormalBmp", "Icon_Servicemenu_normalBmp", "Icon_Resettouserdefaultsettings_normalBmp", "Icon_serial_number_NormalBmp", "Icon_OpenSrcSw_normalBmp",
                                                                                "Icon_BT_normalBmp", "Icon_ETAonsecondarymap_disabledBmp"
                                                                               };	// mychange
   std::string IconNormal_CMG_CMGA2_Def_CA[CABINASETTINGSLISTSIZE]    		 = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_disabledBmp", "Icon_Displaymixedsource_disableBmp", "Icon_BT_disabledBmp", "Icon_displyasetting_normalBmp", "Icon_Language_normalBmp",
                                                                               "Icon_Vehiclesetting_normalBmp", "Icon_Data_normalBmp", "Icon_softversion_normalBmp", "Icon_Softwareupdate_normalBmp", "Icon_Software_update_history_NormalBmp",
                                                                               "Icon_GNSS_NormalBmp", "Icon_Servicemenu_normalBmp", "Icon_Resettouserdefaultsettings_normalBmp", "Icon_serial_number_NormalBmp", "Icon_OpenSrcSw_normalBmp",
                                                                               "Icon_BT_normalBmp", "Icon_ETAonsecondarymap_disabledBmp"
                                                                           };	// mychange
   std::string IconNormal_CMGenB_CMGA2disB_CA[CABINASETTINGSLISTSIZE] 		 = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_normalBmp", "Icon_Displaymixedsource_disableBmp", "Icon_BT_disabledBmp", "Icon_displyasetting_normalBmp", "Icon_Language_normalBmp",
                                                                               "Icon_Vehiclesetting_normalBmp", "Icon_Data_normalBmp", "Icon_softversion_normalBmp", "Icon_Softwareupdate_normalBmp", "Icon_Software_update_history_NormalBmp",
                                                                               "Icon_GNSS_NormalBmp", "Icon_Servicemenu_normalBmp", "Icon_Resettouserdefaultsettings_normalBmp", "Icon_serial_number_NormalBmp", "Icon_OpenSrcSw_normalBmp",
                                                                               "Icon_BT_normalBmp", "Icon_ETAonsecondarymap_disabledBmp"
                                                                           };
   std::string IconNormal_CMGenB_CMGA2enB_CA[CABINASETTINGSLISTSIZE]  		 = {"Icon_SoundSettings_normalBmp", "Icon_Glasssetting_normalBmp", "Icon_Displaymixedsource_normalBmp", "Icon_BT_disabledBmp", "Icon_displyasetting_normalBmp", "Icon_Language_normalBmp",
                                                                               "Icon_Vehiclesetting_normalBmp", "Icon_Data_normalBmp", "Icon_softversion_normalBmp", "Icon_Softwareupdate_normalBmp", "Icon_Software_update_history_NormalBmp",
                                                                               "Icon_GNSS_NormalBmp", "Icon_Servicemenu_normalBmp", "Icon_Resettouserdefaultsettings_normalBmp", "Icon_serial_number_NormalBmp", "Icon_OpenSrcSw_normalBmp",
                                                                               "Icon_BT_normalBmp", "Icon_ETAonsecondarymap_disabledBmp"
                                                                           };

   bool ctRxdGlassAvailablityStatusCA = CabinInfoSrvClient::poGetInstance()->getglassAvailablityInfoStatusCA();
   bool ctRxdCmgA2AvailablityStatusCA = CabinInfoSrvClient::poGetInstance()->getcmgA2AvailablityInfoStatusCA();
   ETG_TRACE_USR2(("CabinASettingListhandler:: vCreateCabinAListUpdate	 ctRxdGlassAvailablityStatusCA ctRxdCmgA2AvailablityStatusCA==>%d %d ", ctRxdGlassAvailablityStatusCA, ctRxdCmgA2AvailablityStatusCA));

   if (ctRxdGlassAvailablityStatusCA == true)
   {
      UpdateTextColorStatus(&CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[0], &CabinAEnDisb_CMGenB_CMGA2disB_CA[0]);
      UpdateBmpIconStringStatus(&IconNormal_CMG_CMGA2_LatestUpdate_CA[0], &IconNormal_CMGenB_CMGA2disB_CA[0]);
      if (ctRxdCmgA2AvailablityStatusCA == true)
      {
         UpdateTextColorStatus(&CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[0], &CabinAEnDisb_CMGenB_CMGA2enB_CA[0]);
         UpdateBmpIconStringStatus(&IconNormal_CMG_CMGA2_LatestUpdate_CA[0], &IconNormal_CMGenB_CMGA2enB_CA[0]);
      }
   }
   else
   {
      UpdateTextColorStatus(&CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[0], &CabinAEnDisb_CMG_CMGA2_Def_CA[0]);
      UpdateBmpIconStringStatus(&IconNormal_CMG_CMGA2_LatestUpdate_CA[0], &IconNormal_CMG_CMGA2_Def_CA[0]);
   }

   my_cabinA_vec.clear();
   for (int index = 0; index < CABINASETTINGSLISTSIZE; index++)
   {
      IMG_ICON_NORMAL_CA = basePath_CA + IconNormalCA[index];
      IconNormalCA[index] = "";
      IMG_ICON_PRESS_CA = basePath_CA + IconPressedCA[index];
      IconPressedCA[index] = "";
      IMG_ICON_DISBNORMAL_CA = basePath_CA + IconNormalGlassDisbCA[index];
      IconNormalGlassDisbCA[index] = "";
      IMG_ICON_CMG_CMGA2_DISBABLENORMAL_CA = basePath_CA + IconNormal_CMG_CMGA2_LatestUpdate_CA[index];
      IconNormal_CMG_CMGA2_LatestUpdate_CA[index] = " ";
      if (_HMIState == T_SPM_e32_HMI_STATE__SPM_U32_HMISTATE_SHOW_HMI_HOUR_MODE)
      {
         ETG_TRACE_USR3(("CabinASettingListhandler:: vCreateCabinAListUpdate HOUR MODE is true DISABLED CabinAEnDisb_CMG_CMGA2_Def_CA[%d]=%d", index, CabinAEnDisb_CMG_CMGA2_Def_CA[index]));
         my_cabinA_vec.push_back(boost::make_tuple(IMG_ICON_NORMAL_CA, IMG_ICON_PRESS_CA, IMG_ICON_DISBNORMAL_CA, CabinASettingMainText[index], CabinAEnDisb_CMG_CMGA2_Def_CA[index]));
      }
      else
      {
         ETG_TRACE_USR4(("CabinASettingListhandler:: vCreateCabinAListUpdate HOUR MODE is false DISABLED CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[%d]=%d", index, CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[index]));
         my_cabinA_vec.push_back(boost::make_tuple(IMG_ICON_NORMAL_CA, IMG_ICON_PRESS_CA, IMG_ICON_CMG_CMGA2_DISBABLENORMAL_CA, CabinASettingMainText[index], CabinAEnDisb_CMG_CMGA2_LatestUpdate_CA[index]));
      }
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - UpdateTextColorStatus
*DESCRIPTION: 	 Update of Item Text
*PARAMETER:		 bool *CabinAEnDisbTextOldStatus,bool *CabinAEnDisbTextNewStatus
*RETURNVALUE: 	 void
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
void CabinASettingListhandler::UpdateTextColorStatus(bool* CabinAEnDisbTextOldStatus, bool* CabinAEnDisbTextNewStatus)
{
   for (int i = 0; i < CABINASETTINGSLISTSIZE; i++)
   {
      CabinAEnDisbTextOldStatus[i] = CabinAEnDisbTextNewStatus[i];
      ETG_TRACE_USR1(("CabinASettingListhandler:: UpdateTextColorStatus CabinAEnDisbTextOldStatus[%d]   %d CabinAEnDisbTextNewStatus[%d] %d", i, CabinAEnDisbTextOldStatus[i], i, CabinAEnDisbTextNewStatus[i]));
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - UpdateBmpIconStringStatus
*DESCRIPTION: 	 Update of Icon
*PARAMETER:		 std::string  *CabinIconOldBmpImage,std::string  *CabinIconNewBmpImage
*RETURNVALUE: 	 void
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/

void CabinASettingListhandler::UpdateBmpIconStringStatus(std::string*  CabinIconOldBmpImage, std::string*  CabinIconNewBmpImage)
{
   for (int i = 0; i < CABINASETTINGSLISTSIZE; i++)
   {
      CabinIconOldBmpImage[i] = CabinIconNewBmpImage[i];
      ETG_TRACE_USR1(("CabinASettingListhandler:: vCreateCabinAListUpdate CabinIconOldBmpImage  IFFF=%s ", CabinIconOldBmpImage[i].c_str()));
      ETG_TRACE_USR1(("CabinASettingListhandler:: vCreateCabinAListUpdate CabinIconNewBmpImage  IFFF=%s ", CabinIconNewBmpImage[i].c_str()));
   }
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*15.07.2019:Prashant BG

*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider CabinASettingListhandler::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASettingListhandler:: getListDataProvider: list Id = %d", oMsg.GetListId()));
   switch (oMsg.GetListId())
   {
      case LIST_ID_CABIN_A_MAIN_LIST:
         return getMainViewListDataProvider();
      default:
      {
         break;
      }
   }
   return tSharedPtrDataProvider();
}


/**********************************************************************************************
*FUNCTION: 		 CabinASettingListhandler - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*22.04.2022:Prashant BG
*0.1 Initial Revision.
**********************************************************************************************/
tSharedPtrDataProvider CabinASettingListhandler::getMainViewListDataProvider()
{
   ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider is called"));
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_A_MAIN_LIST);
   /*Bug-1455486- condition check to find if A2 Glasses are configured or not. Based on that VideoMix Source Option will be shown/hidden*/
   bool b_CmgA2GlassConfiguredStatus_CA = CabinInfoSrvClient::poGetInstance()->getcmgA2GlassConfiguredInfoStatusCA();
   //b_CmgA2GlassConfiguredStatus_CA = false;
   ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider b_CmgA2GlassConfiguredStatus_CA=%d", b_CmgA2GlassConfiguredStatus_CA));

   for (int index = 0; index < CABINASETTINGSLISTSIZE; index++)
   {
      CabinAsettingMainIconData CabinAitem;

      IMG_CABIN_A_ICON_NORMAL = boost::get<Icon_normal_ca>(my_cabinA_vec[index]);
      IMG_CABIN_A_ICON_TOUCHED = boost::get<Icon_pressed_ca>(my_cabinA_vec[index]);
      IMG_CABIN_A_ICON_DISABLE = boost::get<Icon_disbale_ca>(my_cabinA_vec[index]);  //assign to variable- new
      boost::get<CabinAEnDisb_textimageflag>(my_cabinA_vec[BLUETOOTH_CA]) = _bluetoothstatus;
      boost::get<CabinAEnDisb_textimageflag>(my_cabinA_vec[ETA_ON_SECONDARY_MAP_CA]) = _regionBasedMapoutEnable;

      CABIN_A_MAIN_TEXT = boost::get<CabinAMain_text>(my_cabinA_vec[index]);
      CABIN_A_ENDISB_TEXTIMAGE_FLAG = boost::get<CabinAEnDisb_textimageflag>(my_cabinA_vec[index]);	//assign to variable- new
      ETG_TRACE_USR1(("CabinASettingListhandler:: getMainViewListDataProvider: INDEX =%d, my_cabinA_vec.size() =%d\n", index, my_cabinA_vec.size()));
      CabinAitem.mCabinAMainIconNormalBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_NORMAL.c_str());
      CabinAitem.mCabinAMainIconPressedBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_TOUCHED.c_str());
      CabinAitem.mCabinAMainIconFocusedBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_TOUCHED.c_str());
      CabinAitem.mCabinAMainIconDisbaledBitmap = ImageLoader::getAssetBitmapImage(IMG_CABIN_A_ICON_DISABLE.c_str());//assign to binding- new
      CabinAitem.mCabinAMainNameInfo = CABIN_A_MAIN_TEXT;
      CabinAitem.mCabinAMainActiveTextInfo = CABIN_A_ENDISB_TEXTIMAGE_FLAG; //assign to binding- new

      if (index == VIDEOMIXSOURCE_CA)
      {
         if (b_CmgA2GlassConfiguredStatus_CA == true)
         {
            ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider Videomixsource listitem is enabled"));
            listBuilder.AddItem(
               index, 	//  - identifies the row
               0UL,   //  - column
               DATA_CONTEXT_TEXT_LIST_ITEM)  //  - overwrites the default data context
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem);//1 - Text of the button, should be obtained from Candera.
         }
         else
         {
            ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider Videomixsource listitem is not added"));
         }
      }
      else if ((index == BLUETOOTH_CA) || (index == SOFTWARE_VERSION_CA) || (index == SOFTWARE_UPDATE_CA) || (index == SOFTWARE_UPDATE_HISTORY_CA) || (index == SERVICE_MENU_CA)
               || (index == DISPLAY_CA) || (index == GNSS_CA) || (index == VEHICLE_CONFIGURATION_VERION_CA) || (index == RESET_TO_USER_DEFAULT_SETTINGS_CA))
      {
         if (varianttype == VARIANTTYPE_CC)
         {
            ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider listbuilder Cabin only list items are enabled"));
            listBuilder.AddItem(index, 0UL, DATA_CONTEXT_TEXT_LIST_ITEM)
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem);
         }
      }
      else if (index == ETA_ON_SECONDARY_MAP_CA)
      {
         if (varianttype == VARIANTTYPE_CC)
         {
            ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider listbuilder Cabin only list item ETA_ON_SECONDARY_MAP enabled"));
            listBuilder.AddItem(index, 0UL, "Layer_Checkbox")
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem)
            .AddData(getETAIconSwitchIndex());
         }
      }
      else if (index == SERIAL_NUMBER_CA)
      {
         if (varianttype == VARIANTTYPE_CC)
         {
            ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider listbuilder Cabin only list item ETA_ON_SECONDARY_MAP enabled"));
            listBuilder.AddItem(index, 0UL, "Layer_Text_Preview")
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem)
            .AddData(_serialnumber);
         }
      }
      else if (index == SWITCH_ON_BLUETOOTH_FOR_AUDIO_CA)
      {
         if (varianttype == VARIANTTYPE_CC)
         {
            ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider listbuilder Cabin only list item SWITCH_ON_BLUETOOTH_FOR_AUDIO_CA enabled"));
            listBuilder.AddItem(index, 0UL, "Layer_Checkbox")
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem)
            .AddData(_bluetoothstatus);
         }
      }
      else if (index == LANGUAGE_CA)
      {
         if (varianttype == VARIANTTYPE_CC)
         {
            ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider listbuilder Cabin only list item LANGUAGE_CA enabled"));
            listBuilder.AddItem(index, 0UL, "Layer_Text_Preview_Touchable")
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem)
            .AddData(_currentSelectedLanguage);
         }
      }
      else if (index == DATA_CARRIER_VERSION_CA)
      {
         if (varianttype == VARIANTTYPE_CC)
         {
            ETG_TRACE_COMP(("CabinASettingListhandler::getMainViewListDataProvider listbuilder Cabin only list item DATA_CARRIER_VERSION_CA enabled"));
            listBuilder.AddItem(index, 0UL, "Layer_Text_Preview")
            .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem)
            .AddData(_dataCarrierVersion);
         }
      }
      else
      {
         ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider listbuilder - List items required for both CMC and Cabin only variants"));
         listBuilder.AddItem(index, 0UL, DATA_CONTEXT_TEXT_LIST_ITEM)
         .AddDataBindingUpdater<CabinAsettingMainIconDataBindingSource>(CabinAitem);
      }
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconNormalBitmap1= %s \n", CabinAitem.mCabinAMainIconNormalBitmap));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconPressedBitmap1= %s \n", CabinAitem.mCabinAMainIconPressedBitmap));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconFocusedBitmap1= %s \n", CabinAitem.mCabinAMainIconFocusedBitmap));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainNameInfo1= %s \n", (CabinAitem.mCabinAMainNameInfo).GetCString()));
      ETG_TRACE_USR1(("CabinASettingListhandler::getMainViewListDataProvider CabinAitem.mCabinAMainIconDisbaledBitmap= %s \n", CabinAitem.mCabinAMainIconDisbaledBitmap));
   }
   listcreated = true;
   return listBuilder.CreateDataProvider();
}


bool CabinASettingListhandler::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool retval = false;
   bool rowIdx = (unsigned int)oMsg.GetHdl();
   ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg rowIdx=%d", rowIdx));
   ListDataProviderBuilder modifiedListItems(LIST_ID_CABIN_A_MAIN_LIST);
   if (oMsg.GetListId() == LIST_ID_CABIN_A_MAIN_LIST)
   {
      if (oMsg.GetReaction() == enRelease)
      {
         switch (oMsg.GetHdl())
         {
            case BLUETOOTH_CA:
            {
               //currently the destination context id is set as home - to be changed to phone context.
               ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();
               _applicationSwitchClientComponent->requestContextSwitchApplication(CABIN_A_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS,
                     APPID_APPHMI_PHONE, enActivityIDs__eActivityID_PHONE_DEVICE_SELECTION);
               retval = true;
            }
            break;
            case SOFTWARE_VERSION_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg SOFTWARE_VERSION_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(SoftwareVersionCISMsg)());
               retval = true;
            }
            break;
            case SOFTWARE_UPDATE_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg SOFTWARE_UPDATE_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(StartSoftwareUpdatePressMsg)());
               retval = true;
            }
            break;
            case SOFTWARE_UPDATE_HISTORY_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg SOFTWARE_UPDATE_HISTORY_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(StartSoftwareUpdateHistoryMsg)());
               retval = true;
            }
            break;
            case SERVICE_MENU_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg SERVICE_MENU_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(OEMSettingMsg)());
               retval = true;
            }
            break;
            case ETA_ON_SECONDARY_MAP_CA:
            {
               _etaonsecondarymapstatus = !_etaonsecondarymapstatus;
               if (SystemDataPoolConfig::getInstance() != NULL)
               {
                  SystemDataPoolConfig::getInstance()-> setETAStatus(_etaonsecondarymapstatus);
               }
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg ETA_ON_SECONDARY_MAP_CA, _etaonsecondarymapstatus=%d", _etaonsecondarymapstatus));
               if (CabinInfoSrvClient::poGetInstance() != NULL)
               {
                  CabinInfoSrvClient::poGetInstance()->setETAAvailableStatus(_etaonsecondarymapstatus);
               }
               if (listcreated == true)
               {
                  ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
               }
               retval = true;
            }
            break;
            case GNSS_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg GNSS_CA"));
               ApplicationSwitchClientComponent* _applicationSwitchClientComponent = ApplicationSwitchClientComponent::poGetInstance();
               _applicationSwitchClientComponent->requestContextSwitchApplication(CABIN_A_REGION, APPID_APPHMI_SYSTEM, enActivityIDs__eActivityID_SETTINGS,
                     APPID_APPHMI_NAVIGATION, enActivityIDs__eActivityID_NAVI_GNSS);
               retval = true;
            }
            break;
            case RESET_TO_USER_DEFAULT_SETTINGS_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg RESET_TO_USER_DEFAULT_SETTINGS_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(ResetFactorySettingsMsg)());
               retval = true;
            }
            break;
            case VEHICLE_CONFIGURATION_VERION_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg VEHICLE_CONFIGURATION_VERION_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(VehicleConfigVersionMsg)());
               retval = true;
            }
            break;
            case SWITCH_ON_BLUETOOTH_FOR_AUDIO_CA:
            {
               _bluetoothstatus = !_bluetoothstatus;
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg SWITCH_ON_BLUETOOTH_FOR_AUDIO_CA, _bluetoothstatus=%d", _bluetoothstatus));
               if (ServiceBT::poGetInstance() != NULL)
               {
                  ServiceBT::poGetInstance()->SetBluetoothState(_bluetoothstatus);
               }
               retval = true;
            }
            break;
            case LANGUAGE_CA:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg LANGUAGE_CA"));
               POST_MSG(COURIER_MESSAGE_NEW(LanguageSettingsMsg)());
            }
            break;
            default:
            {
               ETG_TRACE_USR1(("CabinASettingListhandler::ButtonListItemUpdMsg default condition"));
            }
            break;
         }
      }
   }
   return retval;
}


bool CabinASettingListhandler::onCourierMessage(const PluginEndStationListUpdateMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASettingListhandler::PluginUpdateRespMsg Entered"));
   const boost::shared_ptr<EventDataUtility>& dataUtility = oMsg.GetEndStationListData();
   if (NULL != dataUtility.get())
   {
      const std::vector<EventDataItem*>& dataItems = dataUtility->getData();
      ETG_TRACE_USR1(("CabinASettingListhandler:onCourierMessage:PluginEndStationListUpdateMsg dataItems.size() %d", dataItems.size()));
      if (dataItems.size() > 0)
      {
         _currentglassavalStatus = false;
         for (int index = 0; index < dataItems.size(); index++)
         {
            EventDataItem* eventDataItem = dataItems.at(index);
            if (NULL != eventDataItem)
            {
               EventDataItem::Data eventDataVal = eventDataItem->getData();
               std::string strVal = eventDataVal._value._stringValue->c_str();
               ETG_TRACE_USR4(("CabinASettingListhandler::PluginEndStationListUpdateMsg: strVal:  %s", strVal.c_str()));
               if (strVal == "CMG")
               {
                  // _currentglassavalStatus = true;
                  //App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS1_SINK_ID);
                  //App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS2_SINK_ID);
               }
            }
         }
         // vCreateCabinAListUpdate();
      }
   }

   if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
   {
      ETG_TRACE_USR1(("CabinASettingListhandler::PluginEndStationListUpdateMsg: LIST_ID_CABIN_A_MAIN_LIST list is Available"));
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
   return true;
}


void CabinASettingListhandler::enableDisableGlass(bool rxdCurrentglassavalStatus)
{
   /*	_currentglassavalStatus = rxdCurrentglassavalStatus;

    	ETG_TRACE_USR1(("CabinASettingListhandler::enableDisableGlass: _currentglassavalStatus =%d",_currentglassavalStatus));
    	if(rxdCurrentglassavalStatus==true)
    	{
    		App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS1_SINK_ID);
   	App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_A_MEDIAGLASS2_SINK_ID);
   	//App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_B_MEDIAGLASS1_SINK_ID);
   	//App::Core::CabinAGlassSettingListhandler::poGetInstance()->startInactivityTimerONStartup(CABIN_B_MEDIAGLASS2_SINK_ID);
    	}
    	vCreateCabinAListUpdate();

    if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
    {
       ETG_TRACE_USR1(("CabinASettingListhandler::enableDisableGlass: LIST_ID_CABIN_A_MAIN_LIST list AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"));
       ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
    } */
}


bool CabinASettingListhandler::onCourierMessage(const ApplicationStateUpdMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASettingListhandler::ApplicationStateUpdMsg: applicationState=%d", oMsg.GetState()));
   if (oMsg.GetState() == hmibase::IN_FOREGROUND)
   {
      applicationState = true;
   }
   else
   {
      applicationState = false;
   }
   return false;
}


void CabinASettingListhandler::getActiveView(Candera::String ActiveView)
{
   _ActiveView = ActiveView;
   ETG_TRACE_USR1(("CabinASettingListhandler::getActiveView: _ActiveView=%s", _ActiveView.GetCString()));
}


void CabinASettingListhandler::UpdateVideoMixVisibilitystatus(uint32 systemCategory, uint8 systemStatus)
{
   ETG_TRACE_USR1(("CabinASettingListhandler::UpdateVideoMixVisibilitystatus:systemCategory =%d, systemStatus =%d", systemCategory, systemStatus));
}


//below code is to get the status
bool CabinASettingListhandler::getglassconnectedstatus()
{
   ETG_TRACE_COMP(("CabinASettingListhandler::getglassconnectedstatus _currentglassavalStatus= %d", _currentglassavalStatus));
   return _currentglassavalStatus;
}


void CabinASettingListhandler::UpdateHMIState2HMI(const uint8 HMIState)
{
   _HMIState = HMIState;
   ETG_TRACE_USR1(("CabinASettingListhandler::UpdateHMIState2HMI _HMIState= %d", _HMIState));
   vCreateCabinAListUpdate();
   if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
   {
      ETG_TRACE_USR1(("CabinASettingListhandler::UpdateCabinASettingListOnCmgChange: LIST_ID_CABIN_A_MAIN_LIST list is Available"));
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
}


void CabinASettingListhandler::UpdateCabinASettingListOnCmgChange()
{
   ETG_TRACE_USR1(("CabinASettingListhandler::UpdateCabinASettingListOnCmgChange vCreateCabinAListUpdate()"));
   vCreateCabinAListUpdate();
   if ((applicationState == true) && (_ActiveView == "AppHmi_System#SysSettingsScenes#SO_SysSettings_CA"))
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
}


void CabinASettingListhandler::setBTstatus(bool BTstatus)
{
   ETG_TRACE_USR1(("CabinASettingListhandler::setBTstatus BTstatus=%d", BTstatus));
   _bluetoothstatus = BTstatus;
   if (listcreated == true)
   {
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_MAIN_LIST);
   }
}


void CabinASettingListhandler::setSelectedLanguage(std::string currentSelectedLanguage)
{
   ETG_TRACE_USR1(("CabinASettingListhandler::setSelectedLanguage currentSelectedLanguage=%s", currentSelectedLanguage.c_str()));
   _currentSelectedLanguage = Candera::String(currentSelectedLanguage.c_str());
}


void CabinASettingListhandler::setDatacarrierVersion(std::string dataCarrierVersion)
{
   ETG_TRACE_USR1(("CabinASettingListhandler::setDatacarrierVersion dataCarrierVersion=%s", dataCarrierVersion.c_str()));
   _dataCarrierVersion = Candera::String(dataCarrierVersion.c_str());
}


uint8 CabinASettingListhandler::getETAIconSwitchIndex()
{
   ETG_TRACE_USR1(("CabinASettingListhandler::getETAIconSwitchIndex _regionBasedMapoutEnable=%d, _etaonsecondarymapstatus=%d", _regionBasedMapoutEnable, _etaonsecondarymapstatus));
   uint8 switchIndex;
   switchIndex = (_regionBasedMapoutEnable == true) ? _etaonsecondarymapstatus : ((_etaonsecondarymapstatus == true) ? CHECKBOX_CHECKED_GREYEDOUT : CHECKBOX_UNCHECKED_GREYEDOUT);
   return switchIndex;
}


#endif
};


};
