/**************************************************************************************
* @file         : CabinASwivelCalibration.cpp
* @author       : Sushmita Dikshit
* @addtogroup   : AppHmi_System
* @brief        : Updated changes for displaying date format.
* @copyright    : (C) 2019 Robert Bosch GmbH
*                 (C) 2019 Robert Bosch Engineering and Business Solutions Limited
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/
#include "gui_std_if.h"
#include <string>
//#include "util/StrUtf8.h"
#include "App/Core/ClientHandler/ClockSrvClient/ClockSrvClient.h"

#include "CabinASwivelCalibration.h"
#include <cstdlib>
#include "hmi_trace_if.h"
#include "AppHmi_SystemStateMachine.h"

#include "MediaGlass.h"


#include "PluginConstants.h"  // Control block names
//#include "PluginDataType.h"   // Control block index values and stEntityIDMap definition
#include "AudioDefines.h"     // Sink ID index

#define CTRLBLOCK_NAME_SETTINGS_CABINAGLASSES  "CabinAGlasses"
#define CTRLBLOCK_NAME_SETTINGS_SWIVELCALIBRATION "SwivelCalibration"

#define DP_S_IMPORT_INTERFACE_KDS_FI
#include "dp_kds_if.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::Core::CabinASwivelCalibration::
#include "trcGenProj/Header/CabinASwivelCalibration.cpp.trc.h"
#endif

namespace App {
namespace Core {

CabinASwivelCalibration* CabinASwivelCalibration::m_poSwivelCalibration = NULL;


//static const char* const DATA_CONTEXT_TEXT_BUTTON_LIST_ITEM = "TextButton_ListItem";

/************************************************************************
*FUNCTION: 		 CabinASwivelCalibration - Constructor
*DESCRIPTION: 	 default constructor of the System setting Listhadler will be created
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

CabinASwivelCalibration::CabinASwivelCalibration()
{
   ETG_TRACE_COMP(("CabinASwivelCalibration:: Constructor is called"));
   ListRegistry::s_getInstance().addListImplementation(LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST, this);
   IPAddressVec.clear();
   PreviousrowIdx = 100;
   CurrentrowIdx = 99;
   Glasssize = 0;
   listcreated = false;
}


/************************************************************************
*FUNCTION: 		 CabinASwivelCalibration - Destructor
*DESCRIPTION: 	 Allocated resources such as memory will be released here
*PARAMETER:		 None
*RETURNVALUE: 	 None
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
************************************************************************/

CabinASwivelCalibration::~CabinASwivelCalibration()
{
   ETG_TRACE_COMP(("CabinASwivelCalibration:: Destructor is called"));
   ListRegistry::s_getInstance().removeListImplementation(LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST);
}


/**********************************************************************************************
*FUNCTION: 		 CabinASwivelCalibration - getListDataProvider
*DESCRIPTION: 	 Creates a list data provider which would contain unique list id
*PARAMETER:		 oMsg - Courier message received
*RETURNVALUE: 	 tSharedPtrDataProvider()
*
*HISTORY:
*27.3.2018:Sheena Mathew

*0.1 Initial Revision.
**********************************************************************************************/

tSharedPtrDataProvider CabinASwivelCalibration::getListDataProvider(const ListDateProviderReqMsg& oMsg)
{
   ETG_TRACE_COMP(("CabinASwivelCalibration:: getListDataProvider: List Id = %d", oMsg.GetListId()));
   tSharedPtrDataProvider dataProvider = tSharedPtrDataProvider();
   switch (oMsg.GetListId())
   {
      case LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST: //Settings Time Zone Clock List items are requested
         return getSwivelCalibListDataProvider();
         break;
   }
   return tSharedPtrDataProvider();
}


tSharedPtrDataProvider CabinASwivelCalibration::getSwivelCalibListDataProvider()
{
   ListDataProviderBuilder listBuilder(LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST);
   tSharedPtrDataProvider dataProvider = listBuilder.CreateDataProvider();
   for (uint8 logval = 0; logval < IPAddressVec.size(); logval++)
   {
      ETG_TRACE_USR1(("CabinASwivelCalibration:: getSwivelCalibListDataProvider IPAddressVec.size() = %d", IPAddressVec.size()));
      if (CurrentrowIdx == logval)
      {
         ETG_TRACE_USR2(("CabinASwivelCalibration:: getSwivelCalibListDataProvider: radiobutton enabled entry%d", logval));
         listBuilder.AddItem(logval, 0UL, "Text_IPAddress").AddData(IPAddressVec[logval].c_str()).AddData(true);
      }
      else
      {
         ETG_TRACE_USR2(("CabinASwivelCalibration:: getSwivelCalibListDataProvider: radiobutton disabled entry %d", logval));
         listBuilder.AddItem(logval, 0UL, "Text_IPAddress").AddData(IPAddressVec[logval].c_str()).AddData(false);
      }
   }
   dataProvider = listBuilder.CreateDataProvider();
   return dataProvider;
}


bool CabinASwivelCalibration::onCourierMessage(const ButtonListItemUpdMsg& oMsg)
{
   bool liststatus = false ;
   if (oMsg.GetListId() == LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST)
   {
      static bool calibrationflag = false;
      CurrentrowIdx = oMsg.GetHdl();
      ETG_TRACE_USR1(("CabinASwivelCalibration:: ButtonListItemUpdMsg: send selected option to plugin PreviousrowIdx = %d, CurrentrowIdx = %d, IPAddressVec.size() = %d, calibrationflag = %d", PreviousrowIdx, CurrentrowIdx, IPAddressVec.size(), calibrationflag));//check if placing of IPAddressVec.size is fine
      if (PreviousrowIdx != CurrentrowIdx)
      {
         PreviousrowIdx = CurrentrowIdx;
         POST_MSG((COURIER_MESSAGE_NEW(::PopupReqMsg)(hmibase::popups::Show, Courier::ViewId("AppHmi_System#SoftwareDownload#Pfo_SwivelCalibration"))));
      }
      const boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
      uint8 sinkID = 1;
      //std::string IPAddress = "192.168.0.20";
      if (NULL != pluginData.get())
      {
         if ((!IPAddressVec.empty()) && (IPAddressVec.size() >= CurrentrowIdx))
         {
            pluginData->addEventData((uint8)(CABIN_A_MEDIAGLASS1_SINK_ID));
            pluginData->addEventData(IPAddressVec[CurrentrowIdx]);
            ETG_TRACE_USR3(("CabinASwivelCalibration:: ButtonListItemUpdMsg:Data sent to plugin is sinkID = %d , selected_option = %s", sinkID, IPAddressVec[CurrentrowIdx].c_str()));
         }
         else
         {
            ETG_TRACE_USR4(("CabinASwivelCalibration::vector is empty "));
         }
         if (calibrationflag == false)
         {
            POST_MSG((COURIER_MESSAGE_NEW(PluginCommandReqMsg)(PLUGIN_NAME_SETTINGS, CTRLBLOCK_NAME_SETTINGS_SWIVELCALIBRATION, pluginData)));
            calibrationflag = true;
         }
         else
         {
            calibrationflag = false;
         }
      }
      ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST);
      liststatus = true;
   }
   return liststatus;
}


bool CabinASwivelCalibration::onCourierMessage(const SendPluginReq& oMsg)
{
   ETG_TRACE_COMP(("CabinASwivelCalibration::SendPluginReq"));
   uint8 dummy = 0;
   boost::shared_ptr<EventDataUtility> pluginData(EventDataUtility::newEventDataUtility());
   if (NULL != pluginData.get())
   {
      pluginData->addEventData(dummy);
      POST_MSG((COURIER_MESSAGE_NEW(PluginCommandReqMsg)(PLUGIN_NAME_SETTINGS, CTRLBLOCK_NAME_SETTINGS_CABINAGLASSES, pluginData)));
      ETG_TRACE_USR1(("CabinASwivelCalibration::SendPluginReq: PluginCommandReqMsg sent"));
   }
   return true;
}


bool CabinASwivelCalibration::onCourierMessage(const PluginUpdateRespMsg& oMsg)
{
   IPAddressVec.clear();
   const Candera::String& pluginName = oMsg.GetPluginName();
   ETG_TRACE_USR1(("CabinASwivelCalibration::PluginUpdateRespMsg: pluginName = %s", pluginName.GetCString()));
   if (0 == strcmp(PLUGIN_NAME_SETTINGS, pluginName.GetCString()))
   {
      const boost::shared_ptr<EventDataUtility>& dataUtility = oMsg.GetPluginData();
      if (NULL != dataUtility.get())
      {
         const std::vector<EventDataItem*>& dataItems = dataUtility->getData();
         ETG_TRACE_USR3(("CabinASwivelCalibration::PluginUpdateRespMsg: dataUtility.get() NULL check pass, dataItems.size = %d", dataItems.size()));
         if (dataItems.size() > 1) //why this check?
         {
            EventDataItem* eventSinkID = dataItems.at(0);
            EventDataItem* eventGlassesSize = dataItems.at(1);
            if (NULL != eventGlassesSize)
            {
               const EventDataItem::Data& eventGlassesSizeData = eventGlassesSize->getData();
               Glasssize = eventGlassesSizeData._value._uint16Value;
               ETG_TRACE_USR4(("CabinASwivelCalibration::PluginUpdateRespMsg: eventGlassesSize NULL check pass, Glasssize = %d", Glasssize));
               for (int index = 2; index < Glasssize + 2; index++) //index starts at 2, as 0 and 1 are sinkid and glassessize respectively
               {
                  EventDataItem* eventIPAddress =  dataItems.at(index);
                  if (NULL != eventIPAddress)
                  {
                     ETG_TRACE_USR4(("CabinASwivelCalibration::PluginUpdateRespMsg: index=%d, eventIPAddress NULL check pass", index));
                     const EventDataItem::Data& eventIPAddressData = eventIPAddress->getData();
                     if (EventDataItem::STRING == eventIPAddressData._type)
                     {
                        std::string IPAddressString = eventIPAddressData._value._stringValue->c_str();
                        ETG_TRACE_USR4(("CabinASwivelCalibration::PluginUpdateRespMsg: IPAddressString = %s", eventIPAddressData._value._stringValue->c_str()));
                        IPAddressVec.push_back(IPAddressString);
                     }
                  }
               }
            }
         }
      }
   }
   ListRegistry::s_getInstance().updateList(LIST_ID_CABIN_A_GAMMA_SWIVEL_CALIBRATION_LIST);
   return true;
}


}
}
