/**************************************************************************************
* @file         : AudioSettingListHandler.h
* @author       : Sheena Mathew
* @addtogroup   : AppHmi_SystemSetting
* @brief        :
* @copyright    : (c) 2018-2019 Robert Bosch Car Multimedia GmbH
*                 The reproduction, distribution and utilization of this file as
*                 well as the communication of its contents to others without express
*                 authorization is prohibited. Offenders will be held liable for the
*                 payment of damages. All rights reserved in the event of the grant
*                 of a patent, utility model or design.
**************************************************************************************/

#ifndef AUDIO_SETTINGS_LIST_HANDLER_H
#define AUDIO_SETTINGS_LIST_HANDLER_H


#include "AppHmi_SystemMessages.h"
#include "AppHmi_SystemStateMachine.h"
#include "AppHmi_SystemStateMachineData.h"
//#include "AppHmi_SystemTypes.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"

#include "CgiExtensions/DataBindingItem.hpp"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include "CgiExtensions/CourierMessageMapper.h"
//#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "System_Types.h"
#include <vector>
#include <string>       // std::string
#include <iostream>     // std::cout
#include <sstream>      // std::stringstrea
#include <map>

#define VARIANT_S_FTR_ENABLE_COACH_FEATURE
#define VARIANT_S_FTR_ENABLE_SPEED_LIMIT

#define PLUS_SIGN   1
#define MINUS_SIGN -1
#define COCKPIT_SINK 1
using namespace std;
namespace App {
namespace Core {
class AudioSettingListHandler :  public ListImplementation
{
   public:

      virtual ~AudioSettingListHandler();
      AudioSettingListHandler(const AudioSettingListHandler&);
      AudioSettingListHandler& operator =(const AudioSettingListHandler&);
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(ButtonListItemUpdMsg)
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      ON_COURIER_MESSAGE(ChangeAuxlevelvalueReqMsg)
#endif
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()
      //Singleton class implementation

      static AudioSettingListHandler* poGetInstance()
      {
         if (NULL == m_poaudioSettingListHandler)
         {
            m_poaudioSettingListHandler = new AudioSettingListHandler();
         }
         return m_poaudioSettingListHandler;
      }
      void setMainSinkSoundProperty(const uint16& mtypeproperty, const uint32& mvalue);
      void vPerformMainSinkSoundPropertyBassUpdate(const uint16& sinkId, const uint16& soundproperty, const uint16& value);
      // void vPerformMainSinkSoundPropertyBassUpdate(uint16 sinkId,  uint16 soundproperty,  int value);
      //void onUpdateMenu(int rowid, int* bassval);

      void onUpdateMenu(int updatedval[]);
      void printVector(const std::vector<int>& n);
      std::vector<int> vecOfValues;
      uint8 u8ExtAmpConfig;
      uint8 u8CarModelType;
#ifdef VARIANT_S_FTR_ENABLE_AUX_SUPPORT
      virtual bool onCourierMessage(const ChangeAuxlevelvalueReqMsg& oMsg);
      tSharedPtrDataProvider GetCombo1ListDataProvider(::Courier::UInt32);
      unsigned int getDpExtAmp();//newly added
      unsigned int getDpCarModel();//newly added
#endif
   private:
      AudioSettingListHandler();
      static AudioSettingListHandler* m_poaudioSettingListHandler;
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& oMsg);
      tSharedPtrDataProvider getMainViewListDataProvider();

      int32_t updatedval;
      int32_t MaxvalueDef;
      int32_t MinvalueDef;
      unsigned int rowIdx;

      int basstype, trebbletype, balancetype, fadertype, minvoltype, maxvoltype, primodmixvoltype;
      uint16 basstypesign;

      bool listcreated;

      map<int, int16> m_ListAudSpectoServAudSpec;
      map<int, int16> m_ListtypetoAudSpecVolUpd;
      map<int, int16> m_ListtypetoAudSpecVolUpd4mCH;

      int audiovalues[6];

      int32_t listUpdateNeeded;
      uint16 m_propertytype ;
      string m_bass;
      bool onCourierMessage(const ButtonListItemUpdMsg& oMsg);
      enAuxlevelOption _currentAuxlevelOption;
      Candera::String _currentAuxlevelOptionStr;

      DataBindingItem<BasslevelUpdateItemDataBindingSource> _basslevelUpdateItem;
      DataBindingItem<TreblelevelUpdateItemDataBindingSource> _treblelevelUpdateItem;
      DataBindingItem<BalancelevelUpdateItemDataBindingSource> _balancelevelUpdateItem;

      void onCreateMaplistUpdate();

      void vAudSpecBassincrementdecrementvalue(int rxbasstype, int* Bass_vol_val, int feature);
      void vAudSpecTrebbleincrementdecrementvalue(int rxtrebbletype, int* Trebble_vol_val, int feature);

      void vAudSpecBalanceincrementdecrementvalue(int rxbalancetype, int* Balance_vol_val, int feature);
      void vAudSpecFaderincrementdecrementvalue(int rxfadertype, int* Fader_vol_val, int feature);
      void vAudSpecMinVolincrementdecrementvalue(int rxminvoltype, int* Min_vol_val, int feature);
      void vAudSpecMaxVolincrementdecrementvalue(int rxmaxvoltype, int* Max_vol_val, int feature);
      void vAudSpecPriModMixVolincrementdecrementvalue(int rxprimodmixvoltype, int16* PriModMix_vol_val, int feature);
      void CloseAuxdropdown();

      uint32 CheckBassButtonType(unsigned int RxdBassColumnBtn);
      uint32 CheckTrebbleButtonType(unsigned int RxdTrebbleColumnBtn);
      uint32 CheckBalanceButtonType(unsigned int RxdBalanceColumnBtn);
      uint32 CheckFaderButtonType(unsigned int RxdFaderColumnBtn);
      uint32 CheckMinVolButtonType(unsigned int RxdMinVolColumnBtn);
      uint32 CheckMaxVolButtonType(unsigned int RxdMaxVolColumnBtn);
      uint32 CheckPriModMixVolButtonType(unsigned int RxdPriModMixVolColumnBtn);
      unsigned long index, AudioIndex;
};


}
}


#endif // SYSTEM_SETTINGS_LIST_HANDLER_H
