/* ***************************************************************************************
* FILE:          AudioEqlPrstRBtn.h
* SW-COMPONENT:  Audio Setting Equilizer Preset Radio Button
* DESCRIPTION:  AudioEqlPrstRBtn.h is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
*COPYRIGHT:  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef AUDIOEQLPRSTRBTN_H
#define AUDIOEQLPRSTRBTN_H
#include "AppHmi_SystemStateMachine.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "AppHmi_SystemMessages.h"
#include "CourierTunnelService/CourierMessageReceiverStub.h"
#include <string>

#define EqlProperty 		14
#define FlatEqlValue  		0
#define PopEqlValue 		3
#define RockEqlValue 		2
#define HiphopEqlValue 		5
#define ClassicEqlValue 	4
#define JazzEqlValue 		1

namespace App {
namespace Core {

class AudioEquilizerPresetRBtn
{
   private:
      AudioEquilizerPresetRBtn();

   public:

      static AudioEquilizerPresetRBtn* m_poAudioEquilizerPresetRBtn;
      static AudioEquilizerPresetRBtn* poGetInstance();

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SYSTEM_COURIER_PAYLOAD_MODEL_COMP)

      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(EqlPrstFlat)
      ON_COURIER_MESSAGE(EqlPrstPop)
      ON_COURIER_MESSAGE(EqlPrstRock)
      ON_COURIER_MESSAGE(EqlPrstHiphop)
      ON_COURIER_MESSAGE(EqlPrstClassic)
      ON_COURIER_MESSAGE(EqlPrstJazz)
      COURIER_MSG_MAP_END()
      void UpdateEqlPrstTglStatus(int SoundType);
      //  void UpdateEqlPrstClientIf(int EqlPrstClientUpdVal);
      virtual ~AudioEquilizerPresetRBtn();
      virtual bool onCourierMessage(const EqlPrstFlat& oMsg);
      virtual bool onCourierMessage(const EqlPrstPop& oMsg);
      virtual bool onCourierMessage(const EqlPrstRock& oMsg);
      virtual bool onCourierMessage(const EqlPrstHiphop& oMsg);
      virtual bool onCourierMessage(const EqlPrstClassic& oMsg);
      virtual bool onCourierMessage(const EqlPrstJazz& oMsg);
      bool onCourierMessage(const Courier::StartupMsg& oMsg);

      bool Init();

      DataBindingItem<SpeedDependentVolumeControlDataBindingSource> oSpeedDependentVolumeControl;
      DataBindingItem<SOASEquilizerPresetDataBindingSource> oSOASEquilizerPreset;
};


}
}


#endif // _HMI_MODEL_COMPONENT_H
