/* ***************************************************************************************
* FILE:          AudioEqlPrstRBtn.cpp
* SW-COMPONENT:  Audio Setting Equilizer Preset Radio Button
* DESCRIPTION:  AudioEqlPrstRBtn.cpp is part of Audio Setting reference/demo/test applications
* Author 	: PGA5COB (Prashant BG)
*  COPYRIGHT:  (c) 2018-2018 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#include "gui_std_if.h"

//#include "AppUtils/StrUtf8.h"
#include "AppHmi_SystemStateMachine.h"
#include "App/Core/ClientHandler/Audio/AudioServiceClient.h"
#include "AudioEqlPrstRBtn.h"
#include "hmi_trace_if.h"
#include<iostream>
#include <string>
#include <cstdlib>

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SYSTEM_HALL
#define ETG_I_TRACE_CHANNEL TR_TTFIS_APPHMI_SYSTEM
#define ETG_I_TTFIS_CMD_PREFIX            "APPHMI_SYSTEM_"
#define ETG_I_FILE_PREFIX                 App::DataModel::AudioEqlPrstRBtn
#include "trcGenProj/Header/AudioEqlPrstRBtn.cpp.trc.h"
#endif

using namespace App::Core;
using namespace std;


AudioEquilizerPresetRBtn* AudioEquilizerPresetRBtn::m_poAudioEquilizerPresetRBtn = NULL;
AudioEquilizerPresetRBtn::AudioEquilizerPresetRBtn()
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn:: Constructor"));
}


AudioEquilizerPresetRBtn* AudioEquilizerPresetRBtn::poGetInstance()
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::poGetInstance"));
   if (NULL == m_poAudioEquilizerPresetRBtn)
   {
      m_poAudioEquilizerPresetRBtn = new AudioEquilizerPresetRBtn();
   }
   return m_poAudioEquilizerPresetRBtn;
}


AudioEquilizerPresetRBtn::~AudioEquilizerPresetRBtn()
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::Destructor"));
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const EqlPrstFlat& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::EqlPrstFlat"));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, EqlProperty, FlatEqlValue);
   return true;
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const EqlPrstPop& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::EqlPrstPop"));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, EqlProperty, PopEqlValue);
   return true;
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const EqlPrstRock& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::EqlPrstRock"));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, EqlProperty, RockEqlValue);
   return true;
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const EqlPrstHiphop& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::EqlPrstHiphop"));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, EqlProperty, HiphopEqlValue);
   return true;
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const EqlPrstClassic& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::EqlPrstClassic"));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, EqlProperty, ClassicEqlValue);
   return true;
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const EqlPrstJazz& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::EqlPrstJazz"));
   AudioServiceClient::poGetInstance()->performMainSinkSoundPropertyUserChange(COCKPIT_SINK, EqlProperty, JazzEqlValue);
   return true;
}


void AudioEquilizerPresetRBtn :: UpdateEqlPrstTglStatus(int SoundType)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn::UpdateEqlPrstTglStatus: SoundType = %d", SoundType));
   (*oSOASEquilizerPreset).mToggleEqlPrstFLAT = false;
   (*oSOASEquilizerPreset).mToggleEqlPrstPOP = false;
   (*oSOASEquilizerPreset).mToggleEqlPrstROCK = false;
   (*oSOASEquilizerPreset).mToggleEqlPrstHIPHOP = false;
   (*oSOASEquilizerPreset).mToggleEqlPrstCLASSIC = false;
   (*oSOASEquilizerPreset).mToggleEqlPrstJAZZ = false;

   (*oSOASEquilizerPreset).mColorEqlPrstFLAT = false;
   (*oSOASEquilizerPreset).mColorEqlPrstPOP = false;
   (*oSOASEquilizerPreset).mColorEqlPrstROCK = false;
   (*oSOASEquilizerPreset).mColorEqlPrstHIPHOP = false;
   (*oSOASEquilizerPreset).mColorEqlPrstCLASSIC = false;
   (*oSOASEquilizerPreset).mColorEqlPrstJAZZ = false;

   if (SoundType == FlatEqlValue)
   {
      (*oSOASEquilizerPreset).mToggleEqlPrstFLAT = true;
      (*oSOASEquilizerPreset).mColorEqlPrstFLAT = true;
   }
   else if (SoundType == PopEqlValue)
   {
      (*oSOASEquilizerPreset).mToggleEqlPrstPOP = true;
      (*oSOASEquilizerPreset).mColorEqlPrstPOP = true;
   }
   else if (SoundType == RockEqlValue)
   {
      (*oSOASEquilizerPreset).mToggleEqlPrstROCK = true;
      (*oSOASEquilizerPreset).mColorEqlPrstROCK = true;
   }
   else if (SoundType == HiphopEqlValue)
   {
      (*oSOASEquilizerPreset).mToggleEqlPrstHIPHOP = true;
      (*oSOASEquilizerPreset).mColorEqlPrstHIPHOP = true;
   }
   else if (SoundType == ClassicEqlValue)
   {
      (*oSOASEquilizerPreset).mToggleEqlPrstCLASSIC = true;
      (*oSOASEquilizerPreset).mColorEqlPrstCLASSIC = true;
   }
   else if (SoundType == JazzEqlValue)
   {
      (*oSOASEquilizerPreset).mToggleEqlPrstJAZZ = true;
      (*oSOASEquilizerPreset).mColorEqlPrstJAZZ = true;
   }
   else
   {
      /*Do Nothing*/
   }
   oSOASEquilizerPreset.MarkAllItemsModified();
   oSOASEquilizerPreset.SendUpdate(true);
}


bool AudioEquilizerPresetRBtn::onCourierMessage(const Courier::StartupMsg& /* oMsg */)
{
   ETG_TRACE_COMP(("AudioEquilizerPresetRBtn:StartupMsg"));
   return true;
}
