/**
 * @file        :  CGIAppViewFactory.cpp
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  SXM HALL class which contains all the necessary business logic required for CGI App
 * @copyright   :  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "gui_std_if.h"
#include "CGIAppViewFactory.h"
#include "AppHmi_SxmMessages.h"
// the views
#include "CGIAppViewController_Sxm.h"
//#include "CgiExtensions/View/ViewScene2D.h"
/*-------------------------------------*/
/**
* RenderTargetInvalidatingViewScene is derived from ViewSceneBase.
* This class is used to invalidate the scene
*.
*
*/

/*namespace Courier {
template<class ViewSceneBase> class RenderTargetInvalidatingViewScene : public ViewSceneBase
{
   public:
      RenderTargetInvalidatingViewScene(bool managed = false) : ViewSceneBase(managed) { }
      virtual ~RenderTargetInvalidatingViewScene() { }

      virtual void Invalidate()
      {
         size_t idxSize = ViewSceneBase::GetCameraPtrVector().Size();
         for (Courier::Int32 idx = 0; idx < idxSize; idx++)
         {
            ViewSceneBase::GetViewHandler()->Invalidate(ViewSceneBase::GetCameraPtrVector()[idx]->GetRenderTarget());
         }
      }
};


}*/

SCENE_MAPPING_BEGIN(aScenes)
SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioMain),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioCategories),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioMenu),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioChannelList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioFavourite),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioCustomizeChannel),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioDirectTune),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_9_Charlayout),

                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmCheckAntenna),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmNoSignal),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmSubscriptionStatus),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioChannelNotAvailable),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioChannelNotSubsribed),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioAlertSongList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioAlertArtistList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioAlertSetting),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioFavoriteArtist),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioFavoriteSong),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioReplaceFavList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupChannelSkipped),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmPopupSubscriptionUpdated),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupCurrentlyTuneChannel),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmStmMain),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioTWN),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioTPopUpTWNNoInfo),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmTWNPopUpFavoriteCity),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmTestmodeMonitorSelection),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioSportsflashLeaguelist),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioSportsflashTeamlistLeague),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioSportsflashReplaceFavTeam),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupSportsflashTeamSelected),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupSportsFlashMaxFav),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupSportsGameAvail),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupSFNoGameAvail),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupSFReplay),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopUpDeleteAllFav),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopUpDeleteFav),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioSportsflashAlertList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioGadgetLarge),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmDTMPopupSxmSetting),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmDTMPopupResetSxmModule),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioSportsflashFavSportsteam),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupDeleteFavoriteTeam),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupFavContentAlert),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupSportsMonitorTeam),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioTPopUpSportsFlashActive),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioTPopUpSportsFlashReturn),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioTPopUpMonitoring),
					   SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmInfoList),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmTabMain),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmDtmMain),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioTPopUpAlertAll),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmSettingOption),
                       SCENE_MAPPING_ENTRY_2D(CGIAppViewController_SxmAudioPopupMaxFavContentReached),
                       SCENE_MAPPING_END()

                       CGIAppViewFactory::CGIAppViewFactory(): CGIAppViewFactoryBase(TABSIZE(aScenes), aScenes)
{
}


/**
*  This method is used to create a new scene when it is called.
* @param [in]= sViewName, type = Char*,<View name is passed as an input parameter>
* @param [out] = View*, type = Courier::View, <the created view returned to calling method>
*.@param [in, out] = none
* @return = Courier::View*
* @throws <NA>
*
* pre
* post
* bug = none
*/
Courier::View* CGIAppViewFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());

   /* Courier::View* view = SceneMapping::createView(sViewName, aScenes, TABSIZE(aScenes), GetViewHandler());
   if (view != NULL)
   {
      bool disableDiryRect = false;
      Courier::ViewId viewId = view->GetId();

      if (viewId == Courier::ViewId("Sxm#Scenes#SXM_SPORTS__SPORTS") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_SPORTS__TODAY") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_SPORTS__FUTURE") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_SPORTS__RECENT") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_FUEL__FAVORITES_LIST") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_FUEL__NEARBY_LIST") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_FUEL__DESTINATION_LIST") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_FUEL__FILTER") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_PARKING__FAVORITES_LIST") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_PARKING__NEARBY_LIST") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_PARKING__DESTINATION_LIST") ||
            viewId == Courier::ViewId("Sxm#Scenes#SXM_PARKING__FILTER"))
      {
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_TAB_MAIN"));
         disableDiryRect = true;
      }
      else if (viewId == Courier::ViewId("Sxm#Scenes#SXM_TAB_MAIN"))
      {
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_SPORTS__SPORTS"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_SPORTS__TODAY"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_SPORTS__FUTURE"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_SPORTS__RECENT"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_FUEL__FAVORITES_LIST"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_FUEL__NEARBY_LIST"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_FUEL__DESTINATION_LIST"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_FUEL__FILTER"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_PARKING__FAVORITES_LIST"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_PARKING__NEARBY_LIST"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_PARKING__DESTINATION_LIST"));
         view->AddInvalidationDependency(Courier::ViewId("Sxm#Scenes#SXM_PARKING__FILTER"));
         disableDiryRect = true;
      }
      //hmibase::ViewScene2D* viewScene = dynamic_cast<hmibase::ViewScene2D*>(view);
      // Courier::ViewScene2D* viewScene = dynamic_cast<Courier::ViewScene2D*>(view);
      // if (viewScene && disableDiryRect)
      // {
      // viewScene->UseDirtyRect(false);
      // }
   }
   return view;  */
}


/**
*  This method is used to destroy the scene when it is about to leave the state.
* @param [in]= pView, type = Char*,<View name is passed as an input parameter>
* @param [out] = void
*.@param [in, out] = none
* @return = none
* @throws <NA>
*
* pre
* post
* bug = none
*/
void CGIAppViewFactory::Destroy(Courier::View* pView)
{
   SceneMapping::destroyView(aScenes, TABSIZE(aScenes), pView);
}


/**
*  This method is used to create the view controller for the scene.
* @param [in]= sViewName, type = Char*,<View name is passed as an input parameter>
* @param [out] = Courier::ViewController
*.@param [in, out] = none
* @return = Courier::ViewController*
* @throws <NA>
*
* pre
* post
* bug = none
*/
Courier::ViewController* CGIAppViewControllerFactory::Create(const Courier::Char* sViewName)
{
   return SceneMapping::createViewController(sViewName, aScenes, TABSIZE(aScenes));
}


/**
*  This method is used to destroy the view controller .
* @param [in]= viewController, type = Courier::ViewController*,<Pointer to view controller>
* @param [out] = void
*.@param [in, out] = none
* @return = none
* @throws <NA>
*
* pre
* post
* bug = none
*/
void CGIAppViewControllerFactory::Destroy(Courier::ViewController* viewController)
{
   COURIER_UNUSED(viewController);
}


/****************************EOF***********************/
