/**
 * @file        :  CGIAppViewController_Sxm.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  Receive messages subscribed with 'View' here, when it has not been consumed by any widget
 * @copyright   :  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#if !defined (_CGIAPPVIEWCONTROLLER_SXM_H)
#define _CGIAPPVIEWCONTROLLER_SXM_H
#include "CgiExtensions/CourierMessageMapper.h"
/**
* tController is the template for the classes
* to be created for the newly added scene. Each
*.new scene added will have to add new declaration
* as shown below.
*/
#define SIMPLE_CONTROLLER(tController)\
class tController : public ViewControllerBase\
{\
   private:\
   courier_messages:\
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_CTRL_COMP)\
      COURIER_DUMMY_CASE(0)\
      COURIER_MSG_MAP_END()\
   public:\
      tController() {}\
      virtual ~tController() {}\
      static const char* _name;\
      static Courier::ViewController* createInstance()\
      {\
         return COURIER_NEW(tController)();\
      }\
};


//Scenes
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioMain)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioCategories)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioMenu)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioChannelList)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioFavourite)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioCustomizeChannel)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioDirectTune)
SIMPLE_CONTROLLER(CGIAppViewController_9_Charlayout)


SIMPLE_CONTROLLER(CGIAppViewController_SxmStmMain)
SIMPLE_CONTROLLER(CGIAppViewController_SxmDtmMain)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioFavoriteArtist)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioFavoriteSong)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioReplaceFavList)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioTWN)
SIMPLE_CONTROLLER(CGIAppViewController_SxmTestmodeMonitorSelection)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioSportsflashLeaguelist)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioSportsflashTeamlistLeague)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioSportsflashReplaceFavTeam)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioSportsflashAlertList)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioSportsflashFavSportsteam)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupDeleteFavoriteTeam)
SIMPLE_CONTROLLER(CGIAppViewController_SxmInfoList)



SIMPLE_CONTROLLER(CGIAppViewController_SxmTabMain)
SIMPLE_CONTROLLER(CGIAppViewController_SxmSettingOption)

//PopUps
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmCheckAntenna, 10)
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmNoSignal, 10)
SIMPLE_CONTROLLER(CGIAppViewController_SxmSubscriptionStatus)
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmAudioChannelNotAvailable, 10)
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmAudioChannelNotSubsribed, 10)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioAlertSongList)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioAlertArtistList)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioAlertSetting)
SIMPLE_CONTROLLER(CGIAppViewController_SxmTWNPopUpFavoriteCity)
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmAudioPopupChannelSkipped, 10)
SIMPLE_CONTROLLER(CGIAppViewController_SxmDTMPopupSxmSetting)
SIMPLE_CONTROLLER(CGIAppViewController_SxmDTMPopupResetSxmModule)
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmPopupSubscriptionUpdated, 10)
EXTENDED_VIEW_CONTROLLER(CGIAppViewController_SxmAudioPopupCurrentlyTuneChannel, 10)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupSportsflashTeamSelected)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupSportsFlashMaxFav)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioTPopUpTWNNoInfo)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupFavContentAlert)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupMaxFavContentReached)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupSportsMonitorTeam)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioTPopUpSportsFlashActive)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioTPopUpSportsFlashReturn)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioTPopUpMonitoring)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupSportsGameAvail)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupSFNoGameAvail)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopupSFReplay)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopUpDeleteAllFav)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioPopUpDeleteFav)
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioTPopUpAlertAll)

//Gadgets
SIMPLE_CONTROLLER(CGIAppViewController_SxmAudioGadgetLarge)


#endif // _CGIAPPVIEWCONTROLLER_SXM_H
