/* ***************************************************************************************
* FILE:          CGIAppController.h
* SW-COMPONENT:  HMI-BASE
*  DESCRIPTION:  CGIAppController.h is part of HMI-Base reference/demo/test applications
*    COPYRIGHT:  (c) 2017-2020 Robert Bosch Car Multimedia GmbH
*
* The reproduction, distribution and utilization of this file as well as the
* communication of its contents to others without express authorization is
* prohibited. Offenders will be held liable for the payment of damages.
* All rights reserved in the event of the grant of a patent, utility model or design.
*
*************************************************************************************** */

#ifndef CGIAPPCONTROLLER_H
#define CGIAPPCONTROLLER_H

#include "Common/CGIAppController/CGIAppControllerProject.h"

class CGIAppController : public CGIAppControllerProject
{
   courier_messages:
      COURIER_MSG_MAP_BEGIN(0)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(RenderingCompleteMsg)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_BEGIN()
      COURIER_MSG_DELEGATE_TO_CLASS(CGIAppControllerProject)
      COURIER_MSG_MAP_DELEGATE_DEFAULT_ENDS()
      COURIER_MSG_MAP_ENDS()

   public:
      using CGIAppControllerProject::onCourierMessage;
      virtual ~CGIAppController();
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      bool onCourierMessage(const RenderingCompleteMsg& oMsg);
      CGIAppController(hmibase::services::hmiappctrl::ProxyHandler& proxyHandler) : CGIAppControllerProject(proxyHandler) {}

   private:
      void sendTuneScanControlReq(uint8 mode);
};


#endif // CGIAPPCONTROLLER_H
