/**
 * @file        :  CGIApp.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  Class for CGI APP
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#ifndef _CGIAPP_H
#define _CGIAPP_H

#include "HMI/CGIComponents/CGIAppViewFactory.h"
#include "HMI/CGIComponents/CGIAppController.h"
#include "AppHmi_SxmStateMachine.h"
#include "Common/CGIAppView/CGIApplicationProject.hpp"

class CGIApp : public CgiApplicationProject <AppHmi_SxmStateMachineImpl>
{
   public:
      CGIApp(const char* assetFile, hmibase::services::hmiappctrl::ProxyHandler&);
      //  CGIApp(const std::vector<std::string>& assetFiles, hmibase::services::hmiappctrl::ProxyHandler&);
      virtual ~CGIApp();
};


#endif /* _CGIAPP_H */
