/**
 * @file        :  HMIModelComponent.cpp
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  SXM HALL class which contains all the necessary business logic required for SXM HMI
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#include "sys_std_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "hmi_trace_if.h"
//#include "gui_std_if.h" //when other headers also needed, include gui_std_if and remove above
#include "HMIModelComponent.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_APPHMI_SXM_DM
#include "trcGenProj/Header/HMIModelComponent.cpp.trc.h"
#endif

HMIModelComponent::HMIModelComponent() // : m_DummyData()
{
}


HMIModelComponent::~HMIModelComponent()
{
}


bool HMIModelComponent::Init()
{
   return true;
}


/**
 * @brief   : Incomming message for HMI data model a message component
 * @param   :
 */
bool HMIModelComponent::onCourierMessage(const Courier::StartupMsg& /*oMsg*/)
{
   return true;
}


//bool HMIModelComponent::onCourierMessage(const DummyChangedUpdMsg& oMsg)
//{
//   ETG_TRACE_COMP(("OnNewMessage(const DummyUpd"));
//   Courier::UInt32 const&   dummy = oMsg.GetDummyValue();
//
//   m_DummyData.SetValue(ItemKey::Dummy::Dummy_2Item, dummy);
//   m_DummyData.MarkItemModified(ItemKey::Dummy::DummyValueItem);
//   m_DummyData.SendUpdate(true);
//   return true;
//}
