/**
 * @file        : SxmUtilsSingleton.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Singleton interface
 * @copyright   : (c) 2017-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 */
#ifndef _SXMUTILSSINGLETON_H_
#define _SXMUTILSSINGLETON_H_

/*
 * template for Singleton-pattern
 */
template <typename C>
class SxmUtilsSingleton
{
   public:
      static C* instance()
      {
         if (!_instance)
         {
            _instance = new C;
         }
         return _instance;
      }

      virtual
      ~SxmUtilsSingleton()
      {
         _instance = 0;
      }
   private:
      //lint -esym(1704, SxmUtilsSingleton*::SxmUtilsSingleton*) prio3 constructor has private access specification
      SxmUtilsSingleton(const SxmUtilsSingleton<C>&);
      SxmUtilsSingleton& operator=(const SxmUtilsSingleton<C>&);
      static C* _instance;
   protected:
      SxmUtilsSingleton() { }
};


template <typename C> C* SxmUtilsSingleton <C>::_instance = 0;


#endif
