/**
 * @file        :  SxmUtilsListHandler.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 */
#ifndef _SxmUtilsListHandler_H_
#define _SxmUtilsListHandler_H_

#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/ListRegistry.h"
#include "AppHmi_SxmStateMachine.h"
#include "App/Core/SxmUtils/SxmUtilsSingleton.h"
#include "CgiExtensions/DataBindingItem.hpp"
#include "SxmCommonTypes.h"


namespace App {
namespace Core {

/**
 *
 * @class : SxmUtilsListHandler
 */
class SxmUtilsListHandler
   : public ListImplementation
   , public SxmUtilsSingleton<SxmUtilsListHandler>
{
   public:
      /**
       * SxmUtilsListHandler Class destructor
       */
      virtual ~SxmUtilsListHandler();
      /**
      * Callback to handle Courier Message ButtonReactionMsg Request
      */
      bool onCourierMessage(const ButtonReactionMsg& oMsg);
      /**
      * Callback to handle Courier Message ListChangedUpdMsg Request
      */
      bool onCourierMessage(const ListChangedUpdMsg& oMsg);
      /**
      * Callback to handle Courier Message ListDateProviderResMsg Request
      */
      bool onCourierMessage(const ListDateProviderResMsg& oMsg);
      /**
      * Callback to handle Courier Message Courier::StartupMsg Request
      */
      bool onCourierMessage(const Courier::StartupMsg& /*oMsg*/);
      /**
      * Callback to handle Courier Message FocusChangedUpdMsg Request
      */
      bool onCourierMessage(const FocusChangedUpdMsg& oMsg);
      /**
      * Callback to handle Courier Message SxmFooterListIdReqMsg Request
      */
      bool onCourierMessage(const SxmFooterListIdReqMsg& oMsg);
      /**
      * Helper Function to set selectedindex for a list.
      */
      void vSetSelectedIndex(uint16 listid, uint16 selectedindex);
      /**
      * Helper function to set list position.
      */
      bool SendListChangeMsg(::Courier::UInt32 const& aListId, ListChangeType const& aListChangeType, ::Courier::Int32 const& aValue);
      /**
      * Helper function to return the current start list index
      */
      uint32 getCurrentStartIndex();
      /**
      * Helper Function to Hide the focus for B screens when speedlock is active
      */
      void hideFocusOnSpeedLock();
      /**
       *Call back to handle Courier Message SxmTouchReqMsg
       */
      bool onCourierMessage(const SxmTouchReqMsg& oMsg);
      /**
      * Helper function to clear footer info.
      */
      void clearFooterInfo(uint32 listId, bool clearFooter);
      virtual tSharedPtrDataProvider getListDataProvider(const ListDataInfo& /*listDataInfo*/)
      {
         return tSharedPtrDataProvider();
      }

      bool onCourierMessage(const NavigationCarModeInfo& msg);
   private:

      friend class  SxmUtilsSingleton<SxmUtilsListHandler>;
      /**
        * SxmAudioListHelper Class private constructor
        */
      SxmUtilsListHandler();
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(ButtonReactionMsg)
      ON_COURIER_MESSAGE(ListChangedUpdMsg)
      ON_COURIER_MESSAGE(ListDateProviderResMsg)
      ON_COURIER_MESSAGE(Courier::StartupMsg)
      ON_COURIER_MESSAGE(FocusChangedUpdMsg)
      ON_COURIER_MESSAGE(SxmFooterListIdReqMsg)
      ON_COURIER_MESSAGE(SxmTouchReqMsg)
      ON_COURIER_MESSAGE(NavigationCarModeInfo)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      struct StructListInfo
      {
         uint32 currentListId;
         int32 startIndex;
         uint32 focusedIndex;
         uint32 listsize;
         uint8 direction;
         StructListInfo(): currentListId(0), startIndex(0), focusedIndex(0),
            listsize(0), direction(0) {}
      };

      //Member Variables
      Courier::ViewId _speedlockBviewName;
      bool _speedlockState;
      bool _isFocused;
      StructListInfo _activelistinfo;
      std::map<uint32, StructListInfo> _mbackListInfo;
      DataBindingItem<SxmUpdateFooterDataBindingSource> _mSxmUpdateFooter;
      DataBindingItem<CarModeVisibilityDataBindingSource> _carModeVisibilityStatus;

      /**
      * Helper Function to update footer info for a list.
      */
      void updateFooterInfo();

   protected:
};


}  // namespace Core
}  // namespace App

#endif
