/**
 * @file        :  SxmUtils.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  Header File for utility methods used within AppHmi SXM
 * @copyright   :  (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#ifndef SXMUTILS_H_
#define SXMUTILS_H_
#include "SxmCommonTypes.h"

#define SXM_UTILS_CREATE_OBJECT_WITH_0PARAM(mObj, mClass)    \
   mObj = new mClass();

#define SXM_UTILS_CREATE_OBJECT_WITH_1PARAM(mObj, mClass, mParam1)    \
   mObj = new mClass(mParam1);

#define SXM_UTILS_CREATE_OBJECT_WITH_2PARAM(mObj, mClass, mParam1, mParam2)    \
   mObj = new mClass(mParam1, mParam2);

#define SXM_UTILS_CREATE_OBJECT_WITH_3PARAM(mObj, mClass, mParam1, mParam2, mParam3)    \
   mObj = new mClass(mParam1, mParam2, mParam3);

#define SXM_UTILS_RELEASE_OBJECT(mPtr)    \
   if(NULL != mPtr) {                     \
      delete(mPtr);                       \
      mPtr = NULL;                        \
   }

#define SXM_UTILS_REGISTER_PROPERTY(mProxy, mPtr, proxy, state)          \
   if((NULL != mPtr) && (proxy == mProxy)) {                             \
      mPtr->registerProperties(proxy, state);                            \
   }

#define SXM_UTILS_DEREGISTER_PROPERTY(mProxy, mPtr, proxy, state)        \
   if((NULL != mPtr) && (proxy == mProxy)) {                             \
      mPtr->deregisterProperties(proxy, state);                          \
   }

#define SXM_UTILS_SERVICE_RESUMED(mProxy, mPtr, proxy)        			 \
   if((NULL != mPtr) && (proxy == mProxy)) {                             \
      mPtr->onServiceResumed(proxy);                         			 \
   }

#define SXM_UTILS_DELEGATE_REQUEST_WITH_0PARAM(mPtr, func)    \
   if(mPtr) {                                     \
      mPtr->func();                               \
   }

#define SXM_UTILS_DELEGATE_REQUEST_WITH_1PARAM(mPtr, func, mParam1)    \
   if(mPtr) {                                              \
      mPtr->func(mParam1);                                 \
   }

#define SXM_UTILS_DELEGATE_REQUEST_WITH_RETURN(mPtr, func, mParam1)    \
   if(mPtr) {                                              \
     mParam1 = mPtr->func();                                 \
   }

#define SXM_UTILS_REGISTER_PROPERTY_CALLBACKS(mPtr,mPtrClient,mProxy)      \
	if(mProxy){											\
      mPtr.registerPropertyRegistrationIF(mPtrClient, mProxy->getPortName()); \
	}

namespace App {
namespace Core {

class SxmUtils
{
   public:
      static std::string conCatData(std::string typeFormate, int listCount, ...);
      static std::string ComputePerDeltaChangeForStocks(float lMarketPrice, float lDeltaValue, ::std::string lDirection);
      static double calculateAirDistanceWithDirection(double destnLat, double destnlon, double curntlat, double curntlon);
      static double makeCircular(double degree);
      static double convertlatlongTodouble(signed int latlong);
      static int convertlatlongToWGS84(int latlong);
      static int convertWGS84ToLatLong(int latlongwsg);
      static bool bCheckLocationBoundary(double, double);
      static std::string convertToFeetInches(unsigned int inches);
      static std::string representConvertedFeetInches(unsigned int inches);
      static int FormatDirectionInfo(double dActualAngle, unsigned int modValue);
      static std::string convertTimestampToTime(unsigned int);
      static std::string getConvertedDate(time_t lEpochTime, unsigned int lIsShort, short unsigned int format);
      static signed short int ConvertTemperatureFromFToC(signed short int TempinF);
      static std::string replaceInTranslationTextID(std::string TranslationStr, std::string StrForReplace, std::string strToSearch);
      static unsigned int convertWindSpeedFromMPPHtoKPH(unsigned int winSpeed);
      static std::string safeGetCString(unsigned int textId);
      static std::string convertInchesToMeter(unsigned int inches);
      static unsigned int convertMillimeterToInches(unsigned int milliMeters);

   private:
      static double degrees2radians(double angle_degrees);
      static double radians2degrees(double angle_degrees);
      static std::string performDateFormatConversion(unsigned int dateFormatIndex, unsigned int day, unsigned int month, unsigned int year);
      static std::string getdatetext(unsigned int dateFormatIndex, std::string dayText, std::string monthText, std::string yearText);
};


} // end of namespace Core
} // end of namespace App

#endif /* SXMUTILS_H_ */
