/*
 * @file        :  SxmGui.h
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  Class which contains all the necessary business logic required to handle gui instance and gadgets
 * @copyright   :  (c) 2018-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 */
#ifndef SxmGui_h
#define SxmGui_h

/*
#include "AppBase/GuiComponentBase.h"
//#include "asf/core/ThreadBridge.h"
#include "hmi_trace_if.h"
#include "BaseContract/generated/BaseMsgs.h"
#include "HMIAppCtrl/Proxy/ProxyHandler.h"
#include "ProxyHandlerExt/ProxyHandlerExt.h"
#include "ProjectBaseMsgs.h"
#include "AppBase/IApplicationSettings.h"
*/

#include "AppBase/GuiComponentBase.h"
#include "HMIAppCtrl/Proxy/ProxyHandler.h"
#include "ProjectBaseMsgs.h"
#include "AppBase/IApplicationSettings.h"
#include "Common/AppBaseSettings/KeyMapping.h"


namespace App {
namespace Core {

class SxmGui :   public GuiComponentBase
{
   public:
      SxmGui();
      virtual ~SxmGui();

      virtual void preRun();
      virtual void postRun();

      static void TraceCmd_NotProcessedMsg(const unsigned char* pcu8Data);

   protected:
      //    virtual void getInitializationParameters(GuiComponentBase::SurfaceParameter&);
      virtual unsigned int getDefaultTraceClass();
      virtual void setupCgiInstance();
      //   bool onCourierMessage(const GuiStartupFinishedUpdMsg& msg);

      /*     COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
           ON_COURIER_MESSAGE(GuiStartupFinishedUpdMsg)
           COURIER_MSG_MAP_DELEGATE_START()
           COURIER_MSG_DELEGATE_TO_CLASS(GuiComponentBase)
           COURIER_MSG_MAP_DELEGATE_END()
      */
   private:

      void PersistentValuesRead();
      void PersistentValuesWrite();
      //HmiAppSxm::PersMemVars _mvar;
      //  asf::core::ThreadBridge* _pThreadBridge;
      // hmi::apphmi_sxm::ProxyHandlerExt _hmiAppCtrlProxyHandler;
      hmibase::services::hmiappctrl::ProxyHandler _hmiAppCtrlProxyHandler;
};


} // namespace Core
} // namespace App


#endif
