/**************************************************************************************
 * @file        : SxmTabListHandler.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Helper class to handle Tab switches.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMTABLISTHANDLER_H_
#define _SXMTABLISTHANDLER_H_
#include "CgiExtensions/DataBindingItem.hpp"
#include "asf/core/Types.h"
#include "App/Core/SxmCommon/ISxmTabListHandler.h"
#include "AppHmi_SxmStateMachine.h"
#include "AppHmi_SxmMessages.h"

namespace Courier {
class ViewId;
class Identifier;
}


namespace App {
namespace Core {
/**
 *
 * @class : SxmTabListHandler
 */
class SxmTabListHandler
   : public ISxmTabListHandler
{
   public:
      SxmTabListHandler();
      virtual ~SxmTabListHandler();
      virtual void addItem(uint8 index, const char* viewname, const char* buttonname, bool isEnable, uint32 tabButtonTextId);
      virtual void enableSelectedItemIndex(uint8 index, bool enable);
      virtual void setCurrentTabIndex(uint8 index, bool update);
      virtual uint8 getActiveTabIndex();
      virtual void updateSxmTabControlBindingData(uint8 serviceHeaderIndex);
      virtual void setHeaderText(unsigned int textId);
   private:

      struct TSxmTabModel
      {
         ::Courier::ViewId viewId;
         ::Courier::Identifier buttonId;
         bool isEnabled;
         uint32 buttonTextId;
      };
      std::vector<TSxmTabModel>_itemdata;
      uint8 _currentTabIndex;
      DataBindingItem<SxmTabControlListDataBindingSource> _sxmTabControlList;

      void setButtonBindingIndex(uint8 index);
      void setButtonActiveIndex(uint8 index);
      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(1)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()
};


}  // namespace Core
}  // namespace App

#endif
