/**************************************************************************************
 * @file        : SxmTabListHandler.cpp
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Helper class to handle Tab switches.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "SxmTabListHandler.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_SXMCOMMON
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX             App::Core::SxmTabListHandler::
#include "trcGenProj/Header/SxmTabListHandler.cpp.trc.h"
#endif


namespace App {
namespace Core {

SxmTabListHandler::SxmTabListHandler()
   : _currentTabIndex(0)
{
   _itemdata.clear();
}


SxmTabListHandler::~SxmTabListHandler()
{
   _itemdata.clear();
}


void SxmTabListHandler::addItem(uint8 /*index*/, const char* viewname, const char* buttonname, bool isEnable, uint32 tabButtonTextId)
{
   ETG_TRACE_USR4(("SxmAdvisories() addItem viewname:%s", viewname));
   ETG_TRACE_USR4(("SxmAdvisories() addItem buttonname:%s", buttonname));
   TSxmTabModel data;
   data.buttonId = ::Courier::Identifier(buttonname);
   data.viewId = ::Courier::ViewId(viewname);
   data.isEnabled = isEnable;
   data.buttonTextId = tabButtonTextId;
   //To do : Check the impact of creating all tab scenes on startup.
   // POST_MSG((COURIER_MESSAGE_NEW(::Courier::ViewReqMsg)(Courier::ViewAction::Create, data.viewId, true, true)));
   _itemdata.push_back(data);
}


void SxmTabListHandler::enableSelectedItemIndex(uint8 index, bool enable)
{
   ETG_TRACE_USR4(("SxmAdvisories() enableSelectedItemIndex index:%d,status:%d", index, enable));
   if (index < _itemdata.size())
   {
      _itemdata[index].isEnabled = enable;
      setButtonBindingIndex(index);
      _sxmTabControlList.SendUpdate(false);
   }
}


void SxmTabListHandler::setCurrentTabIndex(uint8 index, bool update)
{
   ETG_TRACE_USR4(("SxmAdvisories() setCurrentTabIndex index:%d", index));
   if (index < 3)
   {
      _currentTabIndex = index;
      (*_sxmTabControlList).mCurrentActiveTabIndex = _currentTabIndex;
      _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::CurrentActiveTabIndexItem);
      setButtonActiveIndex(_currentTabIndex);
      _sxmTabControlList.SendUpdate(false);
      if (update)
      {
         POST_MSG((COURIER_MESSAGE_NEW(SXMActiveTabUpdateMsg)()));
      }
   }
}


uint8 SxmTabListHandler::getActiveTabIndex()
{
   return _currentTabIndex;
}


void SxmTabListHandler::updateSxmTabControlBindingData(uint8 serviceHeaderIndex)
{
   size_t itemDataSize = _itemdata.size();
   for (uint8 idx = 0; idx < itemDataSize; ++idx)
   {
      setButtonBindingIndex(idx);
   }
   (*_sxmTabControlList).mCurrentServiceHeaderIndex = serviceHeaderIndex;
   (*_sxmTabControlList).mTab1ButtonNameText = Candera::String(_itemdata[SXMTAB_INDEX_1].buttonTextId);
   (*_sxmTabControlList).mTab2ButtonNameText = Candera::String(_itemdata[SXMTAB_INDEX_2].buttonTextId);
   (*_sxmTabControlList).mTab3ButtonNameText = Candera::String(_itemdata[SXMTAB_INDEX_3].buttonTextId);
   (*_sxmTabControlList).mTab4ButtonNameText = Candera::String(_itemdata[SXMTAB_INDEX_4].buttonTextId);
   (*_sxmTabControlList).mCurrentActiveTabIndex = _currentTabIndex;
   setButtonActiveIndex(_currentTabIndex);
   if (!serviceHeaderIndex)
   {
      (*_sxmTabControlList).mTab3BtnSwitchIndex = 0;
   }
   else
   {
      (*_sxmTabControlList).mTab3BtnSwitchIndex = 1;
   }
   _sxmTabControlList.SendUpdate(true);
}


void SxmTabListHandler::setButtonBindingIndex(uint8 index)
{
   if (index < _itemdata.size())
   {
      switch (index)
      {
         case SXMTAB_INDEX_1:
         {
            (*_sxmTabControlList).mIsTab1ButtonEnabled = _itemdata[index].isEnabled;
            _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab1ButtonEnabledItem);
            break;
         }
         case SXMTAB_INDEX_2:
         {
            (*_sxmTabControlList).mIsTab2ButtonEnabled = _itemdata[index].isEnabled;
            _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab2ButtonEnabledItem);
            break;
         }
         case SXMTAB_INDEX_3:
         {
            (*_sxmTabControlList).mIsTab3ButtonEnabled = _itemdata[index].isEnabled;
            _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab3ButtonEnabledItem);
            break;
         }
         case SXMTAB_INDEX_4:
         {
            (*_sxmTabControlList).mIsTab4ButtonEnabled = _itemdata[index].isEnabled;
            _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab4ButtonEnabledItem);
            break;
         }
         default:
         {
            break;
         }
      }
   }
}


void SxmTabListHandler::setButtonActiveIndex(uint8 index)
{
   (*_sxmTabControlList).mIsTab1ButtonActive = false;
   (*_sxmTabControlList).mIsTab2ButtonActive = false;
   (*_sxmTabControlList).mIsTab3ButtonActive = false;
   (*_sxmTabControlList).mIsTab4ButtonActive = false;
   switch (index)
   {
      case SXMTAB_INDEX_1:
      {
         (*_sxmTabControlList).mIsTab1ButtonActive = true;
         break;
      }
      case SXMTAB_INDEX_2:
      {
         (*_sxmTabControlList).mIsTab2ButtonActive = true;
         break;
      }
      case SXMTAB_INDEX_3:
      {
         (*_sxmTabControlList).mIsTab3ButtonActive = true;
         break;
      }
      case SXMTAB_INDEX_4:
      {
         (*_sxmTabControlList).mIsTab4ButtonActive = true;
         break;
      }
      default:
      {
         break;
      }
   }
   _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab1ButtonActiveItem);
   _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab2ButtonActiveItem);
   _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab3ButtonActiveItem);
   _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::IsTab4ButtonActiveItem);
}


void SxmTabListHandler::setHeaderText(unsigned int textId)
{
   (*_sxmTabControlList).mHeaderText = Candera::String(textId);
   _sxmTabControlList.MarkItemModified(ItemKey::SxmTabControlList::HeaderTextItem);
}


}  // namespace Core
}  // namespace App
