/**************************************************************************************
 * @file        : SXMCommonInterface.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM Common Interface.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMCOMMONINTERFACE_H_
#define _SXMCOMMONINTERFACE_H_

#include "ISxmCommon.h"
#include "ISxmHMIServiceStateHandler.h"
#include "List/Data/ListDataProviderDistributor.h"
#include "Common/DataModel/LockoutRestrictionTypes.h"


//Forward declration
struct TChannelInformation;

namespace App {
namespace Core {
/**
 *
 * @class : SXMCommonInterface
 */
class SXMCommonInterface
{
   public:
      /**
       * Register call back function to receive updates.
       */
      static void vRegisterNotification(ISxmCommon* _obsptr, enSXMServiceType enServiceType, enSXMEventNotificationType enEventType);
      /**
       * De-Register call back function to receive updates.
       */
      static void vDeregisterNotification(ISxmCommon* _obsptr, enSXMServiceType enServiceType, enSXMEventNotificationType enEventType);
      /**
       * Register call back function to receive HMI State chabge updates.
       */
      static void registerServiceEntryExitNotification(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType);
      /**
       *Register call back function for Application mode change updates
       */
      static void registerApplicationModeChangeNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType);
      /**
       * De-Register call back function to stop receiving updates.
       */
      static void deregisterServiceEntryExitNotification(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType);
      /**
       * De-Register call back function to stop receiving updates.
       */
      static void deregisterApplicationModeChangeNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType);
      /**
      *Register call back function for Application state updates
      */
      static void registerApplicationStateNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType);
      /**
       * De-Register call back function to stop receiving AppState updates.
       */
      static void deregisterApplicationStateNotication(ISxmHMIServiceStateHandler* _obsptr, enSXMServiceType enServiceType);
      /**
       * Helper Function to get current view or Popup name.
       */
      static unsigned int getActiveViewName(unsigned int uSurfaceId);
      /**
       * Helper Function to get active service state.
       */
      static unsigned int getActiveServiceState();
      /**
       * Helper Function to get service state of current data service.
       */
      static unsigned int getCurrentDataServiceState();
      /**
       * Helper Function to get appmode
       */
      static unsigned int getActiveAppMode();
      /**
       * Helper Function to get status of view visibility.
       */
      static bool isViewVisible(unsigned int viewid);
      /**
       * Helper Function to get status of application state.
       */
      static bool isSxmInForeground();
      /**
       * Helper Function to update map status bar.
       */
      static void updateMapStatusBar(TChannelInformation chnInfo);
      /**
      * Helper Function to set cache setting of dataprovider.
      */
      static void dataproviderCacheSetting(const tSharedPtrDataProvider& dataProvider, bool enableCache);
      /**
       *Helper Function to get Dataservice state
       */
      static enSXMDataServiceAdvisory getDataServiceStatus(const enSXMServiceType enServiceType);
      /**
       * Helper Function to get TargetContextId.
       */
      static unsigned int getTargetContextId();
      /**
       * Helper Function to set TargetContextId.
       */
      static void setTargetContextId(unsigned int tcontextId);
      /**
       * Helper Function to get gadget visibility
       */
      static bool getGadgetVisibility(enSXMServiceType serviceType);
      /**
       * Helper Function to get Speed Lock data from KDS
       */
      static bool getLockoutKdsStatus(lockoutKDSConfig lockoutkdsConfig);
};


}  // namespace Core
}  // namespace App

#endif
