/********************************************************************
 * @file         : ISxmHMIServiceStateHandler.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Interface adapter to handle Service state changes
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 ************************************************************************************/

#ifndef ISXMHMISERVICESTATEHANDLER_H_
#define ISXMHMISERVICESTATEHANDLER_H_


namespace App {
namespace Core {
/**
   @brief : SXM Common Interface to Notify HMI State changes for functional class.
   @class : ISxmHMIStateMgr
 */
class ISxmHMIServiceStateHandler
{
   public:
      virtual ~ISxmHMIServiceStateHandler() {};
      virtual void vNotifyServiceStatus(unsigned short int lEntryExitStatus, unsigned int serviceType) = 0;
      virtual void vNotifyAppModeChange(unsigned short int lactiveAppMode) = 0;
      virtual void vNotifyAppState(unsigned short int appState) = 0;
};


} //end of namespace Core
} //end of namespace App

#endif /* ISXMHMISERVICESTATEHANDLER_H_ */
