/**************************************************************************************
 * @file        : ISxmCommon.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM Common Interface to handle notification for functional class.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef ISXMCOMMON_H_
#define ISXMCOMMON_H_

#include <AppHmi_SxmTypes.h>

namespace App {
namespace Core {

/**
   @brief : SXM Common Interface to handle notification for functional class.
   @class : ISxmCommon
*/
class ISxmCommon
{
   public:
      virtual ~ISxmCommon() { } ;
      virtual void vNotifyAdvisoryStatus(enSXMServiceType enServiceType, enSXMDataServiceAdvisory enServiceState , enSXMEventNotificationType enEventType) = 0;
};


} //end of namespace Core
} //end of namespace App


#endif /* ILISTHANDLER_H_ */
