/**************************************************************************************
 * @file         : SxmAudioTWNow.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for Traffic and Weather Now.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SxmAudioTWNow_H_
#define _SxmAudioTWNow_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_SxmMessages.h"
#include "SxmAudioTypes.h"

namespace App {
namespace Core {

/**
 * Utility class which contains all the necessary business logic required to handle all Audio Lists.
 * @class : SxmTWNList
 */
class SxmAudioTWNow

   : public ::sxm_audio_main_fi::TWNowGetAvailableMarketsCallbackIF
   , public ::sxm_audio_main_fi::TWNowSetMarketCallbackIF
   , public ::sxm_audio_main_fi::TWNowServiceStatusCallbackIF
   , public ::sxm_audio_main_fi::TWNowBulletinStatusCallbackIF
   , public ::sxm_audio_main_fi::TWNowPlaybackStatusCallbackIF
   , public ::sxm_audio_main_fi::TWNowBulletinPlaybackCallbackIF
   , public ::sxm_audio_main_fi::TWNowEnableCallbackIF
   , public ::sxm_audio_main_fi::TWNowGetActiveMarketCallbackIF
   , public ::sxm_audio_main_fi::TWNowGetBulletinIDCallbackIF

{
   public:
      /**
       * SxmAudioTWNow Class constructor
       */
      SxmAudioTWNow(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy);
      /**
       * SxmTWNList Class destructor
       */
      virtual ~SxmAudioTWNow();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      /**********************************************************Middleware Callbacks*****************************************************/
      /**
        * Error handling function for get TWNowBulletinPlayback Method
        */
      void onTWNowBulletinPlaybackError(const ::boost::shared_ptr< ::sxm_audio_main_fi::  Sxm_audio_main_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowBulletinPlaybackError >& error);
      /**
       * Result handling function for get TWNowBulletinPlayback Method
       */
      void onTWNowBulletinPlaybackResult(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                         const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowBulletinPlaybackResult >& result);
      /**
        * Error handling function for get TWNowBulletinStatus Property
        */
      void onTWNowBulletinStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowBulletinStatusError >& error) ;
      /**
       * Status handling function for get TWNowBulletinStatus Property
       */
      void onTWNowBulletinStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowBulletinStatusStatus >& status);
      /**
        * Error handling function for get TWNowEnable Method
        */
      void onTWNowEnableError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                              const ::boost::shared_ptr< ::sxm_audio_main_fi::TWNowEnableError >& error) ;
      /**
       * Result handling function for get TWNowEnable Method
       */
      void onTWNowEnableResult(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                               const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowEnableResult >& result) ;
      /**
        * Error handling function for get TWNowGetActiveMarket Method
        */
      void onTWNowGetActiveMarketError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowGetActiveMarketError >& error);
      /**
      * Result handling function for get TWNowGetActiveMarket Method
      */
      void onTWNowGetActiveMarketResult(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                        const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowGetActiveMarketResult >& result);
      /**
        * Error handling function for get TWNowGetAvailableMarkets Method
        */
      void onTWNowGetAvailableMarketsError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                           const ::boost::shared_ptr< ::sxm_audio_main_fi::TWNowGetAvailableMarketsError >& error) ;
      /**
       * Result handling function for get TWNowGetAvailableMarkets Method
       */
      void onTWNowGetAvailableMarketsResult(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                            const ::boost::shared_ptr< ::sxm_audio_main_fi::TWNowGetAvailableMarketsResult >& result);
      /**
       * Error handling function for get TWNowServiceStatus Property
       */
      void onTWNowServiceStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                     const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowServiceStatusError >& error) ;
      /**
       * Error handling function for get TWNowServiceStatus Property
       */
      void onTWNowServiceStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowServiceStatusStatus >& status) ;
      /**
        * Error handling function for get TWNowSetMarket Method
        */
      void onTWNowSetMarketError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                 const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowSetMarketError >& error) ;
      /**
       * Result handling function for get TWNowSetMarket Method
       */
      void onTWNowSetMarketResult(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                  const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowSetMarketResult >& result) ;
      /**
       * Error handling function for get TWNowSetMarket Method
       */
      void onTWNowGetBulletinIDError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                     const ::boost::shared_ptr< ::sxm_audio_main_fi::TWNowGetBulletinIDError >& error);
      /**
       * Result handling function for get TWNowSetMarket Method
       */
      void onTWNowGetBulletinIDResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi::TWNowGetBulletinIDResult >& result);
      /**
       * Error handling function for get TWNowPlaybackStatus Property
       */
      void onTWNowPlaybackStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                      const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowPlaybackStatusError >& error) ;
      /**
       * Error handling function for get TWNowPlaybackStatus Property
       */
      void onTWNowPlaybackStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi:: Sxm_audio_main_fiProxy >& proxy,
                                       const ::boost::shared_ptr< ::sxm_audio_main_fi:: TWNowPlaybackStatusStatus >& status) ;
      /**
       * Helper Function to restore to factory default settings.
       */
      void restoreAudioTWNInfo(void);

   private:
      /**********************************************************Courier Message callbacks*****************************************************/
      /** Callback to handle Courier Message SxmTWNSettingsReqMsg Request
      *operator
      */
      bool onCourierMessage(const SxmTWNSettingsReqMsg& /*oMsg*/);
      /**
       * Callback to handle Courier Message ButtonReactionMsg Request
       */
      bool onCourierMessage(const SxmTWNButtonPressReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmTWNSettings Request
       */
      bool onCourierMessage(const SxmTWNListSelectReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsRefreshSFStatusReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsRefreshSFStatusReqMsg& oMsg);
      /**
       * Helper function to update bulletin status
       */
      void updateTWNBulletinStatus();

      /*
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SxmTWNSettingsReqMsg)
      ON_COURIER_MESSAGE(SxmTWNButtonPressReqMsg)
      ON_COURIER_MESSAGE(SxmTWNListSelectReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsRefreshSFStatusReqMsg)
      COURIER_MSG_MAP_DELEGATE_DEF_BEGIN()
      COURIER_MSG_MAP_DELEGATE_DEF_END()
      COURIER_MSG_MAP_DELEGATE_END()

      //Member Variable
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ::sxm_audio_main_fi_types::T_e8_FlashServiceStatus _twnServiceStatus;
      ::sxm_audio_main_fi_types::T_e8_TWNow_Bulletin_Status _bulletinStatus;
      uint32 _bulletinId;
      uint32 _buttonColor;
      bool _isMarketActive;
      SXMAudio_status _subStatus;
      ::sxm_audio_main_fi_types::T_e8_FlashEventPlaybackStatus _playbackStatus;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
