/**************************************************************************************
 * @file         : SxmAudioSportsFlash.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Functional class to handle business logic for SportsFlash.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMAUDIOSPORTSFLASH_H_
#define _SXMAUDIOSPORTSFLASH_H_

#include "sxm_audio_main_fiProxy.h"
#include "AppHmi_SxmMessages.h"
#include "Common/DataModel/ListRegistry.h"
#include "ISxmAudioChannelArtResponse.h"
#include "ISxmAudioChannelArtRequest.h"
#include "App/Core/SxmUtils/SxmCommonTypes.h"
#include "App/Core/SxmCommon/ISxmHMIServiceStateHandler.h"

namespace App {
namespace Core {
/**
 * Utility class which contains all the necessary business logic required to handle Sports Flash updates.
 * @class : SxmAudioSportsFlash
 */
class SxmAudioSportsFlash
   : public ListImplementation
   , public ::sxm_audio_main_fi::SportsFlashEnabledLeaguesCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashGetTeamsCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashGetAllFavoritesCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashAddFavoriteTeamCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashGetCurrentFlashEventsCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashRemoveFavoriteTeamCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashEnableNotificationCallbackIF
   , public ::sxm_audio_main_fi::SportsFlash_FlashEventNotificationCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashAbortFlashEventCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashPlayFlashEventCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashMonitorTeamsCallbackIF
   , public ::sxm_audio_main_fi::SportsFlash_ServiceStatusCallbackIF
   , public ::sxm_audio_main_fi::SportsFlashGetCurrentGamesCallbackIF
   , public ::sxm_audio_main_fi::SportsFlash_GameEventNotificationCallbackIF
   , public ::sxm_audio_main_fi::SportsFlash_PlaybackStatusCallbackIF
   , public ISxmAudioChannelArtResponse
   , public ISxmHMIServiceStateHandler
{
   public:
      /**
       * SxmAudioSportsFlash Class constructor
       */
      SxmAudioSportsFlash(::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > pSxmAudioFiProxy, ISxmAudioChannelArtRequest* pSxmChannelart);
      /**
       * SxmAudioSportsFlash Class destructor
       */
      virtual ~SxmAudioSportsFlash();
      /**
       * Utility function that registers for notifications updates from SXM Audio MIDW layer
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from SXM Audio MIDW layer
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);

      //****************************Middleware Callbacks******************************//
      /**
       * Error handling function for alert notification.
       */
      void onSportsFlash_FlashEventNotificationError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_FlashEventNotificationError >& /*error*/);
      /**
       * Status handling function for alert notification.
       */
      void onSportsFlash_FlashEventNotificationStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_FlashEventNotificationStatus >& /*status*/);
      /**
       * Error handling function for league list.
       */
      void onSportsFlashEnabledLeaguesError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashEnabledLeaguesError >& /*error*/);
      /**
       * Result handling function for league list.
       */
      void onSportsFlashEnabledLeaguesResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                             const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashEnabledLeaguesResult >& result);
      /**
       * Error handling function for team list for a league.
       */
      void onSportsFlashGetTeamsError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                      const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetTeamsError >& /*error*/);
      /**
       * Result handling function for team list for a league.
       */
      void onSportsFlashGetTeamsResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                       const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetTeamsResult >& result);
      /**
       * Error handling function for getting favorites team list.
       */
      void onSportsFlashGetAllFavoritesError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                             const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetAllFavoritesError >& /*error*/);
      /**
       * Result handling function for getting favorites team list.
       */
      void onSportsFlashGetAllFavoritesResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                              const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetAllFavoritesResult >& result);
      /**
       * Error handling function for adding team to favorites team list.
       */
      void onSportsFlashAddFavoriteTeamError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                             const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashAddFavoriteTeamError >& /*error*/);
      /**
       * Result handling function for adding team to favorites team list.
       */
      void onSportsFlashAddFavoriteTeamResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                              const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashAddFavoriteTeamResult >& result);
      /**
       * Error handling function for getting alert list.
       */
      void onSportsFlashGetCurrentFlashEventsError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetCurrentFlashEventsError >& /*error*/);
      /**
       * Result handling function for getting alert list.
       */
      void onSportsFlashGetCurrentFlashEventsResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetCurrentFlashEventsResult >& result);
      /**
       * Error handling function for delete a favorite Team.
       */
      void onSportsFlashRemoveFavoriteTeamError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashRemoveFavoriteTeamError >& /*error*/);
      /**
       * Result handling function for delete a favorite Team.
       */
      void onSportsFlashRemoveFavoriteTeamResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashRemoveFavoriteTeamResult >& result);
      /**
       * Error handling function for enabling the notifications.
       */
      void onSportsFlashEnableNotificationError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashEnableNotificationError >& /*error*/);
      /**
       * Result handling function for enabling the notifications.
       */
      void onSportsFlashEnableNotificationResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
            const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashEnableNotificationResult >& /*result*/);

      /*
       * Error handling function for sports flash abort
       */
      void onSportsFlashAbortFlashEventError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy,*/,
                                             const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashAbortFlashEventError >& error);
      /*
       * Result handling function for sports flash abort
       */
      void onSportsFlashAbortFlashEventResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& /*proxy*/,
                                              const ::boost::shared_ptr< ::sxm_audio_main_fi:: SportsFlashAbortFlashEventResult >& result);
      /*
       * Error handling function for Play Flash Event
       */
      void onSportsFlashPlayFlashEventError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                            const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashPlayFlashEventError >& error);
      /*
       * Result handling function for Play Flash Event
       */
      void onSportsFlashPlayFlashEventResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                             const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashPlayFlashEventResult >& result);
      /*
       * Error handling function for Flash Monitor Teams method.
       */
      void onSportsFlashMonitorTeamsError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                          const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashMonitorTeamsError >& error);
      /*
       * Result handling function for Flash Monitor Teams method.
       */
      void onSportsFlashMonitorTeamsResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                           const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashMonitorTeamsResult >& result);
      /*
       * Error handling function for Service Status Property
       */
      void onSportsFlash_ServiceStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                            const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_ServiceStatusError >& error);
      /*
       *Result handling function for Service Status Property
       */
      void onSportsFlash_ServiceStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                             const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_ServiceStatusStatus >& status) ;
      /*
       * Error handling function for Current Games method
       */
      void onSportsFlashGetCurrentGamesError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                             const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetCurrentGamesError >& error) ;
      /*
       * Result handling function for Current Games method
       */
      void onSportsFlashGetCurrentGamesResult(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                              const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlashGetCurrentGamesResult >& result);
      /*
       * Error handling function for  game Event Notification Property
       */
      void onSportsFlash_GameEventNotificationError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
            const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_GameEventNotificationError >& error);
      /*
       * Status handling function for game Event Notification Property
       */
      void onSportsFlash_GameEventNotificationStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
            const ::boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_GameEventNotificationStatus >& status);
      /**
       * Error handling function for alert notification.
       */
      void onSportsFlash_PlaybackStatusError(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                             const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_PlaybackStatusError >& error);
      /**
       * Status handling function for alert notification.
       */
      void onSportsFlash_PlaybackStatusStatus(const ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy >& proxy,
                                              const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_PlaybackStatusStatus >& status);
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoResult(const uint16& /*sid*/, const uint8& /*ChannelGraphicsType*/, const std::vector<uint8>& /*u8ImageData*/,
                                          const std::vector<uint8>& /*albumImageData*/) {}
      /**
        * Result handling function for GetChannelArt method.
        */
      virtual void onGetChannelArtListResult(const ::std::vector< ChannelGraphicsType >& channelArtList);
      /**
      * Result handling function for GetChannelArtList method.
      */
      virtual void onGetChannelArtListError();
      /**
       * Result handling function for GetChannelArt method.
       */
      virtual void onGetChannelLogoError(const uint16& sid);
      /**
       *  Call Back function for service status.
       */
      void vNotifyServiceStatus(unsigned short int lEntryExitStatus, unsigned int serviceType);
      /**
       * getListDataProvider : Gets the ListDataProvider from the corresponding list data provider functions
       */
      //tSharedPtrDataProvider getListDataProvider(const ListDataInfo& listDataInfo);
      tSharedPtrDataProvider getListDataProvider(const ListDateProviderReqMsg& listDataInfo);
      /**
       * Helper Function to restore to factory default settings.
       */
      void restoreAudioSFInfo(bool isRestore = true);
      /**
       *  Call Back function for system appmode status.
       */
      void vNotifyAppModeChange(unsigned short int lactiveAppMode);
      void vNotifyAppState(unsigned short int /*appState*/) {};

   private:

      //Member Functions
      /**
       * Callback to handle Courier Message SXMAudioSportsLeagueListReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsLeagueListReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsTeamListForLeagueReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsTeamListForLeagueReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsOnPressTeamNameReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsOnPressTeamNameReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsCloseOfMaxFavPopupReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsCloseOfMaxFavPopupReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsAlertListReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsAlertListReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsFavListReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsFavListReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsRefreshSFStatusReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsRefreshSFStatusReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsOnPressReplaceTeamNameReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsOnPressReplaceTeamNameReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsflashTurnAlertAllOnReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsflashTurnAlertAllOnReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SXMAudioSportsflashDeleteFavtTeamReqMsg Request
       */
      bool onCourierMessage(const SXMAudioSportsflashDeleteFavtTeamReqMsg& oMsg);
      /**
      * Callback to handle Courier Message SxmSFYesForAddPopupReqMsg Request
      */
      bool onCourierMessage(const SxmSFDisableMonitorReqMsg& oMsg);
      /**
       *Callback to handle Courier Message SxmSFYesForMonitorPopupReqMsg Request
       */
      bool onCourierMessage(const SxmSFYesForMonitorPopupReqMsg& oMsg);
      /**
       * Callback to handle Courier Message SxmSFButtonPressReqMsg Request
       */
      bool onCourierMessage(const SxmSFButtonPressReqMsg& oMsg);
      /*
       * Callback to handle Courier Message SxmSFTuneChannelReqMsg Request
       */
      bool onCourierMessage(const SxmSFTuneChannelReqMsg& oMsg);
      /*
       * Callback to handle Courier Message SxmSFReturnChannelReqMsg Request
       */
      bool onCourierMessage(const SxmSFReturnChannelReqMsg& oMsg);
      /*
       *  Callback to handle Courier Message SxmSFAlertCloseReqMsg
       */
      bool onCourierMessage(const SxmSFAlertCloseReqMsg& oMsg);
      /*
      * Callback to handle Courier Message SXMTuneSelectedChannelItemReqMsg
      */
      bool onCourierMessage(const SXMTuneSelectedChannelItemReqMsg& oMsg);
      /*
      * Callback to handle Courier Message SXMSportsBroadScopeUpdMsg
      */
      bool onCourierMessage(const SXMSportsBroadScopeUpdMsg& oMsg);
      /*
      * Callback to handle Courier Message SXMSourceStatusUpdMsg
      */
      bool onCourierMessage(const SXMSourceStatusUpdMsg& oMsg);
      /*
       * Helper function to Set Sports Flash Alert
       */
      void setSportsFlashAlertinfo(void);
      /**
       * To update the list data on middleware update.
       */
      void updateListInfo(unsigned int ListId);
      /*
       * Helper Function to update SF icon status
       */
      void updateSFIconStatus(void);
      /*
      * Helper Function to update SF datapool
      */
      void updateFavDatapool(void);
      /*
       * Helper Function to update SF teams
       */
      void updateFavTeams();
      /*
       * Helper Function to update SF advisory
       */
      void updateAdvisoryForSF();
      /*
      * Helper Function to read SF datapool
      */
      void readFromSFDatapool(void);
      /**
       * Helper Function to update all teams on / off status
       */
      void updateAllTeamsOnOff(bool bAlertStatus);
      /*
      * Helper Function to Get SF status
      */
      bool getSFStatus(void) const;
      /*
      * Helper Function to set SF status
      */
      void updateSFStatus(bool Status) const;
      /*
       *  Helper function to update Alert details.
       */
      void updateAlertPopupInfo();
      /*
       *  Helper function to post popup message
       */
      void postPopupMessageForSF(uint32 u32Popup) const;
      /*
       *  Helper function to handle sports flash notification
       */
      void handleSportFlashNotification(const boost::shared_ptr< ::sxm_audio_main_fi::SportsFlash_FlashEventNotificationStatus >& status);
      /*
       *  Helper function to handle sports flash playback on source change.
       */
      void handleSFPlaybackOnSourceChange(const enConnectionState& currentState, const enConnectionState& previousState);
      /*
       *  Helper function to getSxmSportsFlashAlertListAdvisory
       */
      const std::string getSxmSportsFlashAlertListAdvisory(bool lAdvType) const;
      /*
      *  Helper function to handle broad scope changes.
      */
      void handleBroadScopeChangesforSF();
      tSharedPtrDataProvider getSFListDataProvider(ListDataInfo listDataInfo);
      bool isPopupAllowed();

      /**
       * Courier Message Handler
       */
      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      ON_COURIER_MESSAGE(SXMAudioSportsLeagueListReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsTeamListForLeagueReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsOnPressTeamNameReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsCloseOfMaxFavPopupReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsAlertListReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsFavListReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsRefreshSFStatusReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsOnPressReplaceTeamNameReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsflashTurnAlertAllOnReqMsg)
      ON_COURIER_MESSAGE(SXMAudioSportsflashDeleteFavtTeamReqMsg)
      ON_COURIER_MESSAGE(SxmSFDisableMonitorReqMsg)
      ON_COURIER_MESSAGE(SxmSFYesForMonitorPopupReqMsg)
      ON_COURIER_MESSAGE(SxmSFButtonPressReqMsg)
      ON_COURIER_MESSAGE(SxmSFTuneChannelReqMsg)
      ON_COURIER_MESSAGE(SxmSFReturnChannelReqMsg)
      ON_COURIER_MESSAGE(SxmSFAlertCloseReqMsg)
      ON_COURIER_MESSAGE(SXMTuneSelectedChannelItemReqMsg)
      ON_COURIER_MESSAGE(SXMSportsBroadScopeUpdMsg)
      ON_COURIER_MESSAGE(SXMSourceStatusUpdMsg)
      COURIER_MSG_MAP_DELEGATE_START()
      COURIER_MSG_DELEGATE_TO_CLASS(ListImplementation)
      COURIER_MSG_MAP_DELEGATE_END()

      struct T_FlashEventInfo
      {
         uint32 FlashEventID;
         ::sxm_audio_main_fi_types::T_SportsFlash_Game GameInfo;
         ::sxm_audio_main_fi_types::T_e8_SportsFlash_FlashEventStatus FlashEventStatus;
         T_FlashEventInfo():
            FlashEventID(0),
            FlashEventStatus(::sxm_audio_main_fi_types::T_e8_SportsFlash_FlashEventStatus__SPORTS_FLASH_EVENT_OCCURED)
         {
            GameInfo.clear();
         }
         T_FlashEventInfo(uint32 lFlashEventID, ::sxm_audio_main_fi_types::T_SportsFlash_Game lGameInfo,
                          ::sxm_audio_main_fi_types::T_e8_SportsFlash_FlashEventStatus lFlashEventStatus)
         {
            FlashEventID = lFlashEventID;
            GameInfo = lGameInfo;
            FlashEventStatus = lFlashEventStatus;
         }
      };

      //Member Variable Declarations
      ::boost::shared_ptr< ::sxm_audio_main_fi::Sxm_audio_main_fiProxy > _sxmAudioFiProxy;
      ISxmAudioChannelArtRequest* _sxmChannelart;
      uint16 _selectedTeamId;
      uint8 _selectedLeagueId;
      uint32 _activeFlasheventId;
      std::string _selectedTeamName;
      uint8 _noOfFavorites;
      SXMAudio_status _subStatus;
      bool _replaceFavorite;
      bool _isTeamAvailForMonitor;
      bool _isActiveGamesAvailForMonitorTeam;
      bool _isTeamAddedOnSFSelection;
      bool _doTransition;
      bool _isContextChangeRequested;
      bool _isSFReturnSkPressed;
      bool _isSourceSwitchRequested;
      bool _isSFActivePopupVisible;
      bool _allowSFAlert;
      bool _popupCloseOnAppmodeChange;
      ::sxm_audio_main_fi_types::T_e8_FlashServiceStatus _sfServiceStatus;
      ::sxm_audio_main_fi_types::T_e8_SportsFlash_Sport _sportsType;
      ::sxm_audio_main_fi_types::T_e8_FlashEventPlaybackStatus _playbackStatus;
      ::std::vector< ::sxm_audio_main_fi_types::T_SportsFlash_MonitorTeam > _favoriteTeams;
      std::vector<T_FlashEventInfo>_activeSFEvents;
      ::std::vector< uint16 > _SportsAlertList;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
