/**************************************************************************************
 * @file         : ISxmAudioChannelArtRequest.h
 * @addtogroup   : AppHmi_Sxm
 * @brief        : Interface adapter to handle channel art request.
 * @copyright    : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                 The reproduction, distribution and utilization of this file as
 *                 well as the communication of its contents to others without express
 *                 authorization is prohibited. Offenders will be held liable for the
 *                 payment of damages. All rights reserved in the event of the grant
 *                 of a patent, utility model or design.
 **************************************************************************************/
#ifndef ISXMAUDIOCHANNELARTREQUEST_H_
#define ISXMAUDIOCHANNELARTREQUEST_H_

#include "ISxmAudioChannelArtResponse.h"

namespace App {
namespace Core {
/**
   @brief : Interface adapter to handle channel art request.
   @class : ISxmAudioChannelArtRequest
*/
class ISxmAudioChannelArtRequest
{
   public:
      virtual ~ISxmAudioChannelArtRequest() { } ;
      virtual void sendChannelLogoMethodRequest(ISxmAudioChannelArtResponse* client, const uint16& sid, const uint16& channelGraphicsType) = 0;
      virtual void sendChannelArtListMethodRequest(ISxmAudioChannelArtResponse* client, const ::std::vector< uint16 >& listOfSid, const uint16& channelGraphicsType) = 0;
      virtual bool isChannelArtServiceAvailable() = 0;
      virtual uint8 getChannelArtSubscriptionState() = 0;
      virtual void startLoadingTimer() = 0;
      virtual void stopLoadingTimer() = 0;
      virtual void clearAllChannelArtReq() = 0;
      virtual uint8 getChannelArtTimerStatus() = 0;
};


} //end of namespace Core
} //end of namespace App


#endif /* ISXMAUDIOCHANNELARTREQUEST_H_ */
