/**************************************************************************************
 * @file        : ProxyHandlerExt.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Used for Status bar and Launch bar activation
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef HMI_MEDIA_PROXYHANDLER_EXT_H
#define HMI_MEDIA_PROXYHANDLER_EXT_H

#include "HMIAppCtrl/Proxy/ProxyHandler.h"
#include "CgiExtensions/CourierMessageMapper.h" //to use courier macros
#include "hmi_trace_if.h"
#include <AppHmi_SxmMessages.h>

namespace hmi {
namespace apphmi_sxm {

/// this is the specialized proxy handler implementation
/// mainly to extend the original ProxyHandler by status line control functionality
class ProxyHandlerExt : public hmibase::services::hmiappctrl::ProxyHandler
{
   public:
      ProxyHandlerExt()
      {
      }
      virtual ~ProxyHandlerExt()
      {
      }

      virtual void onEvDisplayStatusEvalSignal(const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::HMIAppCtrlProxy >& /*proxy*/, const ::boost::shared_ptr< bosch::cm::ai::hmi::appctrl::HMIAppCtrl::EvDisplayStatusEvalSignal >& sig);

      COURIER_MSG_MAP_BEGIN(TR_CLASS_APPHMI_SXM_COURIER_PAYLOAD_MODEL_COMP)
      COURIER_DUMMY_CASE(0)
      COURIER_MSG_MAP_END()
   private:
};


}
}


#endif // HMI_MEDIA_PROXYHANDLER_EXT_H
