/**************************************************************************************
 * @file        : SXMVehicleService.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM vehicle utility class required to interact with MIDW vehicle Fi.
 * @copyright   : (C) 2016 Robert Bosch Engineering and Business Solutions Limited.
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMVehicle_H_
#define _SXMVehicle_H_

#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/SxmUtils/SxmUtilsSingleton.h"
#include "VEHICLE_MAIN_FIProxy.h"
#include "vehicle_main_fi_types.h"

namespace App {
namespace Core {

/**
 *  SXM Vehicle utility class required to interact with vehicle data common handler
 * @class : SXMVehicleService
 */
class SXMVehicleService
   : public SxmUtilsSingleton<SXMVehicleService>
   , public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public VEHICLE_MAIN_FI::SendXMInfoCallbackIF
   , public VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusCallbackIF
{
   public:
      /**
       * SXMVehicleService Class constructor
       */
      SXMVehicleService();
      /**
       * SXMVehicleService Class destructor
       */
      virtual ~SXMVehicleService();
      /**
       * Utility function that registers for notifications updates from vehicleservice.
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that deregisters for notifications updates from vehicleservice.
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Error handling function for sendXMInfo
       */
      virtual void onSendXMInfoError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendXMInfoError >& error);
      /**
       * Result handling function for sendXMInfo
       */
      virtual void onSendXMInfoResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::SendXMInfoResult >& result);
      /**
       * Error handling function for updateXMPresetStatus
       */
      virtual void onMediaStatusTunerPresetStatusError(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusError >& error);
      /**
       * Result handling function for updateXMPresetStatus
       */
      virtual void onMediaStatusTunerPresetStatusResult(const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy >& proxy, const ::boost::shared_ptr< ::VEHICLE_MAIN_FI::MediaStatusTunerPresetStatusResult >& result);
      /**
       * This function updates the SXM Advisory status to CAN
       */
      void sendXMInfoData(const int type, const std::string& dataInfo);
      /**
       * This function updates the SXM Preset status to CAN
       */
      void updateXMPresetStatus(const int presetId);
   private:
      friend class SxmUtilsSingleton<SXMVehicleService>;
      ::boost::shared_ptr< ::VEHICLE_MAIN_FI::VEHICLE_MAIN_FIProxy > _mPtrvehicleproxy;

   protected:
};


}  // namespace Core
}  // namespace App

#endif
