/**************************************************************************************
 * @file        : SXMSourceSwitchInterface.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : SXM Interface to get Source switch.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _SXMSourceSwitchInterface_H_
#define _SXMSourceSwitchInterface_H_

#include "asf/core/Types.h"
#include "App/Core/SxmUtils/SxmCommonTypes.h"

namespace App {
namespace Core {
//class sourceData;
/**
 *
 * @class : SXMSourceSwitchInterface
 */
class SXMSourceSwitchInterface
{
   public:
      /**
       * Helper function to get Sxm Source Status.
       */
      static uint8 getSxmSourceStatus(void);
      static uint8 getSxmNewsSourceStatus();
      /**
       * Helper function to get Sxm source active status
       */
      static bool isSxmSourceActive(void);
      /**
       * Helper function to handle Sxm source activation or deactivation.
       */
      static bool handleSourceChangeRequest(uint32 srcType, bool activate, bool forceactive, bool isAlert);
      /**
      * Helper function to set Sxm tune scan status.
      */
      static void setSxmAudioScanStatus(bool isActive);
      /**
       * Helper function to get Sxm Sports Flash source active status
       */
      static bool isSxmNewsSourceActive(void);
      /*
       * SXM Cabin Source deactivation request
       */
      static void requestSxmCabinSourceDeactivation(int srcid, int connectionState);
      /**
        * Helper function to send Source Activation request to Audio
       */
      static void requestSxmCabinSourceActivation(int srcid);
      static bool getSxmAudioScanStatus();

      static regionText getPopupText();

      static void setAlertSourceStatus();

      static uint8 getAlertSourceStatus();

      static int32 getPrevSource();

      static void setConnectionState(uint8 activeRegion);
      /**
       * Helper function to get Sink source status
       */
      static void getSinkSourceStatus(uint16 sinkId, int32& srcId, uint32& connStatus);
};


}  // namespace Core
}  // namespace App

#endif
