/**************************************************************************************
 * @file        :  SXMSourceSwitchInterface.cpp
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  SXM Interface to get Source switch.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "CgiExtensions/CourierMessageMapper.h"
#include "SXMSourceSwitchInterface.h"
#include "SXMSourceSwitch.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX             App::Core::SXMSourceSwitchInterface::
#include "trcGenProj/Header/SXMSourceSwitchInterface.cpp.trc.h"
#endif

namespace App {
namespace Core {
/**
 * Helper function to get Sxm Source Status.
 */
uint8 SXMSourceSwitchInterface::getSxmSourceStatus(void)
{
   return SXMSourceSwitch::instance()->getSxmSourceStatus();
}


/**
 * Helper function to get SXM News source status
 */
uint8 SXMSourceSwitchInterface::getSxmNewsSourceStatus()
{
   return SXMSourceSwitch::instance()->getSxmNewsSourceStatus();
}


/**
 * Helper function to get Sxm source active status
 */
bool SXMSourceSwitchInterface::isSxmSourceActive(void)
{
   return SXMSourceSwitch::instance()->isSxmSourceActive();
}


/**
 * Helper function to handle Sxm source activation or deactivation.
 * @param [in] : sourceType, activate, force active
 */
bool SXMSourceSwitchInterface::handleSourceChangeRequest(uint32 srcType, bool activate, bool forceactive, bool isAlert)
{
   return SXMSourceSwitch::instance()->handleSourceChangeRequest(srcType, activate, forceactive, isAlert);
}


/**
* Helper function to set Sxm tune scan status.
* @param [in] : tune scan active status
*/
void SXMSourceSwitchInterface::setSxmAudioScanStatus(bool isActive)
{
   SXMSourceSwitch::instance()->setSxmAudioScanStatus(isActive);
}


bool SXMSourceSwitchInterface::getSxmAudioScanStatus()
{
   return SXMSourceSwitch::instance()->getSxmAudioScanStatus();
}


/**
 * Helper function to get Sxm SF source active status
 */
bool SXMSourceSwitchInterface::isSxmNewsSourceActive(void)
{
   return SXMSourceSwitch::instance()->isSxmNewsSourceActive();
}


regionText SXMSourceSwitchInterface::getPopupText()
{
   return SXMSourceSwitch::instance()->getPopupText();
}


void SXMSourceSwitchInterface::setAlertSourceStatus()
{
   SXMSourceSwitch::instance()->setAlertSourceStatus();
}


uint8 SXMSourceSwitchInterface::getAlertSourceStatus()
{
   return SXMSourceSwitch::instance()->getAlertSourceStatus();
}


int32 SXMSourceSwitchInterface::getPrevSource()
{
   return SXMSourceSwitch::instance()->getPrevSource();
}


void SXMSourceSwitchInterface::setConnectionState(uint8 activeRegion)
{
   SXMSourceSwitch::instance()->setConnectionState(activeRegion);
}


/**
 * Helper function to send Source Deactivation request to Audio
 * @param[in]      : srcId: active sourceID
 * @param[in]      : connctionState: Connection State.
*/
void SXMSourceSwitchInterface::requestSxmCabinSourceDeactivation(int srcid, int connectionState)
{
   SXMSourceSwitch::instance()->requestSxmCabinSourceDeactivation(srcid, connectionState);
}


/**
 * Helper function to send Source Activation request to Audio
 * @param[in]      : srcId: active sourceID
*/
void SXMSourceSwitchInterface::requestSxmCabinSourceActivation(int srcid)
{
   SXMSourceSwitch::instance()->requestSxmCabinSourceActivation(srcid);
}


/**
 *  Helper function to get the sink source status
 * @param[in]      : sinkId: active sinkId
 * @param[in]      : srcId: active sourceID
 * @param[in]      : connStatus: Connection Status.
 */
void SXMSourceSwitchInterface::getSinkSourceStatus(uint16 sinkId, int32& srcId, uint32& connStatus)
{
   SXMSourceSwitch::instance()-> getSinkSourceStatus(sinkId, srcId, connStatus);
}


}  // namespace Core
}  // namespace App
