/**************************************************************************************
 * @file        : SxmHmiInfoService.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Client for HMI info service
 * @copyright   : (c) 2019-2020 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef SXM_HMI_INFO_SERVICE
#define SXM_HMI_INFO_SERVICE

#include "AppBase/ServiceAvailableIF.h"
#include "bosch/cm/ai/hmi/hmiinfoservice/HmiInfoServiceProxy.h"
#include "App/Core/SxmUtils/SxmUtilsSingleton.h"
#include "AppHmi_SxmTypes.h"
#include "AppHmi_MasterBase/AudioInterface/AudioDefines.h"

namespace App {
namespace Core {

#define HMI_INFO_NS ::bosch::cm::ai::hmi::hmiinfoservice::HmiInfoService

class SxmHmiInfoService
   : public SxmUtilsSingleton<SxmHmiInfoService>
   , public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public HMI_INFO_NS::LanguageStatusInfoCallbackIF
   , public HMI_INFO_NS::ToggleGadgetAudioSourceCallbackIF
   , public HMI_INFO_NS::ToggleGadgetAudioSourceRequestCallbackIF
   , public HMI_INFO_NS::CabinsSourceRestorationInfoCallbackIF
   , public HMI_INFO_NS::CabinsSystemsInfoCallbackIF
{
   public:
      SxmHmiInfoService();
      virtual ~SxmHmiInfoService();

      /**
      * Utility function that registers for notifications
      */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/,
                              const asf::core::ServiceStateChange& /*stateChange*/);
      /**
      * Utility function that deregisters for notifications
      */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& /*proxy*/,
                                const asf::core::ServiceStateChange& /*stateChange*/);
      /**
      * Utility function that registers for notifications
      */
      void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy,
                       const ::asf::core::ServiceStateChange& stateChange);
      /**
      * Utility function that deregisters for notifications
      */
      void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy,
                         const ::asf::core::ServiceStateChange& stateChange);
      /*
       *Language status error
       */
      void onLanguageStatusInfoError(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& /*proxy*/,
                                     const ::boost::shared_ptr< HMI_INFO_NS::LanguageStatusInfoError >& /*error*/);
      /*
       * Language status update
       */
      void onLanguageStatusInfoUpdate(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& /*proxy*/,
                                      const ::boost::shared_ptr< HMI_INFO_NS::LanguageStatusInfoUpdate >& update);
      /*
       * ToggleGadget AudioSource Error
       */
      void onToggleGadgetAudioSourceError(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& /*proxy*/,
                                          const ::boost::shared_ptr< HMI_INFO_NS::ToggleGadgetAudioSourceError >& /*error*/);
      /*
      * ToggleGadget AudioSource response
      */
      void onToggleGadgetAudioSourceResponse(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& /*proxy*/,
                                             const ::boost::shared_ptr< HMI_INFO_NS::ToggleGadgetAudioSourceResponse >& /*response*/);
      /*
      * ToggleGadget AudioSource Request Error
      */
      void onToggleGadgetAudioSourceRequestError(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& /*proxy*/,
            const ::boost::shared_ptr< HMI_INFO_NS::ToggleGadgetAudioSourceRequestError >& /*error*/);
      /*
      * ToggleGadget AudioSource Request Signal
      */
      void onToggleGadgetAudioSourceRequestSignal(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< HMI_INFO_NS::ToggleGadgetAudioSourceRequestSignal >& /*signal*/);
      /*
       * Cabins Source Restoration Info Error
       */
      virtual void onCabinsSourceRestorationInfoError(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< HMI_INFO_NS::CabinsSourceRestorationInfoError >& error);
      /*
      * Cabins Source Restoration Info Update
      */
      virtual void onCabinsSourceRestorationInfoUpdate(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& proxy,
            const ::boost::shared_ptr< HMI_INFO_NS::CabinsSourceRestorationInfoUpdate >& update);
      /*
        * Cabins Syaytems Info  Error
        */
      virtual void onCabinsSystemsInfoError(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& proxy,
                                            const ::boost::shared_ptr< HMI_INFO_NS::CabinsSystemsInfoError >& error);
      /*
      * Cabins Systems Info Update
      */
      virtual void onCabinsSystemsInfoUpdate(const ::boost::shared_ptr< HMI_INFO_NS::HmiInfoServiceProxy >& proxy,
                                             const ::boost::shared_ptr< HMI_INFO_NS::CabinsSystemsInfoUpdate >& update);
      /*
      * Send Toggle request
      */
      void sendToggleRequest(uint8 activeRegion);

   private:
      friend class SxmUtilsSingleton<SxmHmiInfoService>;
      ::boost::shared_ptr<HMI_INFO_NS::HmiInfoServiceProxy> _sxmHmiInfoServiceProxy;
      //member variable
      bool _disconnect_src;
};


#undef HMI_INFO_NS
}//Core
}//App

#endif //SXM_HMI_INFO_SERVICE
