/**************************************************************************************
 * @file        :  DiagnosticsClientInterface.cpp
 * @addtogroup  :  AppHmi_Sxm
 * @brief       :  SXM Interface to update SXM Run time Info.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#include "hmi_trace_if.h"
#include "DiagnosticsClientInterface.h"
#include "DiagnosticsClient.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS       TR_CLASS_APPHMI_SXM_HALL
#define ETG_I_TRACE_CHANNEL           TR_TTFIS_APPHMI_SXM
#define ETG_I_TTFIS_CMD_PREFIX        "APPHMI_SXM_"
#define ETG_I_FILE_PREFIX             App::Core::DiagnosticsClientInterface::
#include "trcGenProj/Header/DiagnosticsClientInterface.cpp.trc.h"
#endif

namespace App {
namespace Core {

/**
 * Helper function to Update SXM Timer Info.
 */
void DiagnosticsClientInterface::updateSXMRuntimeInfo(const uint32_t& seconds)
{
   ETG_TRACE_USR1(("DiagnosticsClientInterface UpdateTimerInfo"));
   DiagnosticsClient::instance()->updateSXMRuntimeInfo(seconds);
}


}  // namespace Core
}  // namespace App
