/**************************************************************************************
 * @file        : DiagnosticsClient.h
 * @addtogroup  : AppHmi_Sxm
 * @brief       : Diagnostics Client utility class required to handle source run time requests.
 * @copyright   : (c) 2019-2019 Robert Bosch Car Multimedia GmbH
 *                The reproduction, distribution and utilization of this file as
 *                well as the communication of its contents to others without express
 *                authorization is prohibited. Offenders will be held liable for the
 *                payment of damages. All rights reserved in the event of the grant
 *                of a patent, utility model or design.
 **************************************************************************************/
#ifndef _DiagnosticsClient_H_
#define _DiagnosticsClient_H_

#include "AppBase/ServiceAvailableIF.h"
#include "App/Core/SxmUtils/SxmUtilsSingleton.h"
#include "App/Core/SxmUtils/SxmCommonTypes.h"
#include "Midw_Diagnostics_FIProxy.h"

#ifndef MIDW_DIAGNOSTICS_FI_NAMESPACE
#define MIDW_DIAGNOSTICS_FI_NAMESPACE Midw_Diagnostics_FI
#endif

namespace App {
namespace Core {
/**
 * Diagnostics Client utility class required to handle source run time requests.
 * @class : DiagnosticsClient
 */
class DiagnosticsClient
   : public SxmUtilsSingleton<DiagnosticsClient>
   , public hmibase::ServiceAvailableIF
   , public StartupSync::PropertyRegistrationIF
   , public MIDW_DIAGNOSTICS_FI_NAMESPACE::SetRunTimeSourceDataCallbackIF

{
   public:

      /**
       * DiagnosticsClient Class constructor
       */
      DiagnosticsClient();
      /**
       * DiagnosticsClient Class destructor
       */
      virtual ~DiagnosticsClient();
      /**
       * Utility function that registers for notifications updates from PropertyRegistration Interface.
       */
      void registerProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      /**
       * Utility function that deregisters for notifications updates from PropertyRegistration Interface.
       */
      void deregisterProperties(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& stateChange);
      /**
       * Utility function that deregisters for notifications updates from ServiceAvailable Interface.
       */
      void onUnavailable(const boost::shared_ptr<asf::core::Proxy>& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
       * Utility function that registers for notifications updates from ServiceAvailable Interface.
       */
      void onAvailable(const ::boost::shared_ptr< asf::core::Proxy >& proxy, const asf::core::ServiceStateChange& /*stateChange*/);
      /**
        * Virtual function implemented to get update on Source Data Error
        */
      virtual void onSetRunTimeSourceDataError(const ::boost::shared_ptr< MIDW_DIAGNOSTICS_FI_NAMESPACE::Midw_Diagnostics_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< MIDW_DIAGNOSTICS_FI_NAMESPACE::SetRunTimeSourceDataError >& /*error*/);
      /**
        * Virtual function implemented to set Runtime Source Data Result
        */
      virtual void onSetRunTimeSourceDataResult(const ::boost::shared_ptr< MIDW_DIAGNOSTICS_FI_NAMESPACE::Midw_Diagnostics_FIProxy >& /*proxy*/,
            const ::boost::shared_ptr< MIDW_DIAGNOSTICS_FI_NAMESPACE::SetRunTimeSourceDataResult >& /*result*/);
      /**
      * Utility function that updates SXM run time.
      */
      void updateSXMRuntimeInfo(const uint32_t& seconds);

   private:
      friend class  SxmUtilsSingleton<DiagnosticsClient>;
      ::boost::shared_ptr< MIDW_DIAGNOSTICS_FI_NAMESPACE::Midw_Diagnostics_FIProxy > _diagnosticProxy;

   protected:
};


}  // namespace Core
}  // namespace App

#undef MIDW_DIAGNOSTICS_FI_NAMESPACE
#endif
